<?php

namespace Drupal\domain\EventSubscriber;

use Drupal\Core\DrupalKernel;
use Drupal\Core\Config\ConfigCrudEvent;
use Drupal\Core\Config\ConfigEvents;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Deletes the container if domain www_prefix setting has changed.
 */
class ConfigSubscriber implements EventSubscriberInterface {

  public function __construct(#[Autowire(service: 'kernel')] private DrupalKernel $kernel) {
  }

  /**
   * Causes the container to be rebuilt on the next request if necessary.
   *
   * @param \Drupal\Core\Config\ConfigCrudEvent $event
   *   The configuration event.
   */
  public function onConfigSave(ConfigCrudEvent $event) {
    $saved_config = $event->getConfig();
    if (!$saved_config->isNew() && $saved_config->getName() == 'domain.settings' && $event->isChanged('www_prefix')) {
      // Trigger a container rebuild on the next request by invalidating it.
      $this->kernel->invalidateContainer();
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[ConfigEvents::SAVE][] = ['onConfigSave', 0];
    return $events;
  }

}
