<?php

namespace Drupal\domain_boolean\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Plugin implementation of the 'domain_boolean_field' field type.
 *
 * @FieldType(
 *   id = "domain_boolean_field",
 *   label = @Translation("Domain Boolean"),
 *   description = @Translation("Stores boolean value per multiple domains."),
 *   category = @Translation("General"),
 *   default_widget = "domain_boolean_widget",
 *   default_formatter = "domain_boolean_formatter",
 * )
 */
class DomainBooleanField extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = [];
    $properties['value'] = DataDefinition::create('any')
      ->setLabel(t('Boolean per domain'))
      ->setRequired(FALSE);

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $columns = [
      'value' => [
        'type' => 'blob',
        'size' => 'big',
        'serialize' => TRUE,
        'not null' => FALSE,
        'description' => 'Serialized array of domain IDs and their boolean status.',
      ],
    ];

    return [
      'columns' => $columns,
      'indexes' => [],
      'foreign keys' => [],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $value = $this->get('value')->getValue();
    return $value === NULL || (is_array($value) && empty($value));
  }

  /**
   * {@inheritdoc}
   */
  public function preSave() {
    $value = $this->get('value')->getValue();
    if (!is_array($value)) {
      $this->set('value', []);
    }
  }

}
