# Domain Masquerade

Domain Masquerade allows authorized users to view a Drupal multi-domain
installation from the perspective of a different domain without changing the
URL. This is particularly useful for administrators and content managers who
need to test and verify domain-specific content, configurations, and access
controls across multiple domains.


## Features

- Session-based domain switching for authorized users
- Domain switcher block for easy navigation between domains
- Admin routes always use real domain (no masquerade override)
- Automatic validation and cleanup of invalid masquerade states
- Decorator pattern integration with Domain module's negotiator
- Comprehensive permission system for access control


## Requirements

This module requires the following:

- Drupal core 10.3 or higher, or Drupal 11
- [Domain module](https://www.drupal.org/project/domain)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the Domain Masquerade module at `/admin/modules`.

2. Configure permissions at `/admin/people/permissions`:
   - Grant the "Masquerade as any domain" permission to roles that need to
     switch between domains. This permission is restricted by default.

3. Place the "Domain Masquerade Switcher" block:
   - Navigate to `/admin/structure/block`.
   - Place the "Domain Masquerade Switcher" block in your desired region.
   - The block will only display to users with the masquerade permission.

4. Use the domain switcher:
   - Click on any domain link in the switcher block to view the site as if you
     were on that domain.
   - Click "Clear masquerade" to return to the real domain.
   - The masquerade state persists across page loads within your session.


## How It Works

### Domain Negotiation

The module decorates the Domain module's negotiator service to override the
active domain when masquerade is active. On frontend routes, the decorator
returns the masqueraded domain instead of the negotiated domain. Admin routes
always use the real domain to prevent configuration issues.

### Session Storage

The masqueraded domain ID is stored in the user's session. The module validates
the domain exists and is active on each request, automatically clearing invalid
masquerade states.

### Routes

The module provides two routes:

- `/domain-masquerade/switch/{domain_id}` - Switches to the specified domain
- `/domain-masquerade/clear` - Clears the current masquerade state

Both routes require the "masquerade as domain" permission and support a
destination query parameter for redirects.


## Architecture

### Services

- `domain_masquerade.manager` - Manages masquerade state via session storage
- `domain.negotiator` - Decorator that overrides Domain module's negotiator
- `domain_masquerade.event_subscriber` - Validates masquerade state on requests

### Key Classes

- `DomainMasqueradeManager` - Service implementation for masquerade operations
- `DomainNegotiatorDecorator` - Extends Domain's negotiator to support
  masquerade
- `DomainMasqueradeSwitcherBlock` - Block plugin for domain switching UI
- `DomainMasqueradeController` - Handles switch and clear routes
- `DomainMasqueradeSubscriber` - Validates masquerade state on each request


## Testing

The module includes comprehensive test coverage:

- Unit tests for manager, decorator, and block plugin
- Kernel tests for integration with Domain module
- Functional tests for controller and event subscriber

Run tests with PHPUnit:

```bash
# Run all module tests
phpunit web/modules/custom/domain_masquerade

# Run specific test suites
phpunit --testsuite=unit --filter=domain_masquerade
phpunit --testsuite=kernel --filter=domain_masquerade
```


## Security Considerations

- The "masquerade as domain" permission is marked as restricted and should only
  be granted to trusted roles.
- Admin routes cannot be masqueraded to prevent configuration tampering.
- Domain validation occurs on every request to prevent access to deleted or
  disabled domains.
- The module uses session storage, which is automatically protected by Drupal's
  session security.


## Use Cases

- **Content Management**: Preview domain-specific content without switching
  domains
- **Testing**: Verify domain-specific configurations and access controls
- **Development**: Debug multi-domain issues without browser profile switching
- **Quality Assurance**: Test cross-domain functionality in a single session

