<?php

declare(strict_types=1);

namespace Drupal\Tests\domain_masquerade\Kernel;

use Drupal\domain\Entity\Domain;
use Drupal\KernelTests\KernelTestBase;
use Drupal\user\Entity\Role;
use Drupal\user\Entity\User;

/**
 * Base class for Domain Masquerade kernel tests.
 */
abstract class DomainMasqueradeKernelTestBase extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'user',
    'field',
    'domain',
    'domain_masquerade',
  ];

  /**
   * Test domain entities.
   *
   * @var \Drupal\domain\DomainInterface[]
   */
  protected $domains = [];

  /**
   * Test user with masquerade permission.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $authorizedUser;

  /**
   * Test user without masquerade permission.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $unauthorizedUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('domain');
    $this->installSchema('system', ['sequences']);
    $this->installConfig(['domain', 'domain_masquerade']);

    // Create test domains.
    $this->domains['main'] = Domain::create([
      'id' => 'main_domain',
      'hostname' => 'main.example.com',
      'name' => 'Main Domain',
      'status' => TRUE,
    ]);
    $this->domains['main']->save();

    $this->domains['secondary'] = Domain::create([
      'id' => 'secondary_domain',
      'hostname' => 'secondary.example.com',
      'name' => 'Secondary Domain',
      'status' => TRUE,
    ]);
    $this->domains['secondary']->save();

    $this->domains['inactive'] = Domain::create([
      'id' => 'inactive_domain',
      'hostname' => 'inactive.example.com',
      'name' => 'Inactive Domain',
      'status' => FALSE,
    ]);
    $this->domains['inactive']->save();

    // Create role with masquerade permission.
    $role = Role::create([
      'id' => 'masquerade_role',
      'label' => 'Masquerade Role',
    ]);
    $role->grantPermission('masquerade as domain');
    $role->save();

    // Create authorized user.
    $this->authorizedUser = User::create([
      'name' => 'authorized_user',
      'mail' => 'authorized@example.com',
      'status' => 1,
    ]);
    $this->authorizedUser->addRole('masquerade_role');
    $this->authorizedUser->save();

    // Create unauthorized user.
    $this->unauthorizedUser = User::create([
      'name' => 'unauthorized_user',
      'mail' => 'unauthorized@example.com',
      'status' => 1,
    ]);
    $this->unauthorizedUser->save();
  }

}
