<?php

namespace Drupal\domain_menu_links\Plugin\Menu;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Menu\MenuLinkDefault;
use Drupal\Core\Menu\StaticMenuLinkOverridesInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Domain menu parent link class.
 *
 * @Menu(
 *   id = "domain_menu_links.domain",
 *   deriver = "Drupal\Core\Menu\MenuLinkDefault"
 * )
 */
class DomainMenu extends MenuLinkDefault {

  /**
   * Constructs a new DomainMenu.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $pluginId
   *   The plugin ID for the plugin instance.
   * @param mixed $pluginDefinition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Menu\StaticMenuLinkOverridesInterface $staticOverride
   *   The static override storage.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The factory for configuration objects.
   */
  public function __construct(
    array $configuration,
    $pluginId,
    $pluginDefinition,
    StaticMenuLinkOverridesInterface $staticOverride,
    protected ConfigFactoryInterface $configFactory,
  ) {
    parent::__construct($configuration, $pluginId, $pluginDefinition, $staticOverride);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('menu_link.static.overrides'),
      $container->get('config.factory'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight() {
    $config = $this->configFactory->get('domain_menu_links.settings');

    return $config->get('parent_menu_link_weight');
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheContexts(): array {
    return ['url.site'];
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags(): array {
    return ['domain_list'];
  }

}
