<?php

namespace Drupal\domain_menu_links\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Menu\MenuLinkManagerInterface;
use Drupal\domain_menu_links\DomainMenuLinksConstants;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Module configuration form.
 */
class DomainMenuLinksSettingsForm extends ConfigFormBase {

  /**
   * DomainMenuLinksSettingsForm constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory for the form.
   * @param \Drupal\Core\Config\TypedConfigManagerInterface $typedConfigManager
   *   The typed config manager.
   * @param \Drupal\Core\Menu\MenuLinkManagerInterface $menuLinkManager
   *   A menu link manager instance.
   */
  public function __construct(
    ConfigFactoryInterface $configFactory,
    TypedConfigManagerInterface $typedConfigManager,
    protected MenuLinkManagerInterface $menuLinkManager,
  ) {
    parent::__construct($configFactory, $typedConfigManager);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): object {
    return new static(
      $container->get('config.factory'),
      $container->get('config.typed'),
      $container->get('plugin.manager.menu.link')
    );
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return [
      DomainMenuLinksConstants::SETTINGS,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'domain_menu_links_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config(DomainMenuLinksConstants::SETTINGS);

    $form[DomainMenuLinksConstants::MENU_WEIGHT_FIELD] = [
      '#type' => 'number',
      '#title' => $this->t('Parent menu link weight'),
      '#default_value' => $config->get(DomainMenuLinksConstants::MENU_WEIGHT_FIELD) ?? -11,
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config(DomainMenuLinksConstants::SETTINGS)
      ->set(DomainMenuLinksConstants::MENU_WEIGHT_FIELD, $form_state->getValue(DomainMenuLinksConstants::MENU_WEIGHT_FIELD))
      ->save();

    parent::submitForm($form, $form_state);
    $this->menuLinkManager->rebuild();
  }

}
