<?php

declare(strict_types=1);

namespace Drupal\Tests\domain_menu_links\Functional;

use Drupal\Core\Database\Connection;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\domain_menu_links\Traits\DomainMenuLinksTestTrait;

/**
 * Base class for tests.
 *
 * @package Drupal\Tests\domain_menu_links\Functional
 *
 * @group domain_menu_links
 */
abstract class DomainMenuLinksTestBase extends BrowserTestBase {

  use DomainMenuLinksTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'toolbar',
    'admin_toolbar',
    'domain',
    'domain_menu_links',
    'user',
  ];

  /**
   * {@inheritdoc}
   */
  protected $profile = 'standard';

  /**
   * The database connection.
   */
  protected Connection $database;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Set the base hostname for domains.
    /** @var \Drupal\domain\DomainStorageInterface $storage */
    $storage = \Drupal::entityTypeManager()->getStorage('domain');
    $this->baseHostname = $storage->createHostname();

    // Ensure that $this->baseTLD is set.
    $this->setBaseDomain();

    $this->database = \Drupal::database();
  }

  /**
   * Add modules for tests.
   *
   * @param array|string[] $modules
   *   Array of modules names.
   */
  protected function addModules(array $modules): void {
    self::$modules[] = $modules;
  }

}
