<?php

declare(strict_types=1);

namespace Drupal\Tests\domain_menu_links\Kernel;

use Drupal\Core\Menu\MenuTreeParameters;
use Drupal\Core\Render\BubbleableMetadata;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\domain_menu_links\Traits\DomainMenuLinksTestTrait;

/**
 * Test menu links cache.
 *
 * @group domain_menu_links
 */
class DomainMenuLinksCacheTest extends KernelTestBase {

  use DomainMenuLinksTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'domain',
    'domain_menu_links',
    'toolbar',
    'admin_toolbar',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->domainCreateTestDomains(5);
  }

  /**
   * Test if domain link has the same cache settings as the Domain entity.
   *
   * @todo test parent link cache.
   */
  public function testMenuLinkCacheSetting(): void {
    $menu_tree = \Drupal::menuTree();
    $renderer = \Drupal::service('renderer');

    $tree = $menu_tree->load('admin', new MenuTreeParameters());
    $domain_subtree = $tree['system.admin']->subtree['domain_menu_links.domain']->subtree;

    $domains = $this->getDomainsSorted();

    foreach ($domains as $key => $domain) {
      if ($key > 0) {
        $build = $menu_tree->build([current($domain_subtree)]);
        $renderer->renderRoot($build);
        $menu_link_cache = BubbleableMetadata::createFromRenderArray($build);
        $domain_cache = BubbleableMetadata::createFromObject($domain);

        $missing_contexts = array_diff($domain_cache->getCacheContexts(), $menu_link_cache->getCacheContexts());
        $this->assertEmpty($missing_contexts, 'The second array does not contain all values from the first array.');

        $missing_tags = array_diff($domain_cache->getCacheTags(), $menu_link_cache->getCacheTags());
        $this->assertEmpty($missing_tags, 'The second array does not contain all values from the first array.');
      }

      next($domain_subtree);
    }
  }

}
