<?php

namespace Drupal\Tests\domain_menu_links\Functional;

use Drupal\domain_menu_links\DomainMenuLinksConstants;
use Drupal\user\UserInterface;

/**
 * Tests for the module configuration form.
 *
 * @coversDefaultClass \Drupal\domain_menu_links\Form\DomainMenuLinksSettingsForm
 *
 * @group domain_menu_links
 */
class DomainMenuLinksSettingsFormTest extends DomainMenuLinksTestBase {

  /**
   * A user with access to the Admin Toolbar settings form permission.
   */
  protected UserInterface|false $adminUser;

  /**
   * The settings page path.
   */
  protected string $settingsPagePath;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $route_provider = \Drupal::service('router.route_provider');
    $route = $route_provider->getRouteByName('domain_menu_links.settings');
    $this->settingsPagePath = $route->getPath();
    $permissions = $route->getRequirement('_permission');

    $this->adminUser = $this->drupalCreateUser([$permissions]);
  }

  /**
   * Test form access.
   */
  public function testAccess(): void {
    // Admin user should access the page.
    $this->drupalLogin($this->adminUser);
    $this->drupalGet($this->settingsPagePath);
    $this->assertSession()->statusCodeEquals(200);

    // A non-admin user shouldn't access the page.
    $editor = $this->drupalCreateUser(['access administration pages']);
    $this->drupalLogin($editor);
    $this->drupalGet($this->settingsPagePath);
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Test backend settings form fields and submission.
   *
   * @covers ::buildForm
   * @covers ::submitForm
   */
  public function testSubmitForm(): void {
    $assert_session = $this->assertSession();

    $this->drupalLogin($this->adminUser);
    $this->drupalGet($this->settingsPagePath);
    $assert_session->fieldEnabled(DomainMenuLinksConstants::MENU_WEIGHT_FIELD);

    $menu_weight = 123;
    $edit[DomainMenuLinksConstants::MENU_WEIGHT_FIELD] = $menu_weight;
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('The configuration options have been saved.');

    $config_menu_weight = $this->config(DomainMenuLinksConstants::SETTINGS)->get(DomainMenuLinksConstants::MENU_WEIGHT_FIELD);
    $this->assertEquals($menu_weight, $config_menu_weight, 'Menu link weight is not the same as the configuration.');
  }

}
