<?php

namespace Drupal\Tests\domain_menu_links\Traits;

use Drupal\Tests\domain\Traits\DomainTestTrait;

/**
 * Contains helper methods for tests.
 *
 * @group domain_menu_links
 */
trait DomainMenuLinksTestTrait {

  use DomainTestTrait;

  /**
   * Returns an uncached list of all enabled domains, sorted by weight.
   *
   * @return \Drupal\domain\DomainInterface[]
   *   An array of domain entities.
   */
  public function getDomainsSorted(): array {
    /** @var \Drupal\domain\DomainStorageInterface $storage */
    $storage = \Drupal::entityTypeManager()->getStorage('domain');
    $storage->resetCache();

    $domains = $storage->loadMultipleSorted();
    $domains = array_values($domains);

    return array_filter($domains, function ($domain) {
      /** @var \Drupal\domain\Entity\Domain $domain */
      return $domain->status();
    });
  }

}
