<?php

namespace Drupal\domain_path_pathauto;

use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;
use Drupal\domain_access\DomainAccessManager;
use Drupal\domain_path\Plugin\Field\FieldType\DomainPathItem;

/**
 * Extends the default PathItem implementation to generate aliases.
 */
class DomainPathautoItem extends DomainPathItem {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);
    $properties['pathauto'] = DataDefinition::create('integer')
      ->setLabel(t('Pathauto state'))
      ->setDescription(t('Whether an automated alias should be created or not.'))
      ->setComputed(TRUE)
      ->setClass(DomainPathautoState::class);
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public function postSave($update) {
    if ($this->pathauto == DomainPathautoState::CREATE) {
      $domain_id = $this->get('domain_id')->getValue();
      if (empty($domain_id)) {
        $active = \Drupal::service('domain.negotiator')->getActiveDomain();
        if ($active) {
          $uid = $this->getEntity()->getOwnerId();
          $user = \Drupal::service('entity_type.manager')->getStorage('user')->load($uid);
          if ($user->hasPermission('publish to any domain')
            || DomainAccessManager::getAllValue($user)
            || isset(DomainAccessManager::getAccessValues($user)[$active->id()])) {
            $domain_id = $active->id();
            $this->set('domain_id', $domain_id);
          }
        }
      }
      $alias = \Drupal::service('domain_path_pathauto.generator')->createEntityAlias(
        $this->getEntity(), 'return', $domain_id);
      $this->set('alias', $alias);
    }
    $result = parent::postSave($update);
    $this->get('pathauto')->persist();
    return $result;
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    // Make sure that the pathauto state flag does not get lost if just that is
    // changed.
    return parent::isEmpty() && !$this->get('pathauto')->hasValue();
  }

}
