<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Constraint for creating domain alias that does not already exist.
 *
 * @Constraint(
 *   id = "DomainPathUnique",
 *   label = @Translation("Domain path must not already exist.", context = "Validation"),
 * )
 */
class DomainPathUniqueConstraint extends Constraint {

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = 'The alias %alias for %domain matches an existing domain path alias.';

}
