<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Constraint for creating domain alias for users without access to domain.
 *
 * @Constraint(
 *   id = "DomainPathUserAccess",
 *   label = @Translation("Domain path.", context = "Validation"),
 * )
 */
class DomainPathUserAccessConstraint extends Constraint {

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = "You don't have access to this domain.";

}
