<?php

namespace Drupal\Tests\domain_path\Functional;

use Drupal\Tests\domain\Functional\DomainTestBase;

/**
 * Base class for Domain Path functional tests.
 */
abstract class DomainPathTestBase extends DomainTestBase {

  /**
   * The test domains list.
   *
   * @return \Drupal\domain\DomainInterface[]
   *   An array of domain entities.
   */
  protected array $domains;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_path',
    'domain_access',
    'field',
    'user',
    'path',
    'system',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create domains.
    $this->domainCreateTestDomains(2);
    $this->domains = $this->getDomains();
    $this->domainPathBasicSetup();
  }

  /**
   * Basic setup.
   */
  public function domainPathBasicSetup(): void {
    $admin = $this->drupalCreateUser([
      'bypass node access',
      'administer content types',
      'administer users',
      'administer node fields',
      'administer node display',
      'administer domains',
      'administer url aliases',
      'administer domain paths',
      'edit domain path entity',
      'add domain paths',
      'edit domain paths',
      'delete domain paths',
      'publish to any domain',
    ]);

    $this->drupalLogin($admin);
    \Drupal::service('entity_field.manager')->clearCachedFieldDefinitions();

    // Rebuild container to ensure the new field definitions are available.
    $this->rebuildContainer();
  }

  /**
   * Reusable test function for checking initial / empty table status.
   */
  public function domainPathTableIsEmpty(): void {
    $domain_path_storage = \Drupal::service('entity_type.manager')->getStorage('domain_path');
    $domain_paths = $domain_path_storage->loadMultiple();
    $this->assertEmpty($domain_paths, 'No domain paths have been created.');
  }

}
