<?php

namespace Drupal\Tests\domain_path_pathauto\Functional;

use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the Domain Path Pathauto integration.
 *
 * @group domain_path_pathauto
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class PathautoNodeAliasTest extends DomainPathPathautoTestBase {

  /**
   * Tests node alias generation based on content type and pathauto settings.
   *
   * The method verifies if a node alias is correctly created for content types
   * with a pathauto pattern enabled. It also ensures that no alias is generated
   * for content types where the pathauto pattern is disabled.
   */
  public function testNodeAlias(): void {
    // Content type with pathauto pattern enabled.
    $title = $this->randomMachineName();
    $this->drupalGet('node/add/page');
    $this->assertSession()->statusCodeEquals(200);
    $this->fillField('title[0][value]', $title);
    $this->pressButton('Save');
    $this->assertSession()->pageTextContains($title);

    $node = $this->drupalGetNodeByTitle($title);
    $this->drupalGet('node/' . $node->id() . '/edit');
    $this->assertSession()->statusCodeEquals(200);

    $this->assertSame(1, \Drupal::entityQuery('domain_path')
      ->accessCheck('FALSE')
      ->condition('domain_id', 'example_com')
      ->condition('source', '/node/' . $node->id())
      ->condition('alias', '/content/' . $title)
      ->count()->execute());

    // Content type with pathauto pattern disabled.
    $title = $this->randomMachineName();
    $this->drupalGet('node/add/article');
    $this->assertSession()->statusCodeEquals(200);
    $this->fillField('title[0][value]', $title);
    $this->pressButton('Save');
    $this->assertSession()->pageTextContains($title);

    $node = $this->drupalGetNodeByTitle($title);
    $this->drupalGet('node/' . $node->id() . '/edit');
    $this->assertSession()->statusCodeEquals(200);

    $this->assertSame(0, \Drupal::entityQuery('domain_path')
      ->accessCheck('FALSE')
      ->condition('domain_id', 'example_com')
      ->condition('source', '/node/' . $node->id())
      ->count()->execute());
  }

}
