<?php

namespace Drupal\Tests\domain_path_pathauto\Functional;

use Drupal\node\Entity\Node;
use Drupal\Tests\domain_path\Functional\DomainPathNoAccessTestBase;
use Drupal\Tests\pathauto\Functional\PathautoTestHelperTrait;
// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the Domain Path Pathauto integration without domain_access.
 *
 * @group domain_path_pathauto
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class PathautoNodeProgrammaticNoAccessTest extends DomainPathNoAccessTestBase {

  use PathautoTestHelperTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_path_pathauto',
    'pathauto',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $pattern = $this->createPattern('node', '/content/[node:title]');
    $this->addBundleCondition($pattern, 'node', 'page');
    $pattern->save();

    // Enable domain_path for nodes.
    $this->config('domain_path.settings')
      ->set('entity_types', ['node'])
      ->save();
  }

  /**
   * Tests programmatic node alias generation without domain_access.
   */
  public function testProgrammaticNodeAlias(): void {
    $title = 'Test Node';
    $node = Node::create([
      'type' => 'page',
      'title' => $title,
      'status' => 1,
    ]);
    $node->save();

    $storage = $this->entityTypeManager->getStorage('domain_path');
    $domain_paths = $storage->loadByProperties([
      'source' => '/node/' . $node->id(),
    ]);

    // Check if domain paths are created for all domains.
    $this->assertCount(count($this->domains), $domain_paths, 'Domain paths should be created for all domains.');

    foreach ($this->domains as $domain) {
      $domain_id = $domain->id();
      $found = FALSE;
      foreach ($domain_paths as $domain_path) {
        if ($domain_path->get('domain_id')->target_id === $domain_id) {
          $this->assertEquals('/content/test-node', $domain_path->get('alias')->value);
          $found = TRUE;
          break;
        }
      }
      $this->assertTrue($found, "Domain path for domain $domain_id not found.");
    }
  }

}
