<?php

namespace Drupal\Tests\domain_path_pathauto\Functional;

use Drupal\node\Entity\Node;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests the Domain Path Pathauto integration programmatically.
 *
 * @group domain_path_pathauto
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class PathautoNodeProgrammaticTest extends DomainPathPathautoTestBase {

  /**
   * Tests programmatic node alias generation.
   */
  public function testProgrammaticNodeAlias(): void {
    $title = 'Test Node';
    $node = Node::create([
      'type' => 'page',
      'title' => $title,
      'field_domain_all_affiliates' => 1,
      'status' => 1,
    ]);
    $node->save();

    $storage = $this->entityTypeManager->getStorage('domain_path');
    $domain_paths = $storage->loadByProperties([
      'source' => '/node/' . $node->id(),
    ]);

    // Check if domain paths are created for all domains.
    $this->assertCount(count($this->domains), $domain_paths, 'Domain paths should be created for all domains.');

    foreach ($this->domains as $domain) {
      $domain_id = $domain->id();
      $found = FALSE;
      foreach ($domain_paths as $domain_path) {
        if ($domain_path->get('domain_id')->target_id === $domain_id) {
          $this->assertEquals('/content/test-node', $domain_path->get('alias')->value);
          $found = TRUE;
          break;
        }
      }
      $this->assertTrue($found, "Domain path for domain $domain_id not found.");
    }
  }

}
