<?php

namespace Drupal\domain_path\EventSubscriber;

use Drupal\Core\Config\ConfigCrudEvent;
use Drupal\Core\Config\ConfigEvents;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Clear entity field definitions in case the entity types have changed.
 */
class DomainPathConfigSubscriber implements EventSubscriberInterface {

  public function __construct(
    protected EntityFieldManagerInterface $entityFieldManager,
  ) {
  }

  /**
   * Clear entity field definitions in case the entity types have changed.
   *
   * @param \Drupal\Core\Config\ConfigCrudEvent $event
   *   The event object.
   */
  public function onConfigSave(ConfigCrudEvent $event): void {
    if ($event->getConfig()->getName() === 'domain_path.settings' && $event->isChanged('entity_types')) {
      $this->entityFieldManager->clearCachedFieldDefinitions();
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = [];
    $events[ConfigEvents::SAVE][] = 'onConfigSave';
    return $events;
  }

}
