<?php

namespace Drupal\domain_path\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;

/**
 * Provides a filter form for the Domain Path aliases listing.
 */
class DomainPathFilterForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'domain_path_admin_filter_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $alias = NULL, $language = NULL, $domain_id = NULL, $source = NULL) {
    $form['#attributes'] = ['class' => ['search-form']];

    $form['basic'] = [
      '#type' => 'details',
      '#title' => $this->t('Filter aliases'),
      '#open' => TRUE,
      '#attributes' => ['class' => ['container-inline']],
    ];

    $form['basic']['alias'] = [
      '#type' => 'search',
      '#title' => $this->t('Path alias'),
      '#title_display' => 'invisible',
      '#default_value' => $alias,
      '#maxlength' => 128,
      '#size' => 25,
      '#attributes' => [
        'placeholder' => $this->t('Path alias'),
      ],
    ];

    $form['basic']['language'] = [
      '#type' => 'search',
      '#title' => $this->t('Language'),
      '#title_display' => 'invisible',
      '#maxlength' => 5,
      '#size' => 10,
      '#attributes' => [
        'placeholder' => $this->t('Language'),
      ],
      '#default_value' => $language,
    ];

    $form['basic']['domain_id'] = [
      '#type' => 'search',
      '#title' => $this->t('Domain id'),
      '#title_display' => 'invisible',
      '#maxlength' => 128,
      '#size' => 25,
      '#attributes' => [
        'placeholder' => $this->t('Domain id'),
      ],
      '#default_value' => $domain_id,
    ];

    $form['basic']['source'] = [
      '#type' => 'search',
      '#title' => $this->t('Source'),
      '#title_display' => 'invisible',
      '#maxlength' => 128,
      '#size' => 20,
      '#attributes' => [
        'placeholder' => $this->t('Source'),
      ],
      '#default_value' => $source,
    ];

    $form['basic']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Filter'),
    ];

    if ($alias || $language || $domain_id || $source) {
      $form['basic']['reset'] = [
        '#type' => 'submit',
        '#value' => $this->t('Reset'),
        '#submit' => ['::resetForm'],
      ];
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $form_state->setRedirect('entity.domain_path.collection', [], [
      'query' => [
        'search' => trim($form_state->getValue('alias')),
        'language' => trim($form_state->getValue('language')),
        'domain_id' => trim($form_state->getValue('domain_id')),
        'source' => trim($form_state->getValue('source')),
      ],
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function resetForm(array &$form, FormStateInterface $form_state) {
    $form_state->setRedirect('entity.domain_path.collection');
  }

}
