<?php

namespace Drupal\domain_path\Plugin\Validation\Constraint;

// @phpstan-ignore-next-line
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Constraint for creating domain alias that does not already exist.
 *
 * @Constraint(
 *   id = "DomainPathUnique",
 *   label = @Translation("Domain path must not already exist.", context = "Validation"),
 * )
 * @phpstan-ignore-next-line
 */
#[Constraint(
  id: 'DomainPathUnique',
  label: new \Drupal\Core\StringTranslation\TranslatableMarkup('Domain path must not already exist.', [], ['context' => 'Validation']),
)]
class DomainPathUniqueConstraint extends SymfonyConstraint {

  /**
   * Violation message.
   *
   * @var string
   */
  public $message = 'The alias %alias for %domain matches an existing domain path alias.';

}
