<?php

namespace Drupal\Tests\domain_path\Functional;

use Drupal\Tests\domain\Functional\DomainTestBase;
// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Base class for Domain Path functional tests.
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
abstract class DomainPathNoAccessTestBase extends DomainTestBase {

  /**
   * The test domains list.
   *
   * @return \Drupal\domain\DomainInterface[]
   *   An array of domain entities.
   */
  protected array $domains;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_path',
    'field',
    'user',
    'path',
    'system',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->entityTypeManager = $this->container->get('entity_type.manager');

    // Create domains.
    $this->domainCreateTestDomains(2);
    $this->domains = $this->getDomains();
    $this->domainPathBasicSetup();
  }

  /**
   * Basic setup.
   */
  public function domainPathBasicSetup(): void {
    $admin = $this->drupalCreateUser($this->getAdminPermissions());

    $this->drupalLogin($admin);
    $this->container->get('entity_field.manager')->clearCachedFieldDefinitions();

    // Rebuild container to ensure the new field definitions are available.
    $this->rebuildContainer();
  }

  /**
   * Reusable test function for checking initial / empty table status.
   */
  public function domainPathTableIsEmpty(): void {
    $domain_path_storage = $this->entityTypeManager->getStorage('domain_path');
    $domain_paths = $domain_path_storage->loadMultiple();
    $this->assertEmpty($domain_paths, 'No domain paths have been created.');
  }

  /**
   * Retrieves the list of permissions required for administrators.
   *
   * @return array
   *   An array of strings, each representing a permission assigned to
   *   administrators.
   */
  protected function getAdminPermissions() {
    return [
      'bypass node access',
      'administer content types',
      'administer users',
      'administer node fields',
      'administer node display',
      'administer domains',
      'administer url aliases',
      'administer domain paths',
      'edit domain path entity',
      'add domain paths',
      'edit domain paths',
      'delete domain paths',
    ];
  }

}
