<?php

namespace Drupal\Tests\domain_path\Functional;

// @phpstan-ignore-next-line
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests that a newly created domain path alias is properly accessible.
 *
 * @see https://www.drupal.org/i/3565885
 *
 * @group domain_path
 *
 * @phpstan-ignore-next-line
 */
#[RunTestsInSeparateProcesses]
class DomainPathWithSourceAndPathautoTest extends DomainPathTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'domain_path',
    'domain_access',
    'domain_source',
    'field',
    'user',
    'path',
    'pathauto',
    'system',
  ];

  /**
   * Test domain path node aliases.
   */
  public function testDomainPathPathautoCacheClear() {
    // Set path from Node form.
    $edit = [];
    $domain_paths_check = [];
    $edit['title[0][value]'] = $this->randomMachineName(8);
    $edit['body[0][value]'] = $this->randomMachineName(16);
    foreach ($this->domains as $domain) {
      $domain_alias_value = '/' . $this->randomMachineName(8);
      $edit['domain_path[' . $domain->id() . '][alias]'] = $domain_alias_value;
      $domain_paths_check[$domain->id()] = $domain_alias_value;
    }
    $this->drupalGet('node/add/page');
    foreach ($this->domains as $domain) {
      $this->checkField('field_domain_access[' . $domain->id() . ']');
    }
    $this->submitForm($edit, t('Save'));
    $this->assertSession()->statusCodeEquals(200);
  }

}
