/**
 * @file
 * Contains javascript functionality for the draggable blocks module.
 */

(function (window, Drupal, once) {

  'use strict';

  Drupal.draggableDashboard = Drupal.draggableDashboard || {};

  Drupal.draggableDashboard.dashboardChanged = function ($dashboard) {
    let blocks = {};
    $dashboard.querySelectorAll('.draggable-dashboard-column').forEach(function (column) {
      const columnId = '#' + column.getAttribute('id');
      // Build blocks object
      if (typeof blocks[columnId] === 'undefined') {
        blocks[columnId] = [];
      }
      column.querySelectorAll('.draggable-dashboard-block').forEach(function (block) {
        const blockId = '#' + block.getAttribute('id');
        blocks[columnId].push(blockId);
      });
    });

    localStorage.setItem('dashboard-blocks-order', JSON.stringify(blocks));
  };

  Drupal.behaviors.draggable_dashboard = {
    attach: function (context, settings) {
      const elements = once('dashboard-processed', '.draggable-dashboard', context)
      elements.forEach(function () {
        let blocks = {};
        // If we already saved an order in the local storage, get the value
        if (localStorage.getItem('dashboard-blocks-order')) {
          blocks = JSON.parse(localStorage.getItem('dashboard-blocks-order'));
        }

        context.querySelectorAll('.draggable-dashboard').forEach(function (dashboard) {
          dashboard.querySelectorAll('div.draggable-dashboard-column').forEach(function(node) {
            // Make columns sortable
            Sortable.create(document.getElementById(node.getAttribute('id')), {
              draggable: '.draggable-dashboard-block',
              handle: '.draggable-dashboard-block__header',
              onEnd: function () {
                Drupal.draggableDashboard.dashboardChanged(dashboard);
              }
            });
          })
        });

        // Rearrange blocks.
        if (blocks !== 'undefined') {
          Object.entries(blocks).forEach(function ([col_selector, blocksInCol]) {
            // Put every block in the correct place in its region.
            blocksInCol.forEach(function (block_selector) {
              let block = document.querySelector(block_selector);
              document.querySelector(col_selector).appendChild(block);
            });
          });
        }

      });
    }
  };

})(window, Drupal, once);
