/**
 * @file
 * Contains javascript functionality for the draggable dashboard module.
 */

(function (window, Drupal, once) {
  'use strict';
  Drupal.behaviors.draggableDashboardActions = {
    attach: function attach(context, settings) {
      const elements = once('draggable-processed', '.draggable-dashboard', context);
      elements.forEach(function () {
        var blocksMin = [];
        // If we already saved an order in the local storage,
        // get the value and collapse those blocks
        if (localStorage.getItem('dashboard-blocks-min')) {
          blocksMin = JSON.parse(localStorage.getItem('dashboard-blocks-min'));
        }
        if (blocksMin.length > 0) {
          blocksMin.forEach(function (block_selector) {
            const block = context.querySelector(block_selector);
            block.querySelector('.draggable-dashboard-block__content').classList.add('dashboard-collapsed');
            let collapse_icon = block.querySelector('.draggable-dashboard__icon--collapse');
            collapse_icon.classList.toggle('draggable-dashboard__icon--collapse');
            collapse_icon.classList.toggle('draggable-dashboard__icon--expand');
            collapse_icon.setAttribute('title', 'Expand');
          });
        }

        // Expand / collapse the content of a block
        const icons = context.querySelectorAll('.draggable-dashboard__icon--toggle');
        icons.forEach(function(icon) {
          icon.addEventListener('click', function (event) {
            const element = event.target;
            const blockId = '#' + element.closest('.draggable-dashboard-block').getAttribute('id');
            const container = document.querySelector(blockId + ' .draggable-dashboard-block__content');
            if (container.classList.contains('dashboard-collapsed')) {
              container.classList.remove('dashboard-collapsed');
              container.style.height = 'auto';
              let height = container.clientHeight + "px";
              container.style.height = '0px';
              setTimeout(function () {
                container.style.height = height;
              }, 0);
            } else {
              container.classList.add('dashboard-collapsed');
            }
            element.classList.toggle('draggable-dashboard__icon--collapse');
            element.classList.toggle('draggable-dashboard__icon--expand');
            if (element.classList.contains('draggable-dashboard__icon--expand')) {
              // If we have just minimized (collapsed) the content:
              element.setAttribute('title', 'Expand');
              // Add block to the minimized blocks list and save to Local Storage
              if (blocksMin.indexOf(blockId) === -1) {
                blocksMin.push(blockId);
                localStorage.setItem('dashboard-blocks-min', JSON.stringify(blocksMin));
              }
            }
            else {
              // If we have just expanded the content:
              element.setAttribute('title', 'Collapse');
              // Remove block from the minimized blocks list and save to Local Storage
              if (blocksMin.indexOf(blockId) !== -1) {
                blocksMin.splice(blocksMin.indexOf(blockId), 1);
                localStorage.setItem('dashboard-blocks-min', JSON.stringify(blocksMin));
              }
            }
          });
        });


        // Maximize / minimize block
        const resizeIcons = context.querySelectorAll('.draggable-dashboard__icon--resize');
        resizeIcons.forEach(function (icon) {
          icon.addEventListener('click', function (event) {
            const element = event.target;
            element.closest('.draggable-dashboard-block').classList.toggle('draggable-dashboard-block--maximized');
            element.classList.toggle('draggable-dashboard__icon--maximize draggable-dashboard__icon--minimize');
            if (element.classList.contains('draggable-dashboard__icon--minimize')) {
              element.setAttribute('title', 'Minimize');
            } else {
              element.setAttribute('title', 'Maximize');
            }
          });
        });
      });
    }
  };

})(window, Drupal, once);
