<?php

use Drupal\Component\Serialization\Json;

/**
 * Implements hook_post_update_NAME().
 */
function draggable_dashboard_post_update_convert_blocks(&$sandbox) {
  if (!isset($sandbox['total'])) {
    $max = \Drupal::entityQuery('dashboard_entity')
      ->count()
      ->execute();
    $sandbox['total'] = $max;
    $sandbox['current'] = 0;
  }
  if ($sandbox['total'] > 0) {
    $items_per_batch = 10;

    $ids = \Drupal::entityQuery('dashboard_entity')
      ->range($sandbox['current'], $sandbox['current'] + $items_per_batch)
      ->execute();
    $storage = \Drupal::entityTypeManager()->getStorage('dashboard_entity');
    $dashboards = $storage->loadMultiple($ids);

    foreach ($dashboards as $dashboard) {
      $blocks = $dashboard->get('blocks');
      if (!is_array($blocks)) {
        $result = [];
        $blocks = Json::decode($blocks);
        foreach ($blocks as $block) {
          /** @var \Drupal\block\BlockInterface $drupal_block */
          $drupal_block = \Drupal::entityTypeManager()
            ->getStorage('block')
            ->load($block['bid']);
          if ($drupal_block) {
            $result[$block['bid']] = [
              'column' => $block['cln'],
              'weight' => $block['position'],
              'settings' => $drupal_block->get('settings'),
            ];
            // Delete the block, as it is not needed anymore.
            if ($drupal_block->getRegion() == 'draggable_dashboard_region') {
              $drupal_block->delete();
            }
          }
        }
        if (!empty($result)) {
          $dashboard->set('blocks', $result)->save();
        }
      }
      $sandbox['current']++;
    }

    $sandbox['#finished'] = ($sandbox['current'] / $sandbox['total']);
  }
  return t('@current dashboards processed.', ['@current' => $sandbox['current']]);
}
