<?php

namespace Drupal\draggable_dashboard;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Class DashboardListBuilder.
 *
 * @package Drupal\draggable_dashboard
 */
class DashboardListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Title');
    $header['description'] = $this->t('Description');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label() . ' (' . $entity->id() . ')';
    $row['description'] = $entity->get('description');
    return $row + parent::buildRow($entity);
  }

}
