<?php

namespace Drupal\draggable_dashboard\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Dashboard entity.
 *
 * @ConfigEntityType(
 *   id = "dashboard_entity",
 *   label = @Translation("Dashboard"),
 *   handlers = {
 *     "list_builder" = "Drupal\draggable_dashboard\DashboardListBuilder",
 *     "form" = {
 *       "add" = "Drupal\draggable_dashboard\Form\DashboardForm",
 *       "edit" = "Drupal\draggable_dashboard\Form\DashboardForm",
 *       "delete" = "Drupal\draggable_dashboard\Form\DashboardDeleteForm",
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\draggable_dashboard\DashboardHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "dashboard_entity",
 *   admin_permission = "administer_draggable_dashboard",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "title",
 *     "uuid" = "uuid"
 *   },
 *   config_export = {
 *     "id",
 *     "title",
 *     "description",
 *     "columns",
 *     "blocks"
 *   },
 *   links = {
 *     "add-form" = "/admin/structure/draggable-dashboard/add",
 *     "edit-form" = "/admin/structure/draggable-dashboard/{dashboard_entity}/edit",
 *     "delete-form" = "/admin/structure/draggable-dashboard/{dashboard_entity}/delete",
 *     "collection" = "/admin/structure/draggable-dashboard"
 *   }
 * )
 */
class DashboardEntity extends ConfigEntityBase implements DashboardEntityInterface {

  /**
   * The Dashboard ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Dashboard title.
   *
   * @var string
   */
  protected $title;

  /**
   * The Dashboard description.
   *
   * @var string
   */
  protected $description;

  /**
   * The Dashboard columns count.
   *
   * @var string
   */
  protected $columns;

  /**
   * The Dashboard blocks.
   *
   * @var string
   */
  protected $blocks;

}
