<?php

namespace Drupal\draggable_dashboard\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\draggable_dashboard\Entity\DashboardEntityInterface;

/**
 * Class DashboardConfigureBlockForm.
 *
 * @package Drupal\draggable_dashboard\Form
 */
class DashboardConfigureBlockForm extends DashboardBlockFormBase {

  /**
   * Block id to configure.
   *
   * @var string
   */
  protected $block_id;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'draggable_dashboard_configure_block';
  }

  /**
   * Initialize the form state and the entity before the first form build.
   *
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   Form state object.
   * @param \Drupal\draggable_dashboard\Entity\DashboardEntityInterface $dashboard_entity
   *   Dashboard object.
   * @param string $block_id
   *   Id of the block to configure.
   */
  protected function init(FormStateInterface $form_state, DashboardEntityInterface $dashboard_entity, $block_id = '') {
    parent::init($form_state, $dashboard_entity);
    $blocks = $dashboard_entity->get('blocks');
    if (!empty($blocks[$block_id])) {
      $this->block = $blocks[$block_id];
    }
    else {
      $this->block = ['settings' => ['id' => 'broken']];
    }
    $this->block_id = $block_id;
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, ?DashboardEntityInterface $dashboard_entity = NULL, $block_id = '') {
    // During the initial form build, add this form object to the form state and
    // allow for initial preparation before form building and processing.
    if (!$form_state->has('form_initialized')) {
      $this->init($form_state, $dashboard_entity, $block_id);
    }
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $blocks = $this->dashboard->get('blocks') ? $this->dashboard->get('blocks') : [];
    $blocks[$this->block_id]['settings'] = $form_state->getValue('settings');

    // Save relation.
    $this->dashboard->set('blocks', $blocks)->save();
    // Redirect to manage blocks screen.
    $form_state->setRedirect('entity.dashboard_entity.edit_form', ['dashboard_entity' => $this->dashboard->id()]);
  }

}
