<?php

namespace Drupal\draggable_dashboard\Form;

use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a form to delete Dashboard Form.
 */
class DashboardDeleteForm extends EntityConfirmFormBase {

  /**
   * @var \Drupal\Core\Block\BlockManagerInterface
   */
  protected $blockPluginManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->blockPluginManager = $container->get('plugin.manager.block');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want delete dashboard `%title`?', ['%title' => $this->entity->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('entity.dashboard_entity.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->entity->delete();

    $this->messenger()->addStatus($this->t('Dashboard: deleted @label.', [
      '@label' => $this->entity->label(),
    ]));
    // Clear block plugin definitions to reflect changes in the list due to
    // removal of dashboard.
    $this->blockPluginManager->clearCachedDefinitions();
    $form_state->setRedirectUrl($this->getCancelUrl());
  }

}
