# Draggableviews Demo

This module provides demonstrations of the [Draggableviews](https://www.drupal.org/project/draggableviews) module functionality. It showcases both handler types (Native and Field API) with working examples.

## Features

- Creates a "Draggableviews Demo" content type with a `field_demo_weight` integer field
- Sets up two separate demonstration views:
  - **Native Handler Demo**: Uses internal draggableviews_structure table
  - **Field API Handler Demo**: Uses entity field for weight storage
- Creates sample content for immediate testing
- Each demo includes display and order pages

## Installation

1. Enable the module using Drush: `drush en draggableviews_demo`
2. Or enable it through the Drupal admin interface: `/admin/modules`

Upon installation, sample content will be created automatically.

## Demo Views

### Landing Page

**Main Demo Page:** `/draggableviews-demo`

A comprehensive landing page that provides:
- Overview of both handler types
- Direct links to all demo pages
- Feature comparison table
- Additional resources and documentation

### 1. Native Handler Demo

**Display Page:** `/draggableviews-demo/native`
**Order Page:** `/draggableviews-demo/native/order`

This demo uses the **Native Handler**, which stores ordering information in the internal `draggableviews_structure` database table. This is the default and most common approach.

**Features:**
- Lightweight storage mechanism
- Works across all entity types
- Order maintained separately from entities
- No field configuration required

### 2. Field API Handler Demo

**Display Page:** `/draggableviews-demo/weight`
**Order Page:** `/draggableviews-demo/weight/order`

This demo uses the **Field API Handler**, which stores ordering information directly in the `field_demo_weight` integer field on each node.

**Features:**
- Weight values accessible in templates: `{{ node.field_demo_weight.value }}`
- Weight exports/imports with entity data
- Useful for displaying position numbers (e.g., "Tip #3")
- Weight can be queried or filtered like any field

## Usage

### Viewing Ordered Content

1. Visit either display page:
   - Native: `/draggableviews-demo/native`
   - Field API: `/draggableviews-demo/weight`
2. Content is displayed in the specified order
3. Both views show the same content but maintain separate orderings

### Reordering Content

1. Visit either order page (requires "access draggableviews" permission):
   - Native: `/draggableviews-demo/native/order`
   - Field API: `/draggableviews-demo/weight/order`
2. Click and drag items using the drag handles (↕️)
3. Click "Save order" button to persist changes
4. Return to the display page to see the new order

**Note:** The two demos maintain independent orderings. Changing order in one does not affect the other.

## Creating Additional Content

To create more "Draggableviews Demo" content:

1. Navigate to `/node/add/draggableviews_demo`
2. Fill in the fields:
   - **Title**: Required
   - **Body**: Optional
   - **Demo Weight**: Optional (used by Field API demo, auto-populated when reordering)
3. Click "Save"
4. New content appears in both views and can be reordered independently

## Comparing Handler Types

| Feature | Native Handler | Field API Handler |
|---------|---------------|-------------------|
| **Storage** | draggableviews_structure table | Entity field (field_demo_weight) |
| **Configuration** | No field setup needed | Requires integer field |
| **Template Access** | Not directly accessible | `{{ node.field_demo_weight.value }}` |
| **Export/Import** | Separate from content | Included with entity data |
| **Performance** | Slightly faster | Requires field query |
| **Use Case** | General ordering | When weight needs to be displayed/queried |

## Permissions

Required permissions:
- **View content**: "Access content" - to view display pages
- **Create content**: "Create Draggableviews Demo content" - to add new items
- **Reorder content**: "Access draggableviews" - to access order pages

Configure at `/admin/people/permissions`

## How It Works

### Native Handler Flow
1. User drags items on `/draggableviews-demo/native/order`
2. Weight saved to `draggableviews_structure` table with view reference
3. Display page queries this table for sort order
4. Multiple views can maintain separate orderings

### Field API Handler Flow
1. User drags items on `/draggableviews-demo/weight/order`
2. Weight saved directly to `field_demo_weight` on each node
3. Display page sorts by this field value
4. Weight accessible everywhere the node is available

## Examining the Configuration

To see how each handler is configured:

1. Go to `/admin/structure/views`
2. Edit either view:
   - `draggableviews_native_demo`
   - `draggableviews_weight_demo`
3. Click on "Draggableviews: Content" field
4. Examine the "Handler" setting and field configuration

## Creating Your Own Draggable Views

To implement similar functionality:

**For Native Handler:**
1. Add "Draggableviews: Content" field to your view
2. Select "Native (internal table)" as handler
3. Add "Draggableviews: Weight" to sort criteria
4. Set up display and order pages

**For Field API Handler:**
1. Add an integer field to your content type
2. Add "Draggableviews: Content" field to your view
3. Select "Field API (entity field)" as handler
4. Choose your integer field from the dropdown
5. Add sort criteria for your weight field
6. Set up display and order pages

## Uninstallation

When you uninstall this module:
- All "Draggableviews Demo" content is deleted
- The content type is removed
- Views are removed
- Weight field data is cleaned up

To uninstall: `drush pmu draggableviews_demo`

4. Configure the sort criteria to use the draggableviews weight field

## Troubleshooting

If the drag-and-drop functionality doesn't work:
- Ensure JavaScript is enabled in your browser
- Check that you have the required permissions
- Verify that the Draggableviews module is properly installed
