<?php

namespace Drupal\draggableviews;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\ViewExecutable;

/**
 * Interface for draggableviews handlers.
 */
interface DraggableViewsHandlerInterface {

  /**
   * Get the weight value for a specific row.
   *
   * @param \Drupal\views\ViewExecutable $view
   *   The view object.
   * @param int $index
   *   The row index.
   *
   * @return int
   *   The weight value.
   */
  public function getWeight(ViewExecutable $view, $index);

  /**
   * Save the weight values.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param \Drupal\views\ViewExecutable $view
   *   The view object.
   */
  public function save(array &$form, FormStateInterface $form_state, ViewExecutable $view);

  /**
   * Build the options form for this handler.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param array $options
   *   The current options.
   *
   * @return array
   *   The form array.
   */
  public function buildOptionsForm(array $form, FormStateInterface $form_state, array $options);

  /**
   * Get default options for this handler.
   *
   * @return array
   *   Default options.
   */
  public function defaultOptions();

}

