<?php

namespace Drupal\drimage;

use Drupal\crop\CropTypeInterface;

/**
 * A repository for image styles generated by drimage.
 */
interface ImageStyleRepositoryInterface {

  /**
   * Delete all generated drimage image styles.
   *
   * @return int
   *   The number of deleted image styles.
   */
  public function deleteAll(): int;

  /**
   * Delete all generated drimage image styles for a crop type.
   *
   * @param \Drupal\crop\CropTypeInterface $cropType
   *   The crop type.
   *
   * @return int
   *   The number of deleted image styles.
   */
  public function deleteByCropType(CropTypeInterface $cropType): int;

}
