<?php

namespace Drupal\drimage_improved;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\crop\CropTypeInterface;

/**
 * A repository for image styles generated by drimage_improved.
 */
class ImageStyleRepository implements ImageStyleRepositoryInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a new ImageStyleRepository object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

  /**
   * {@inheritdoc}
   */
  public function deleteAll(): int {
    $storage = $this->entityTypeManager
      ->getStorage('image_style');
    $ids = $storage->getQuery()
      ->condition('name', 'drimage_improved_', 'STARTS_WITH')
      ->execute();

    $entities = $storage->loadMultiple($ids);
    $storage->delete($entities);

    return count($entities);
  }

  /**
   * {@inheritdoc}
   */
  public function deleteByCropType(CropTypeInterface $cropType): int {
    $storage = $this->entityTypeManager
      ->getStorage('image_style');
    $ids = $storage->getQuery()
      ->condition('name', 'drimage_improved_', 'STARTS_WITH')
      ->condition('name', '_' . $cropType->id(), 'ENDS_WITH')
      ->execute();

    $entities = $storage->loadMultiple($ids);
    $storage->delete($entities);

    return count($entities);
  }

}
