# Dripyard Simple Login

We developed this module to streamline the login experience on [dripyard.com](https://dripyard.com). After receiving multiple requests to release it as a contrib module, we're making it available to the community. Our approach differs from [other similar modules](#similar-modules) by keeping things simple and lean through repurposing Drupal core's password reset system. We'll fix reported bugs, but won't be adding features unless they're truly exceptional. Feel free to use this on your site or as inspiration for improving your own login process.

This Drupal 11 module replaces default login routes with magic link authentication by repurposing Drupal core's password reset functionality.

## Features

- Replaces the default login route with a magic link login form
- Repurposes core's password reset mechanism for authentication
- Users receive one-time login links via email
- Uses core's flood protection to prevent abuse
- Fallback option to use password-based login
- Custom messaging for successful login
- Blocks direct access to the password reset form

## How It Works

This module alters Drupal core's user routes and repurposes the password reset system:

1. The user.login route is replaced to show our magic link form
2. Users enter their email address on the login form
3. Core's password_reset mail is triggered to send a one-time login link
4. The user.reset.login route uses our custom controller with simplified messaging
5. Clicking the link logs them in automatically using core's existing mechanism
6. Users can optionally set a password for traditional login

## Installation

1. Place this module in your `modules` directory
2. Enable the module using Drush or the admin interface:
   ```
   drush en dripyard_simple_login
   ```

## Configuration

### Required Manual Step: Password Reset Email Template

This module repurposes the password reset email to send magic login links. You must manually configure the password reset email template to properly support this functionality.

Navigate to `/admin/config/people/accounts` and update the "Password recovery" email template with the following:

```
[user:display-name],

Below is your one time login link to [site:name].

[user:one-time-login-url]/login?destination=/user

This link will automatically expire after it has been used or 24 hours has past.

If you prefer to use a password, you can set one here and then use it to log in instead: [user:one-time-login-url]

--  [site:name]
```

### Flood Control

The module uses Drupal's core flood protection settings for rate limiting. You can configure these at:
`/admin/config/people/accounts` under "Flood control"

## Route Alterations

This module alters the following core user routes via RouteSubscriber:

- `user.login` - Replaced with magic link form at /login
- `user.pass` - Blocked from direct access (requirement set to FALSE)
- `user.reset.login` - Custom controller with simplified messaging that repurposes password reset

## Requirements

- Drupal 11
- A properly configured email system

## Similar Modules

If this module doesn't fit your needs, consider these alternatives:

- [Magic Login Link](https://www.drupal.org/project/magic_link) - Provides login links that expire after a configurable time period rather than after first use
- [Passwordless](https://www.drupal.org/project/passwordless) - Passwordless disables the password-reset form, and changes the relevant settings at admin/config/people/accounts.
- Have a contrib that's similar? File and issue and we'll add it here.

## About Dripyard

[Dripyard](https://dripyard.com) specializes in accessible themes for Drupal and Drupal Canvas. We're committed to creating solutions that make the web more inclusive and user-friendly.

## License

GPL-2.0+
