<?php

namespace Drupal\dripyard_simple_login\Controller;

use Drupal\user\Controller\UserController;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller that extends core's UserController for password reset routes.
 *
 * Replaces the default password reset login messaging with simplified text
 * to better suit magic link authentication flow.
 */
class UserResetController extends UserController {

  /**
   * {@inheritdoc}
   */
  public function resetPassLogin($uid, $timestamp, $hash, Request $request) {
    // Call the parent method to handle the login.
    $response = parent::resetPassLogin($uid, $timestamp, $hash, $request);

    // Clear all messages set by the parent method.
    $this->messenger()->deleteAll();

    // Add our custom message.
    $this->messenger()->addStatus($this->t("You're logged in!"));

    return $response;
  }

}
