<?php

namespace Drupal\dripyard_simple_login\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Alters core user routes to implement magic link authentication.
 *
 * This subscriber replaces the default login form route with our magic link
 * form and repurposes the password reset functionality for authentication.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Replace the user reset route controller to customize messaging.
    // This repurposes core's password reset as our authentication mechanism.
    if ($route = $collection->get('user.reset.login')) {
      $route->setDefault('_controller', '\Drupal\dripyard_simple_login\Controller\UserResetController::resetPassLogin');
      $route->setDefault('_title', 'Logging you in...');
    }

    // Replace the default login route with our magic link form.
    // This makes magic link the primary authentication method.
    if ($route = $collection->get('user.login')) {
      $route->setPath('/login');
      $route->setDefault('_form', '\Drupal\dripyard_simple_login\Form\MagicLinkLoginForm');
      $route->setDefault('_title', 'Log in');
    }

    // Block direct access to the password reset form.
    // Users should use the main login form instead.
    if ($route = $collection->get('user.pass')) {
      $route->setRequirement('_access', 'FALSE');
    }
  }

}
