<?php

declare(strict_types=1);


namespace Tests\JsCapable;

use Tests\Support\JsCapableTester;
use Codeception\Util\Drupal\FormField;
use Codeception\Util\Drupal\ParagraphFormField;
use Codeception\Util\Drupal\MTOFormField;
use Codeception\Util\Fixtures;
use Codeception\Util\Locator;
use Exception;


final class BannerParagraphCest
{
    /**
     * Setup environment before each test.
     *
     * @param JSCapableTester $I
     */
    protected function login(JSCapableTester $I)
    {
        $I->amOnPage('/user');
        $url = $I->getLoginUri('admin');
        $I->amOnPage($url);
    }

    /**
     * Test if I can add banner to Content Page.
     *
     * @param JSCapableTester $I
     * @throws Exception
     * 
     * @before login
     */
    public function addBannerToContentPage(JSCapableTester $I)
    {
        $I->wantTo('Add banner to new content page.');
        $I->amOnPage('/node/add/content_page/');

        $I->fillTextField(FormField::title(), 'Mans nosukums');
        $I->click(Locator::contains('strong', 'Page Sections'));

        $page_elements = ParagraphFormField::field_page_section();
        $I->seeVar($page_elements);

        $I->addNewParagraph('d_p_banner', $page_elements);
        
        $I->fillTextField(FormField::field_d_main_title($page_elements), 'title');
        $I->fillTextField(FormField::field_d_subtitle($page_elements), 'Loremlorem');
        $I->click(MTOFormField::field_d_media_background($page_elements)->__get('open-button'));
        $I->attachImage($I, 'test.jpeg');
        $I->click(MTOFormField::field_d_media_icon($page_elements)->__get('open-button'));
        $I->attachImage($I, 'mask.png');
        $I->fillCk5WysiwygEditor(FormField::field_d_long_text($page_elements), 'Lorem');
        $I->fillLinkField(FormField::field_d_cta_link($page_elements), 'http://example.com', 'Example');
        $I->click('#gin-sticky-edit-submit');
        $I->waitAjaxLoad($I, 30);
        $url = $I->grabFromCurrentUrl();
        Fixtures::add('banner_url', $url);
    }

    /**
     * Test if I can see the added banner
     *
     * @param JSCapableTester $I
     */
    public function seeCreatedBannerAsRandomUser(JSCapableTester $I)
    {
        $I->wantTo('See if the banner is created.');
        $I->amOnPage(Fixtures::get('banner_url'));
        $I->see('title');
        $I->see('Loremlorem');
        $src_icon = $I->grabAttributeFrom('.media-icon img', 'src');
        $I->seeVar($src_icon);
        $I->assertStringContainsString('mask', $src_icon);
        $src_background = $I->grabAttributeFrom('.d-p-banner__background-media img', 'src');
        $I->seeVar($src_background);
        $I->assertStringContainsString('test', $src_background);
        $I->see('Example');
        $I->click('Example');
        $I->see('Example Domain');
        $I->moveBack();
        $I->see('lorem');
    }

    /**
     * Removing added banner and checking if it's deleted
     *
     * @param JSCapableTester $I
     * 
     * @before login
     */
    public function removeBanner(JSCapableTester $I)
    {
        $I->wantTo('Clear up after the Banner test.');
        $I->deleteContentPage($I, Fixtures::get('banner_url'));
    }
}
