# Theming- [Theming](#theming)

- [Theming- Theming](#theming--theming)
    - [Technology](#technology)
    - [Debugging](#debugging)
    - [Available themes](#available-themes)

## More info about the  theming

Before you do anything else, uninstall (disable) the front-end themes you are NOT using.  
Having multiple themes enabled, seems to break some the inheritance rules (eg. libraries or components of same name get picked up from the wrong theme)  
This issue describes the problem and provides a patch if you need it: https://www.drupal.org/project/components/issues/3027672

Consult the Readme file of any theme generated by rocketship_theme_generator module. Those should contain all the information you need about theming (fonts, gulp, …).

## Setting up your local development environment

**INSTALL NVM TO MANAGE YOUR NODE VERSIONS!**

The basis of our local development, is Node + NPM. We need it to run Gulp tasks to make our life easier.
Depending on how old your project is, you will need to quickly and easily switch Node versions.
This is because some versions of Gulp (and dependencies like sass-build) are not compatible or need updated builds.

Long story short: you need to install NVM so you can switch using a simple command & so we can enforce locked versions of NPM.
Follow the instructions set here:
* https://redmine.dropsolid.com/issues/84063
* Or here: https://michael-kuehnel.de/node.js/2015/09/08/using-vm-to-switch-node-versions.html

Refer to the theme's readme file to see what version you need to run in order to work with that theme.
Unfortunately, most projects pre-06/2019 don't have this info, but these pointers might help you:
- if it contains Gulp 3 and no info in the readme, it is very likely you'll need to switch to NPM 6
- if it contains Gulp 4 and no info in the readme, either NPM 6 and NPM 8 should work but you might need to change some things:
  - Pay attention to the output when running `npm install`. If it gives you a warning about node-sass, you need to rebuild it. The output should contain the right command to do so.
- themes after 06/2019 should contain a version lock for NPM + info in the 'Requirements'-section of the theme's readme file on what NPM version to use.


## Debugging

You can add your own development settings to `sites/environments/local.services.yml`.  
This file is linked from within `etc/drupal/additional_settings.local.php` 
because the default development.services.yml gets overwritten when composer 
update is run.

Recommended settings:

<pre>twig.config:
    debug: true
    auto_reload: true
    cache: false #might not actually work, there's something funky with cache and twig
</pre>

- If you are using PHPStorm and have set up xdebug, installing `twig_xdebug` 
module makes it easy to debug twig templates.
- Using `twig_vardumper` + `vardumper` modules, is the easiest way to spy on 
twig content and variables. This will let you print twig stuff in the template
, in a cleaner and more readable way than kint or dpm will.  
- Trying to dump variables using devel or dpm, might actually break your site 
trying to load all that Drupal data. So avoid using it
- If you do need to use kint for some reason, make sure 'devel kint' is 
installed.

## Available themes

At point of writing, We have 2 options to generate themes for Rocketship, if you are using Rocketship Core + the Rocketship theme generator:
- `starter` (for Solutions projects)
- `flex` (for Flex projects)

If your site has been installed following the Rocketship install profile, you should have either a 'starter' or a 'flex' theme in your `themes/custom` folder to work from.  
If not:
- you can refer to the `rocketship_theme_generator` module for info on how to generate a theme
- or you can just add one of your own themes instead.
