<?php

namespace Drupal\dropwatch\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class DropWatchManualSyncForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dropwatch_manual_sync_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['details'] = [
      '#type' => 'markup',
      '#title' => 'DropWatch Manual Sync',
      '#markup' => '
        <p>Submitting this form will run a manual sync to DropWatch.</p>
      ',
    ];

    $form['manual_sync'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    /** @var \Drupal\dropwatch\Service\DropWatchService $dropWatchService */
    $dropWatchService = \Drupal::service('dropwatch.service');
    $dropWatchService->sendApiRequest();

    $this->messenger()->addMessage('Manual Sync Submitted. Check your logs for any issues.');
  }
}
