<?php

namespace Drupal\dropwatch\Client;

use Drupal\Core\Site\Settings;
use GuzzleHttp\ClientInterface;

class DropWatchApiClient {

  protected $address = 'https://dropwatch.sh';
  public string $token;
  protected string $endpoint = '/api/v1/update';

  public function __construct(
    protected Settings $settings,
    protected ClientInterface $client,
  ) {}

  public function sendUpdate(array $payload): int {
    $this->token = $this->settings::get('dropwatch_api_token', '');
    $response = $this->client->post("{$this->address}{$this->endpoint}", [
      'headers' => [
        'Authorization' => 'Bearer ' . $this->token,
        'Accept' => 'application/json',
      ],
      'json' => $payload,
    ]);

    return $response->getStatusCode();
  }
}
