(function($, Drupal2) {
  Drupal2.behaviors.drowl_media_library_vbo = {
    attach: function(context, settings) {
      $(".vbo-view-form .media-library-item", context).each(function() {
        let $mediaItem = $(this);
        let $vboSelectionTrigger = $mediaItem.find(
          ".media-library-item__preview-wrapper:first"
        );
        let $vboCheckbox = $mediaItem.find("input.form-checkbox:first");
        $vboSelectionTrigger.on("click", function(e) {
          e.preventDefault();
          e.stopPropagation();
          if ($vboCheckbox.is(":checked")) {
            $vboCheckbox.prop("checked", false);
            $mediaItem.removeClass("checked");
          } else {
            $vboCheckbox.prop("checked", true);
            $mediaItem.addClass("checked");
          }
        });
        $vboCheckbox.change(function() {
          if ($(this).is(":checked")) {
            $mediaItem.addClass("checked");
          } else {
            $mediaItem.removeClass("checked");
          }
        });
      });
    }
  };
})(jQuery, Drupal);
