(function($, Drupal2) {
  Drupal2.behaviors.drowl_media_types_slideshow = {
    attach: function(context, settings) {
      let $mediaSlidesWithAnimation = $(
        ".media-slide__media[data-media-animation]",
        context
      );
      if ($mediaSlidesWithAnimation.length) {
        $mediaSlidesWithAnimation.each(function() {
          let $mediaSlideMediaWrapper = $(this);
          if ($mediaSlideMediaWrapper.parents(".slick__slider:first").length) {
            $mediaSlideMediaWrapper.parents(".slick__slider:first").addClass("has-animated-media-slides");
          } else {
            $mediaSlideMediaWrapper.find(".animation-wrapper:first > :first-child", context).addClass("animation-" + $(this).attr("data-media-animation"));
          }
        });
        $(".slick__slider.has-animated-media-slides", context).on(
          "beforeChange",
          function(event, slick, currentSlide, nextSlide) {
            let $nextSlide = $(slick.$slides.get(nextSlide));
            setTimeout(function() {
              $(slick.$slides.get(currentSlide)).find(".animation-wrapper:first > :first-child", context).removeClass("animation-ken-burns");
            }, slick.slickGetOption("speed"));
            $nextSlide.find(".animation-wrapper:first > :first-child", context).addClass(
              "animation-" + $nextSlide.find(".media-slide__media--animated:first").attr("data-media-animation")
            );
          }
        );
      }
    }
  };
})(jQuery, Drupal);
