<?php

namespace Drupal\Tests\drowl_media_types\Functional;

use Drupal\Tests\system\Functional\Module\GenericModuleTestBase;

/**
 * Generic module test for drowl_media_types.
 *
 * @group drowl_media_types
 */
class DrowlMediaTypesGenericTest extends GenericModuleTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'entity_access_by_role_field',
    'fences',
    'field_group',
    'file_download_link',
    'focal_point',
    'link_attributes',
    'media_library_edit',
    'micon',
    'slick',
    'smart_trim',
    'svg_image',
    'svg_image_responsive',
    'photoswipe',
    'responsive_image',
  ];

  /**
   * {@inheritDoc}
   */
  protected $strictConfigSchema = FALSE; // @codingStandardsIgnoreLine

  /**
   * {@inheritDoc}
   *
   * Use the "standard" installation profile, so we have the necessary media
   * types available.
   */
  protected $profile = 'standard';

  /**
   * {@inheritDoc}
   */
  protected function assertHookHelp(string $module): void {
    // Don't do anything here. Just overwrite this useless method, so we do
    // don't have to implement hook_help().
  }

  /**
   * {@inheritDoc}
   *
   * @todo We need to delete all configurations coming from drowl_media_types,
   * so we can reinstall it properly (active config already exists error).
   *
   * In a perfect world, we wouldn't need this and we instead add a forced
   * dependency to the configs provided by this module's "install" folder
   * and replace our configs residing in "override" with the core configs
   * through a uninstall hook.
   */
  protected function preUnInstallSteps(): void {
    $configs_to_delete = [
      'core.entity_form_display.media.slide.media_library',
      'core.entity_form_display.media.slideshow.media_library',
      'core.entity_form_display.media.vector_image.media_library',
      'core.entity_view_display.media.audio.button',
      'core.entity_view_display.media.audio.embedded',
      'core.entity_view_display.media.image.background',
      'core.entity_view_display.media.image.button',
      'field.field.media.audio.field_caption',
      'field.field.media.audio.field_copyright',
      'field.field.media.audio.field_media_folder',
      'field.field.media.audio.field_media_image',
      'field.field.media.audio.field_media_tags',
      'field.field.media.audio.field_mime_type',
      'field.field.media.audio.field_note_internal',
      'field.field.media.audio.field_size',
      'field.field.media.document.field_caption',
      'field.field.media.document.field_note_internal',
      'field.field.media.image.field_caption',
      'field.field.media.image.field_copyright',
      'field.field.media.image.field_note_internal',
      'field.field.media.remote_video.field_note_internal',
      'field.field.media.slide.field_caption',
      'field.field.media.slide.field_copyright',
      'field.field.media.slide.field_note_internal',
      'field.field.media.slide.field_overlay_position_lg',
      'field.field.media.slide.field_overlay_position_md',
      'field.field.media.slide.field_overlay_sizing_lg',
      'field.field.media.slide.field_overlay_sizing_md',
      'field.field.media.slideshow.field_note_internal',
      'field.field.media.vector_image.field_caption',
      'field.field.media.vector_image.field_copyright',
      'field.field.media.vector_image.field_note_internal',
      'field.field.media.video.field_copyright',
      'field.field.media.video.field_note_internal',
      'field.storage.media.field_copyright',
      'field.storage.media.field_note_internal',
      'field.storage.media.field_overlay_position_lg',
      'field.storage.media.field_overlay_position_md',
      'field.storage.media.field_overlay_sizing_lg',
      'field.storage.media.field_overlay_sizing_md',
      'image.style.100_page_width_lg_crop_2x',
      'image.style.100_page_width_lg_scale_2x',
      'image.style.100_page_width_md_crop_2x',
      'image.style.100_page_width_md_scale_2x',
      'image.style.100_page_width_sm_crop_2x',
      'image.style.100_page_width_sm_scale_2x',
      'image.style.viewport_width_lg_crop_2x',
      'image.style.viewport_width_lg_scale_2x',
      'image.style.viewport_width_md_crop_2x',
      'image.style.viewport_width_md_scale_2x',
      'image.style.viewport_width_sm_crop_2x',
      'image.style.viewport_width_sm_scale_2x',
      'image.style.viewport_width_xl_crop_2x',
      'image.style.viewport_width_xl_scale_2x',
      'image.style.viewport_width_xxl_crop_2x',
      'image.style.viewport_width_xxl_scale_2x',
      'responsive_image.styles.page_width_crop',
      'responsive_image.styles.page_width_scale',
      'responsive_image.styles.viewport_width_crop',
      'responsive_image.styles.viewport_width_scale',
      'core.entity_form_display.media.audio.default',
      'core.entity_form_display.media.audio.media_library',
      'core.entity_form_display.media.document.default',
      'core.entity_form_display.media.document.media_library',
      'core.entity_form_display.media.image.default',
      'core.entity_form_display.media.image.media_library',
      'core.entity_form_display.media.remote_video.default',
      'core.entity_form_display.media.remote_video.media_library',
      'core.entity_form_display.media.video.default',
      'core.entity_form_display.media.video.media_library',
      'core.entity_view_display.media.audio.default',
      'core.entity_view_display.media.audio.media_library',
      'core.entity_view_display.media.document.default',
      'core.entity_view_display.media.document.media_library',
      'core.entity_view_display.media.image.default',
      'core.entity_view_display.media.image.media_library',
      'core.entity_view_display.media.remote_video.default',
      'core.entity_view_display.media.remote_video.media_library',
      'core.entity_view_display.media.video.default',
      'core.entity_view_display.media.video.media_library',
      'core.base_field_override.media.document.created',
      'core.base_field_override.media.document.name',
      'core.entity_form_display.media.slide.default',
      'core.entity_form_display.media.slideshow.default',
      'core.entity_form_display.media.vector_image.default',
      'core.entity_view_display.media.document.button',
      'core.entity_view_display.media.document.card',
      'core.entity_view_display.media.document.embedded',
      'core.entity_view_display.media.document.lightbox',
      'core.entity_view_display.media.document.media_object',
      'core.entity_view_display.media.document.tile',
      'core.entity_view_display.media.image.card_media',
      'core.entity_view_display.media.image.embedded',
      'core.entity_view_display.media.image.lightbox',
      'core.entity_view_display.media.image.media_object_media',
      'core.entity_view_display.media.image.raw',
      'core.entity_view_display.media.image.title_media',
      'core.entity_view_display.media.remote_video.background',
      'core.entity_view_display.media.remote_video.button',
      'core.entity_view_display.media.remote_video.embedded',
      'core.entity_view_display.media.remote_video.lightbox',
      'core.entity_view_display.media.remote_video.viewport_width',
      'core.entity_view_display.media.slide.default',
      'core.entity_view_display.media.slide.embedded',
      'core.entity_view_display.media.slide.lightbox',
      'core.entity_view_display.media.slide.media_library',
      'core.entity_view_display.media.slide.title_media',
      'core.entity_view_display.media.slide.viewport_width',
      'core.entity_view_display.media.slideshow.default',
      'core.entity_view_display.media.slideshow.media_library',
      'core.entity_view_display.media.slideshow.viewport_width',
      'core.entity_view_display.media.vector_image.default',
      'core.entity_view_display.media.vector_image.media_library',
      'core.entity_view_display.media.video.background',
      'core.entity_view_display.media.video.button',
      'core.entity_view_display.media.video.embedded',
      'core.entity_view_display.media.video.lightbox',
      'core.entity_view_display.media.video.viewport_width',
      'core.entity_view_mode.media.background',
      'core.entity_view_mode.media.button',
      'core.entity_view_mode.media.card',
      'core.entity_view_mode.media.card_media',
      'core.entity_view_mode.media.embedded',
      'core.entity_view_mode.media.lightbox',
      'core.entity_view_mode.media.media_object',
      'core.entity_view_mode.media.media_object_media',
      'core.entity_view_mode.media.raw',
      'core.entity_view_mode.media.tile',
      'core.entity_view_mode.media.title_media',
      'core.entity_view_mode.media.viewport_width',
      'crop.type.media_crop',
      'field.field.media.document.field_document_size',
      'field.field.media.document.field_media_access_by_role',
      'field.field.media.document.field_media_folder',
      'field.field.media.document.field_media_image',
      'field.field.media.document.field_media_tags',
      'field.field.media.document.field_mime_type',
      'field.field.media.image.field_image_caption',
      'field.field.media.image.field_media_folder',
      'field.field.media.image.field_media_tags',
      'field.field.media.image.field_mime_type',
      'field.field.media.image.field_size',
      'field.field.media.remote_video.field_caption',
      'field.field.media.remote_video.field_media_folder',
      'field.field.media.remote_video.field_media_image',
      'field.field.media.remote_video.field_media_tags',
      'field.field.media.slide.field_image_animation',
      'field.field.media.slide.field_image_caption',
      'field.field.media.slide.field_image_page_width',
      'field.field.media.slide.field_image_scale_only',
      'field.field.media.slide.field_media_folder',
      'field.field.media.slide.field_media_image',
      'field.field.media.slide.field_media_tags',
      'field.field.media.slide.field_media_video',
      'field.field.media.slide.field_overlay_button_color',
      'field.field.media.slide.field_overlay_button_style',
      'field.field.media.slide.field_overlay_display',
      'field.field.media.slide.field_overlay_link_button',
      'field.field.media.slide.field_overlay_position',
      'field.field.media.slide.field_overlay_sizing',
      'field.field.media.slide.field_subtitle',
      'field.field.media.slide.field_title',
      'field.field.media.slideshow.field_media_folder',
      'field.field.media.slideshow.field_media_slides_ref',
      'field.field.media.slideshow.field_media_tags',
      'field.field.media.slideshow.field_notes',
      'field.field.media.slideshow.field_slide_arrows',
      'field.field.media.slideshow.field_slide_autoplay',
      'field.field.media.slideshow.field_slide_dots',
      'field.field.media.slideshow.field_slide_height',
      'field.field.media.slideshow.field_slide_infinite',
      'field.field.media.vector_image.field_image_caption',
      'field.field.media.vector_image.field_media_folder',
      'field.field.media.vector_image.field_media_image',
      'field.field.media.vector_image.field_media_tags',
      'field.field.media.vector_image.field_size',
      'field.field.media.vector_image.field_svg_as_markup',
      'field.field.media.video.field_caption',
      'field.field.media.video.field_media_folder',
      'field.field.media.video.field_media_image',
      'field.field.media.video.field_media_tags',
      'field.field.media.video.field_mime_type',
      'field.field.media.video.field_size',
      'field.storage.media.field_caption',
      'field.storage.media.field_document_size',
      'field.storage.media.field_image_animation',
      'field.storage.media.field_image_caption',
      'field.storage.media.field_image_page_width',
      'field.storage.media.field_image_scale_only',
      'field.storage.media.field_media_access_by_role',
      'field.storage.media.field_media_folder',
      'field.storage.media.field_media_slides_ref',
      'field.storage.media.field_media_tags',
      'field.storage.media.field_media_video',
      'field.storage.media.field_mime_type',
      'field.storage.media.field_notes',
      'field.storage.media.field_overlay_button_color',
      'field.storage.media.field_overlay_button_style',
      'field.storage.media.field_overlay_display',
      'field.storage.media.field_overlay_link_button',
      'field.storage.media.field_overlay_position',
      'field.storage.media.field_overlay_sizing',
      'field.storage.media.field_size',
      'field.storage.media.field_slide_arrows',
      'field.storage.media.field_slide_autoplay',
      'field.storage.media.field_slide_dots',
      'field.storage.media.field_slide_height',
      'field.storage.media.field_slide_infinite',
      'field.storage.media.field_subtitle',
      'field.storage.media.field_svg_as_markup',
      'field.storage.media.field_title',
      'image.style.blocked_media_teaser',
      'image.style.media_crop',
      'image.style.media_crop_preview',
      'image.style.page_width_25_lg',
      'image.style.page_width_25_lg_scale',
      'image.style.page_width_50_lg',
      'image.style.page_width_50_lg_scale',
      'image.style.page_width_lg',
      'image.style.page_width_lg_scale',
      'image.style.page_width_md',
      'image.style.page_width_md_scale',
      'image.style.page_width_sm',
      'image.style.page_width_sm_scale',
      'image.style.ratio_16_9',
      'image.style.thumbnail_micro',
      'image.style.viewport_width_lg',
      'image.style.viewport_width_lg_scale',
      'image.style.viewport_width_md',
      'image.style.viewport_width_md_scale',
      'image.style.viewport_width_sm',
      'image.style.viewport_width_sm_scale',
      'image.style.viewport_width_xl',
      'image.style.viewport_width_xl_scale',
      'image.style.viewport_width_xxl',
      'image.style.viewport_width_xxl_scale',
      'image.style.zoomed_image_lg',
      'language.content_settings.crop.focal_point',
      'language.content_settings.media.remote_video',
      'language.content_settings.media.vector_image',
      'language.content_settings.media.video',
      'media.type.slide',
      'media.type.slideshow',
      'media.type.vector_image',
      'responsive_image.styles.page_width',
      'responsive_image.styles.viewport_width',
      'slick.optionset.columns_2',
      'slick.optionset.columns_4',
      'slick.optionset.columns_6',
      'slick.optionset.columns_8',
      'slick.optionset.media_slideshow',
      'taxonomy.vocabulary.media_folder',
      'taxonomy.vocabulary.media_tags',
    ];

    foreach ($configs_to_delete as $config_name) {
      \Drupal::configFactory()->getEditable($config_name)->delete();
    }
  }
}
