(function($, Drupal2) {
  Drupal2.behaviors.drowl_paragraphs_bs_type_countdown = {
    attach: function(context, settings) {
      $(document).ready(function() {
        $(".countdown", context).each(function() {
          let $countdownWrapper = $(this);
          let $countdownNoJsFallback = $countdownWrapper.next(
            ".countdown-no-js-fallback:first"
          );
          let targetTimestamp = $countdownWrapper.data("target-date");
          let countdownTheme = $countdownWrapper.data("countdown-theme");
          let countdownId = $countdownWrapper.attr("id");
          $countdownWrapper.addClass("flipdown");
          new FlipDown(targetTimestamp, countdownId, {
            headings: [
              Drupal2.t("Days"),
              Drupal2.t("Hours"),
              Drupal2.t("Minutes"),
              Drupal2.t("Seconds")
            ],
            theme: countdownTheme
          }).start(function() {
          }).ifEnded(() => {
          });
          $countdownNoJsFallback.addClass("hidden");
        });
      });
    }
  };
})(jQuery, Drupal);
