(function($, Drupal2) {
  Drupal2.behaviors.drowl_paragraphs_bs_frontend = {
    attach: function(context, settings) {
      var didScroll = false;
      var animatedParagraphs = $(".paragraph.has-animation", context);
      animatedParagraphs.each(function() {
        if ($(this).data("animations")) {
          var $animatedParagraph = $(this);
          var animations = $animatedParagraph.data("animations");
          var animationCount = animations.length;
          for (var i = 0; i < animationCount; i++) {
            if (!animations[i].event || !animations[i].animation) {
              continue;
            }
            var animationObj = animations[i];
            (function(i2, $animatedParagraph2, animationObj2) {
              var animationEvent = animationObj2.event;
              var animationName = animationObj2.animation;
              var animationOffset = animationObj2.offset;
              var animationDelay = animationObj2.delay;
              var animationDuration = animationObj2.transition_duration;
              var animationOffsetPx = 0;
              if (animationOffset != 0) {
                var animationOffsetPercent = 100 / animationOffset * -1;
                animationOffsetPx = Math.round(
                  $animatedParagraph2.outerHeight() / animationOffsetPercent
                );
              }
              if (animationEvent === "enter-viewport") {
                setInterval(function() {
                  if (didScroll) {
                    if (!$animatedParagraph2.hasClass("in-scope") && verge.inViewport(
                      $animatedParagraph2.get(0),
                      animationOffsetPx
                    )) {
                      $animatedParagraph2.addClass("in-scope");
                      Drupal2.behaviors.drowl_paragraphs_bs_frontend.animate(
                        $animatedParagraph2,
                        animationName,
                        animationDelay,
                        animationDuration
                      );
                    } else if ($animatedParagraph2.hasClass("in-scope") && !verge.inViewport(
                      $animatedParagraph2.get(0),
                      animationOffsetPx
                    )) {
                      $animatedParagraph2.removeClass("in-scope");
                    }
                  }
                }, 100);
              } else if (animationEvent === "leave-viewport") {
                setInterval(function() {
                  if (didScroll) {
                    if ($animatedParagraph2.hasClass(
                      "leave-viewport-was-in-scope"
                    ) && !verge.inViewport(
                      $animatedParagraph2.get(0),
                      animationOffsetPx
                    )) {
                      Drupal2.behaviors.drowl_paragraphs_bs_frontend.animate(
                        $animatedParagraph2,
                        animationName,
                        animationDelay
                      );
                      $animatedParagraph2.removeClass(
                        "leave-viewport-was-in-scope"
                      );
                    } else if (!$animatedParagraph2.hasClass(
                      "leave-viewport-was-in-scope"
                    ) && verge.inViewport(
                      $animatedParagraph2.get(0),
                      animationOffsetPx
                    )) {
                      $animatedParagraph2.addClass(
                        "leave-viewport-was-in-scope"
                      );
                    }
                  }
                }, 100);
              } else if (animationEvent === "hover") {
                $animatedParagraph2.on("mouseenter touchstart", function() {
                  Drupal2.behaviors.drowl_paragraphs_bs_frontend.animate(
                    $animatedParagraph2,
                    animationName,
                    animationDelay,
                    animationDuration
                  );
                });
              }
            })(i, $animatedParagraph, animationObj);
          }
        }
      });
      window.addEventListener("scroll", function() {
        didScroll = true;
      });
      setInterval(function() {
        if (didScroll) {
          didScroll = false;
        }
      }, 200);
    },
    animate: function($container, animationName, animationDelay, animationDuration, callback) {
      const entranceAnimationClasses = [
        // Back entrances
        "backInDown",
        "backInLeft",
        "backInRight",
        "backInUp",
        // Bouncing entrances
        "bounceIn",
        "bounceInDown",
        "bounceInLeft",
        "bounceInRight",
        "bounceInUp",
        // Facing entrances
        "fadeIn",
        "fadeInDown",
        "fadeInDownBig",
        "fadeInLeft",
        "fadeInLeftBig",
        "fadeInRight",
        "fadeInRightBig",
        "fadeInUp",
        "fadeInUpBig",
        "fadeInTopLeft",
        "fadeInTopRight",
        "fadeInBottomLeft",
        "fadeInBottomRight",
        // Flippers
        "flipInX",
        "flipInY",
        // Lightspeed
        "lightSpeedInRight",
        "lightSpeedInLeft",
        // Rotating entrances
        "rotateIn",
        "rotateInDownLeft",
        "rotateInDownRight",
        "rotateInUpLeft",
        "rotateInUpRight",
        // Specials
        "jackInTheBox",
        "rollIn",
        // Zooming entrances
        "zoomIn",
        "zoomInDown",
        "zoomInLeft",
        "zoomInRight",
        "zoomInUp",
        // Sliging entrances
        "slideInDown",
        "slideInLeft",
        "slideInRight",
        "slideInUp"
      ];
      const exitAnimationClasses = [
        // Back exits
        "backOutDown",
        "backOutLeft",
        "backOutRight",
        "backOutUp",
        // Bouncing exits
        "bounceOut",
        "bounceOutDown",
        "bounceOutLeft",
        "bounceOutUp",
        // Fading exits
        "fadeOut",
        "fadeOutDown",
        "fadeOutDownBig",
        "fadeOutLeft",
        "fadeOutLeftBig",
        "fadeOutRight",
        "fadeOutRightBig",
        "fadeOutUp",
        "fadeOutUpBig",
        "fadeOutTopLeft",
        "fadeOutTopRight",
        "fadeOutBottomLeft",
        "fadeOutBottomRight",
        // Flippers
        "flipOutX",
        "flipOutY",
        // Lightspeed
        "lightSpeedOutRight",
        "lightSpeedOutLeft",
        // Rotating exits
        "rotateOut",
        "rotateOutDownLeft",
        "rotateOutDownRight",
        "rotateOutUpLeft",
        "rotateOutUpRight",
        // Specials
        "rollOut",
        // Zooming exits
        "zoomOut",
        "zoomOutDown",
        "zoomOutLeft",
        "zoomOutRight",
        "zoomOutUp",
        // Sliging exits
        "slideOutDown",
        "slideOutLeft",
        "slideOutRight",
        "slideOutUp"
      ];
      const attentionAnimationClasses = [
        // Attention seekers
        "bounce",
        "flash",
        "pulse",
        "rubberBand",
        "shakeX",
        "shakeY",
        "headShake",
        "swing",
        "tada",
        "wobble",
        "jello",
        "heartBeat",
        // Flippers
        "flip",
        // Specials
        "hinge"
      ];
      const animationClasses = [].concat(
        entranceAnimationClasses,
        exitAnimationClasses,
        attentionAnimationClasses
      );
      var animationEnd = "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
      var animationDelay = typeof animationDelay === "undefined" ? 0 : animationDelay;
      var animationDurationOverridden = typeof animationDuration === "undefined" || animationDuration == 0 ? false : true;
      if (animationDurationOverridden) {
        $container.css("animation-duration", animationDuration + "ms");
      }
      setTimeout(function() {
        $container.addClass("animated " + animationName);
        $container.one(animationEnd, function() {
          if (!entranceAnimationClasses.includes(animationName)) {
            if (exitAnimationClasses.includes(animationName)) {
              $(this).removeClass("animated").removeClass(animationClasses);
            } else {
              $(this).removeClass("animated " + animationName);
            }
          }
          if (callback) {
            callback();
          }
        });
      }, animationDelay);
      return this;
    }
  };
})(jQuery, Drupal);
