# Druidfire

Druidfire provides Drush commands and an API to dynamically alter field
definitions in your Drupal site. This powerful development tool allows you to
resize fields, convert field types, and modify entity reference configurations
without manual database changes or complex update hooks.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/druidfire).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/druidfire).

## Requirements

This module requires no modules outside of Drupal core.

## Installation
Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. Enable the module at Administration > Extend.
2. Use the provided API methods or Drush commands to alter field
   definitions.

## Usage

### API Usage

You can use the Druidfire service in update hooks or custom code:

#### Resize a field
```php
\Drupal::service('druidfire')->resize('paragraph', 'section_title', ['size' => 1024]);
```

To resize a specific property of a field:
```php
\Drupal::service('druidfire')->resize('paragraph', 'link', [
  'size' => 1024,
  'property' => 'title'
]);
```

#### Convert string field to formatted text field
```php
\Drupal::service('druidfire')->string2formatted('paragraph',
  'component_flora_answer');
```

#### Convert Entity Reference Revisions to Entity Reference
```php
\Drupal::service('druidfire')->err2er('paragraph',
  'component_lee_referenced_item');
```

#### Convert Entity Reference Revisions to Bricks
```php
\Drupal::service('druidfire')->err2bricks('paragraph',
  'paragraph_unlimited');
```

#### Convert string field to taxonomy reference
```php
\Drupal::service('druidfire')->string2taxonomyReference('node', 'time',
  ['vid' => 'event_time']);
```

### Drush Commands

#### List all available spells
```bash
# Show all available Druidfire spells and what they do
drush druidfire:list-spells
# Or use the alias:
drush druidfire:ls
```

#### Resize a field
```bash
# Resize a field to a specific length
drush druidfire:resize paragraph section_title 1024

# Resize a specific property of a field (optional)
drush druidfire:resize paragraph link 1024 title
```

#### Convert string to formatted text field
```bash
drush druidfire:string2formatted node body
```

#### Convert ERR to Entity Reference
```bash
drush druidfire:err2er node my_field
```

#### Convert ERR to Bricks field
```bash
drush druidfire:err2bricks node my_paragraphs_field
```

#### Convert string to taxonomy reference
```bash
# Convert string field to taxonomy reference (requires vocabulary ID)
drush druidfire:string2taxonomyreference node category tags
```

#### Get help for specific commands
```bash
# Get detailed help for any command
drush help druidfire:resize
drush help druidfire:string2taxonomyreference
```

### Command Quick Reference

| Command | Purpose | Usage Example |
|---------|---------|---------------|
| `druidfire:list-spells` | List all available spells | `drush druidfire:ls` |
| `druidfire:resize` | Resize text/string fields | `drush druidfire:resize node title 512` |
| `druidfire:string2formatted` | Convert string to formatted text | `drush druidfire:string2formatted node body` |
| `druidfire:err2er` | Convert ERR to Entity Reference | `drush druidfire:err2er node field_ref` |
| `druidfire:err2bricks` | Convert ERR to Bricks field | `drush druidfire:err2bricks node field_para` |
| `druidfire:string2taxonomyreference` | Convert string to taxonomy ref | `drush druidfire:string2taxonomyreference node category tags` |

## Available Spells

- **resize**: Modifies the maximum length of text or string fields.
- **string2formatted**: Converts plain string fields to formatted text
  fields.
- **err2er**: Converts Entity Reference Revisions fields to standard
  Entity Reference fields.
- **err2bricks**: Converts Entity Reference Revisions fields to Bricks
  fields.
- **string2taxonomyReference**: Converts string fields to taxonomy
  reference fields.

## Troubleshooting

- Always backup your database before making field modifications.
- Test changes in a development environment first.
- Clear caches after making changes to ensure proper functionality.
- Check the Drupal logs for any error messages if operations fail.
