<?php

namespace Drupal\druidfire\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Spell plugin annotation object.
 *
 * @see \Drupal\druidfire\Plugin\SpellManager
 * @see plugin_api
 *
 * @Annotation
 */
class Spell extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The label of the spell.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The description of the spell.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

}
