<?php

namespace Drupal\druidfire\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Provides the Spell plugin manager.
 */
class SpellManager extends DefaultPluginManager {

  /**
   * Constructs a new SpellManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/Spell',
      $namespaces,
      $module_handler,
      'Drupal\druidfire\SpellInterface',
      'Drupal\druidfire\Annotation\Spell'
    );

    $this->alterInfo('druidfire_spell_info');
    $this->setCacheBackend($cache_backend, 'druidfire_spell_plugins');
  }

}
