<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 11.0-dev db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('accesslog', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'path' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'url' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timer' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('accesslog')
->fields(array(
  'aid',
  'sid',
  'title',
  'path',
  'url',
  'hostname',
  'uid',
  'timer',
  'timestamp',
))
->values(array(
  'aid' => '507',
  'sid' => 'uN5dpqmEzJ__oqKPPpS7XBaYmPNMLdzazARhMxKq7bc',
  'title' => '',
  'path' => 'node',
  'url' => 'http://mfd7.ddev.site:7006/',
  'hostname' => '172.18.0.6',
  'uid' => '0',
  'timer' => '220',
  'timestamp' => '1687692570',
))
->values(array(
  'aid' => '508',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => '',
  'path' => 'node',
  'url' => 'http://mfd7.ddev.site:7006/node/add',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '30',
  'timestamp' => '1687692577',
))
->values(array(
  'aid' => '509',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Add content',
  'path' => 'node/add',
  'url' => 'http://mfd7.ddev.site:7006/node/add',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '44',
  'timestamp' => '1687692577',
))
->values(array(
  'aid' => '510',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Create Test long name',
  'path' => 'node/add/a-thirty-two-character-type-name',
  'url' => 'http://mfd7.ddev.site:7006/node/add',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '28',
  'timestamp' => '1687692589',
))
->values(array(
  'aid' => '511',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Administration',
  'path' => 'admin',
  'url' => '',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '18',
  'timestamp' => '1687692598',
))
->values(array(
  'aid' => '512',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Structure',
  'path' => 'admin/structure',
  'url' => 'http://mfd7.ddev.site:7006/admin/',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '42',
  'timestamp' => '1687692601',
))
->values(array(
  'aid' => '513',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules',
  'url' => 'http://mfd7.ddev.site:7006/admin/',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '72',
  'timestamp' => '1687692604',
))
->values(array(
  'aid' => '514',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Content types',
  'path' => 'admin/structure/types',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '46',
  'timestamp' => '1687692610',
))
->values(array(
  'aid' => '515',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Article',
  'path' => 'admin/structure/types/manage/article/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '57',
  'timestamp' => '1687692836',
))
->values(array(
  'aid' => '516',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Basic page',
  'path' => 'admin/structure/types/manage/page/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '22',
  'timestamp' => '1687692837',
))
->values(array(
  'aid' => '517',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Blog entry',
  'path' => 'admin/structure/types/manage/blog/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '17',
  'timestamp' => '1687692838',
))
->values(array(
  'aid' => '518',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Book page',
  'path' => 'admin/structure/types/manage/book/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '17',
  'timestamp' => '1687692839',
))
->values(array(
  'aid' => '519',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Entity translation test',
  'path' => 'admin/structure/types/manage/et/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '16',
  'timestamp' => '1687692840',
))
->values(array(
  'aid' => '520',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Forum topic',
  'path' => 'admin/structure/types/manage/forum/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '18',
  'timestamp' => '1687692841',
))
->values(array(
  'aid' => '521',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Test content type',
  'path' => 'admin/structure/types/manage/test-content-type/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '18',
  'timestamp' => '1687692843',
))
->values(array(
  'aid' => '522',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Test long name',
  'path' => 'admin/structure/types/manage/a-thirty-two-character-type-name/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '17',
  'timestamp' => '1687692845',
))
->values(array(
  'aid' => '523',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Are you sure you want to delete the field Boolean?',
  'path' => 'admin/structure/types/manage/test-content-type/fields/field_boolean/delete',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types/manage/test-content-type/fields',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '36',
  'timestamp' => '1687692856',
))
->values(array(
  'aid' => '524',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Are you sure you want to delete the field Boolean?',
  'path' => 'admin/structure/types/manage/test-content-type/fields/field_boolean/delete',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types/manage/test-content-type/fields/field_boolean/delete',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '110',
  'timestamp' => '1687692858',
))
->values(array(
  'aid' => '525',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Test content type',
  'path' => 'admin/structure/types/manage/test-content-type/fields',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types/manage/test-content-type/fields/field_boolean/delete',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '27',
  'timestamp' => '1687692858',
))
->values(array(
  'aid' => '526',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Configuration',
  'path' => 'admin/config',
  'url' => 'http://mfd7.ddev.site:7006/admin/',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '66',
  'timestamp' => '1687692933',
))
->values(array(
  'aid' => '527',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://mfd7.ddev.site:7006/admin/config',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '27',
  'timestamp' => '1687692935',
))
->values(array(
  'aid' => '528',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://mfd7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '488',
  'timestamp' => '1687692937',
))
->values(array(
  'aid' => '529',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://mfd7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '113',
  'timestamp' => '1687692938',
))
->values(array(
  'aid' => '530',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules',
  'url' => 'http://mfd7.ddev.site:7006/admin/',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '42',
  'timestamp' => '1687693188',
))
->values(array(
  'aid' => '531',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules/uninstall',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '28',
  'timestamp' => '1687693201',
))
->values(array(
  'aid' => '532',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules/uninstall',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '31',
  'timestamp' => '1687693203',
))
->values(array(
  'aid' => '533',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '35',
  'timestamp' => '1687693347',
))
->values(array(
  'aid' => '534',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'List',
  'path' => 'admin/modules/list/confirm',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '570',
  'timestamp' => '1687693396',
))
->values(array(
  'aid' => '535',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '164',
  'timestamp' => '1687693396',
))
->values(array(
  'aid' => '536',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules/uninstall',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '22',
  'timestamp' => '1687693400',
))
->values(array(
  'aid' => '537',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Confirm uninstall',
  'path' => 'admin/modules/uninstall/confirm',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules/uninstall',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '23',
  'timestamp' => '1687693406',
))
->values(array(
  'aid' => '538',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Uninstall',
  'path' => 'admin/modules/uninstall/confirm',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules/uninstall/confirm',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '112',
  'timestamp' => '1687693407',
))
->values(array(
  'aid' => '539',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules/uninstall',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules/uninstall/confirm',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '19',
  'timestamp' => '1687693407',
))
->values(array(
  'aid' => '540',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => 'Modules',
  'path' => 'admin/modules',
  'url' => 'http://mfd7.ddev.site:7006/admin/modules/uninstall',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '28',
  'timestamp' => '1687693419',
))
->values(array(
  'aid' => '541',
  'sid' => 'VWaAe8AugzVKJk_HrCQJfaRS6JObhUaJ0ACyZF2KkrA',
  'title' => '',
  'path' => 'node',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '0',
  'timer' => '132',
  'timestamp' => '1687694574',
))
->values(array(
  'aid' => '542',
  'sid' => 'yJmKqDJfU_9jW4KsWZwc77xcFvxVODM53LyJuk0-FZw',
  'title' => '',
  'path' => 'node',
  'url' => 'http://mfd7.ddev.site:7006/admin/structure/types',
  'hostname' => '172.18.0.6',
  'uid' => '0',
  'timer' => '13',
  'timestamp' => '1687694578',
))
->values(array(
  'aid' => '543',
  'sid' => '4qhfb6LR0oKlSofiMjbXSh5TA155aiQRDKh5txConuY',
  'title' => '',
  'path' => 'node',
  'url' => 'http://mfd7.ddev.site:7006/admin',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '32',
  'timestamp' => '1687694582',
))
->values(array(
  'aid' => '544',
  'sid' => '4qhfb6LR0oKlSofiMjbXSh5TA155aiQRDKh5txConuY',
  'title' => 'Administration',
  'path' => 'admin',
  'url' => 'http://mfd7.ddev.site:7006/admin',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '48',
  'timestamp' => '1687694582',
))
->values(array(
  'aid' => '545',
  'sid' => '4qhfb6LR0oKlSofiMjbXSh5TA155aiQRDKh5txConuY',
  'title' => 'Configuration',
  'path' => 'admin/config',
  'url' => 'http://mfd7.ddev.site:7006/admin',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '60',
  'timestamp' => '1687694584',
))
->values(array(
  'aid' => '546',
  'sid' => '4qhfb6LR0oKlSofiMjbXSh5TA155aiQRDKh5txConuY',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://mfd7.ddev.site:7006/admin/config',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '40',
  'timestamp' => '1687694587',
))
->values(array(
  'aid' => '547',
  'sid' => '4qhfb6LR0oKlSofiMjbXSh5TA155aiQRDKh5txConuY',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://mfd7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '485',
  'timestamp' => '1687694589',
))
->values(array(
  'aid' => '548',
  'sid' => '4qhfb6LR0oKlSofiMjbXSh5TA155aiQRDKh5txConuY',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://mfd7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '132',
  'timestamp' => '1687694589',
))
->execute();
$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'label',
))
->values(array(
  'aid' => '2',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'label' => 'Unpublish comment containing keyword(s)',
))
->values(array(
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'label' => 'Change the author of content',
))
->values(array(
  'aid' => '4',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'label' => 'Unpublish content containing keyword(s)',
))
->values(array(
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'label' => 'Display a message to the user',
))
->values(array(
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'label' => 'Send e-mail',
))
->values(array(
  'aid' => '7',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'label' => 'Redirect to URL',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'label' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_save_action',
  'type' => 'comment',
  'callback' => 'comment_save_action',
  'parameters' => '',
  'label' => 'Save comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish comment',
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'label' => 'Make content sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'label' => 'Make content unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'label' => 'Promote content to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'label' => 'Publish content',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'label' => 'Save content',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'label' => 'Remove content from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish content',
))
->values(array(
  'aid' => 'system_block_ip_action',
  'type' => 'user',
  'callback' => 'system_block_ip_action',
  'parameters' => '',
  'label' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'label' => 'Block current user',
))
->execute();
$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'indexes' => array(
    'uid_module' => array(
      'uid',
      'module',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('block')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'User login title',
  'cache' => '-1',
))
->values(array(
  'bid' => '5',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '10',
  'region' => 'footer',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '8',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '9',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '10',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'User login title',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '14',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '15',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '17',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '18',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '19',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '20',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '21',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '22',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '23',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '25',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '26',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '27',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '28',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '29',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '30',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '31',
  'module' => 'blog',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '33',
  'module' => 'locale',
  'delta' => 'language',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '34',
  'module' => 'forum',
  'delta' => 'active',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-2',
))
->values(array(
  'bid' => '35',
  'module' => 'forum',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-2',
))
->values(array(
  'bid' => '36',
  'module' => 'blog',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '38',
  'module' => 'locale',
  'delta' => 'language',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '39',
  'module' => 'forum',
  'delta' => 'active',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-2',
))
->values(array(
  'bid' => '40',
  'module' => 'forum',
  'delta' => 'new',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-2',
))
->values(array(
  'bid' => '42',
  'module' => 'statistics',
  'delta' => 'popular',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '44',
  'module' => 'statistics',
  'delta' => 'popular',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '49',
  'module' => 'locale',
  'delta' => 'language_content',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '50',
  'module' => 'locale',
  'delta' => 'language_content',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();
$connection->schema()->createTable('block_custom', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_node_type', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_role', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('blocked_ips', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'ip' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '40',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_field', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_image', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_path', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_variable', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('comment', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('comment')
->fields(array(
  'cid',
  'pid',
  'nid',
  'uid',
  'subject',
  'hostname',
  'created',
  'changed',
  'status',
  'thread',
  'name',
  'mail',
  'homepage',
  'language',
))
->values(array(
  'cid' => '1',
  'pid' => '0',
  'nid' => '1',
  'uid' => '1',
  'subject' => 'A comment',
  'hostname' => '2001:db8:ffff:ffff:ffff:ffff:ffff:ffff',
  'created' => '1421727536',
  'changed' => '1421727536',
  'status' => '1',
  'thread' => '01/',
  'name' => 'admin',
  'mail' => '',
  'homepage' => '',
  'language' => 'en',
))
->values(array(
  'cid' => '2',
  'pid' => '0',
  'nid' => '2',
  'uid' => '1',
  'subject' => 'TNG',
  'hostname' => '127.0.0.1',
  'created' => '1532789252',
  'changed' => '1532789252',
  'status' => '1',
  'thread' => '01/',
  'name' => 'admin',
  'mail' => '',
  'homepage' => '',
  'language' => 'en',
))
->values(array(
  'cid' => '3',
  'pid' => '0',
  'nid' => '3',
  'uid' => '1',
  'subject' => 'Comment to IS translation',
  'hostname' => '46.132.185.242',
  'created' => '1533031490',
  'changed' => '1533031490',
  'status' => '1',
  'thread' => '01/',
  'name' => 'admin',
  'mail' => '',
  'homepage' => '',
  'language' => 'is',
))
->values(array(
  'cid' => '4',
  'pid' => '0',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'Comment without language',
  'hostname' => 'drupal7.local',
  'created' => '1426781880',
  'changed' => '1426781880',
  'status' => '1',
  'thread' => '02/',
  'name' => 'Bob',
  'mail' => '',
  'homepage' => '',
  'language' => '',
))
->execute();
$connection->schema()->createTable('contact', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'category' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'recipients' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'reply' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'selected' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'binary' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_type')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '36',
  'format' => 'r',
  'type' => 'custom',
  'locked' => '0',
))
->execute();
$connection->schema()->createTable('entity_translation', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'source' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('entity_translation')
->fields(array(
  'entity_type',
  'entity_id',
  'revision_id',
  'language',
  'source',
  'uid',
  'status',
  'translate',
  'created',
  'changed',
))
->values(array(
  'entity_type' => 'comment',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1421727536',
  'changed' => '1421727536',
))
->values(array(
  'entity_type' => 'comment',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'source' => 'en',
  'uid' => '1',
  'status' => '0',
  'translate' => '0',
  'created' => '1531837764',
  'changed' => '1531837764',
))
->values(array(
  'entity_type' => 'comment',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'source' => 'en',
  'uid' => '2',
  'status' => '1',
  'translate' => '1',
  'created' => '1531838064',
  'changed' => '1531838064',
))
->values(array(
  'entity_type' => 'comment',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1426781880',
  'changed' => '1426781880',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1529615790',
  'changed' => '1529615790',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'source' => 'en',
  'uid' => '2',
  'status' => '1',
  'translate' => '1',
  'created' => '1529615802',
  'changed' => '1529615802',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '0',
  'translate' => '0',
  'created' => '1529615813',
  'changed' => '1529615813',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261687',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'fr',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261721',
  'changed' => '1568261721',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
))
->execute();
$connection->schema()->createTable('entity_translation_revision', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'source' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'revision_id',
    'language',
  ),
  'indexes' => array(
    'revision_id' => array(
      'revision_id',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('entity_translation_revision')
->fields(array(
  'entity_type',
  'entity_id',
  'revision_id',
  'language',
  'source',
  'uid',
  'status',
  'translate',
  'created',
  'changed',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1529615790',
  'changed' => '1529615790',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '15',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261523',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261523',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261687',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261687',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'fr',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261721',
  'changed' => '1568261721',
))
->values(array(
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
))
->execute();
$connection->schema()->createTable('field_config', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'storage_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'storage_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'storage_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'cardinality' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'translatable' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config')
->fields(array(
  'id',
  'field_name',
  'type',
  'module',
  'active',
  'storage_type',
  'storage_module',
  'storage_active',
  'locked',
  'data',
  'cardinality',
  'translatable',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_name' => 'comment_body',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:7:"comment";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_name' => 'body',
  'type' => 'text_with_summary',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:4:"node";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_name' => 'field_tags',
  'type' => 'taxonomy_term_reference',
  'module' => 'taxonomy',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:8:"settings";a:3:{s:14:"allowed_values";a:1:{i:0;a:2:{s:10:"vocabulary";s:4:"tags";s:6:"parent";i:0;}}s:21:"options_list_callback";N;s:23:"entity_translation_sync";b:0;}s:12:"entity_types";a:0:{}s:12:"translatable";s:1:"0";s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_tags";a:1:{s:3:"tid";s:14:"field_tags_tid";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_tags";a:1:{s:3:"tid";s:14:"field_tags_tid";}}}}}s:12:"foreign keys";a:1:{s:3:"tid";a:2:{s:5:"table";s:18:"taxonomy_term_data";s:7:"columns";a:1:{s:3:"tid";s:3:"tid";}}}s:7:"indexes";a:1:{s:3:"tid";a:1:{i:0;s:3:"tid";}}s:2:"id";s:1:"3";}',
  'cardinality' => '-1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_name' => 'field_image',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:8:"settings";a:2:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '5',
  'field_name' => 'taxonomy_forums',
  'type' => 'taxonomy_term_reference',
  'module' => 'taxonomy',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:8:"settings";a:3:{s:14:"allowed_values";a:1:{i:0;a:2:{s:10:"vocabulary";s:19:"sujet_de_discussion";s:6:"parent";i:0;}}s:21:"options_list_callback";N;s:23:"entity_translation_sync";b:0;}s:12:"entity_types";a:0:{}s:12:"translatable";s:1:"0";s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:26:"field_data_taxonomy_forums";a:1:{s:3:"tid";s:19:"taxonomy_forums_tid";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:30:"field_revision_taxonomy_forums";a:1:{s:3:"tid";s:19:"taxonomy_forums_tid";}}}}}s:12:"foreign keys";a:1:{s:3:"tid";a:2:{s:5:"table";s:18:"taxonomy_term_data";s:7:"columns";a:1:{s:3:"tid";s:3:"tid";}}}s:7:"indexes";a:1:{s:3:"tid";a:1:{i:0;s:3:"tid";}}s:2:"id";s:1:"5";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '11',
  'field_name' => 'field_file',
  'type' => 'file',
  'module' => 'file',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:13:"display_field";i:0;s:15:"display_default";i:0;s:10:"uri_scheme";s:6:"public";}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_file";a:3:{s:3:"fid";s:14:"field_file_fid";s:7:"display";s:18:"field_file_display";s:11:"description";s:22:"field_file_description";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_file";a:3:{s:3:"fid";s:14:"field_file_fid";s:7:"display";s:18:"field_file_display";s:11:"description";s:22:"field_file_description";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"11";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '40',
  'field_name' => 'title_field',
  'type' => 'text',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:10:"max_length";i:255;s:23:"entity_translation_sync";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->values(array(
  'id' => '41',
  'field_name' => 'subject_field',
  'type' => 'text',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:10:"max_length";i:255;s:23:"entity_translation_sync";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_config_instance', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config_instance')
->fields(array(
  'id',
  'field_id',
  'field_name',
  'entity_type',
  'bundle',
  'data',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_page',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:4:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:3:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"custom";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:11;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '5',
  'field_id' => '3',
  'field_name' => 'field_tags',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Tags";s:11:"description";s:63:"Enter a comma-separated list of words to describe your content.";s:6:"widget";a:4:{s:4:"type";s:21:"taxonomy_autocomplete";s:6:"weight";s:2:"-4";s:8:"settings";a:2:{s:4:"size";i:60;s:17:"autocomplete_path";s:21:"taxonomy/autocomplete";}s:6:"module";s:8:"taxonomy";}s:7:"display";a:2:{s:7:"default";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}s:6:"teaser";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:8:"required";b:0;}',
  'deleted' => '0',
))
->values(array(
  'id' => '6',
  'field_id' => '4',
  'field_name' => 'field_image',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:5:"Image";s:11:"description";s:40:"Upload an image to go with this article.";s:8:"required";b:0;s:8:"settings";a:10:{s:14:"file_directory";s:11:"field/image";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:11:"title_field";s:0:"";s:13:"default_image";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:4:"type";s:11:"image_image";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:6:"weight";s:2:"-1";s:6:"module";s:5:"image";}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '7',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_blog',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '8',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:4:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '9',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_book',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '10',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'book',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '11',
  'field_id' => '5',
  'field_name' => 'taxonomy_forums',
  'entity_type' => 'node',
  'bundle' => 'forum',
  'data' => 'a:6:{s:5:"label";s:6:"Forums";s:8:"required";b:1;s:6:"widget";a:4:{s:4:"type";s:14:"options_select";s:8:"settings";a:0:{}s:6:"weight";i:0;s:6:"module";s:7:"options";}s:7:"display";a:2:{s:7:"default";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}s:6:"teaser";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}}s:8:"settings";a:1:{s:18:"user_register_form";b:0;}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '12',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_forum',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '13',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'forum',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:1;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:11;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:11;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '14',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";s:1:"0";s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '33',
  'field_id' => '11',
  'field_name' => 'field_file',
  'entity_type' => 'user',
  'bundle' => 'user',
  'data' => 'a:6:{s:5:"label";s:4:"File";s:6:"widget";a:5:{s:6:"weight";s:1:"8";s:4:"type";s:12:"file_generic";s:6:"module";s:4:"file";s:6:"active";i:1;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}}s:8:"settings";a:5:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:3:"txt";s:12:"max_filesize";s:0:"";s:17:"description_field";i:0;s:18:"user_register_form";i:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"file_default";s:8:"settings";a:0:{}s:6:"module";s:4:"file";s:6:"weight";i:0;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '67',
  'field_id' => '40',
  'field_name' => 'title_field',
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'data' => 'a:6:{s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:20;}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '68',
  'field_id' => '41',
  'field_name' => 'subject_field',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:1;}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '71',
  'field_id' => '41',
  'field_name' => 'subject_field',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'data' => 'a:6:{s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:1;}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '83',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_et',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '86',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_a_thirty_two_character_type_name',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '87',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'a_thirty_two_character_type_name',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_data_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "...is that it's the absolute best show ever. Trust me, I would know.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "is - ...is that it's the absolute best show ever. Trust me, I would know.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'blog',
  'deleted' => '0',
  'entity_id' => '8',
  'revision_id' => '8',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "'Tis everywhere.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'blog',
  'deleted' => '0',
  'entity_id' => '9',
  'revision_id' => '9',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "fr - 'Tis everywhere.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'blog',
  'deleted' => '0',
  'entity_id' => '10',
  'revision_id' => '10',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "is - 'Tis everywhere.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_data_comment_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'comment_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_comment_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'comment_body_value',
  'comment_body_format',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'This is a comment',
  'comment_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'TNG is better than DS9.',
  'comment_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'This is a comment to an Icelandic translation.',
  'comment_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'A comment without language (migrated from Drupal 6)',
  'comment_body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_data_field_file', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_display' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'field_file_description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_data_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ),
    'field_image_width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_data_field_tags', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_tags_tid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_tags')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_tags_tid',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '0',
  'field_tags_tid' => '9',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '1',
  'field_tags_tid' => '14',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '2',
  'field_tags_tid' => '17',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '0',
  'field_tags_tid' => '9',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '1',
  'field_tags_tid' => '14',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '2',
  'field_tags_tid' => '17',
))
->execute();
$connection->schema()->createTable('field_data_subject_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'subject_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'subject_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'subject_field_format' => array(
      array(
        'subject_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_subject_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'subject_field_value',
  'subject_field_format',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'Subject field in English',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'subject_field_value' => 'Subject field in French',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'subject_field_value' => 'Subject field in Icelandic',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'TNG for the win!',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'is',
  'delta' => '0',
  'subject_field_value' => 'Comment to IS translation',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'Comment without language',
  'subject_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_data_taxonomy_forums', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'taxonomy_forums_tid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_taxonomy_forums')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'taxonomy_forums_tid',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'forum',
  'deleted' => '0',
  'entity_id' => '6',
  'revision_id' => '6',
  'language' => 'und',
  'delta' => '0',
  'taxonomy_forums_tid' => '1',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'forum',
  'deleted' => '0',
  'entity_id' => '7',
  'revision_id' => '7',
  'language' => 'und',
  'delta' => '0',
  'taxonomy_forums_tid' => '1',
))
->execute();
$connection->schema()->createTable('field_data_title_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'title_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'title_field_format' => array(
      array(
        'title_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_title_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'title_field_value',
  'title_field_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'title_field_value' => 'An English Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'title_field_value' => 'A French Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'title_field_value' => 'An Icelandic Node',
  'title_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_revision_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "...is that it's the absolute best show ever. Trust me, I would know.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "...is that it's the absolute best show ever. Trust me, I would know.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "is - ...is that it's the absolute best show ever. Trust me, I would know.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "is - ...is that it's the absolute best show ever. Trust me, I would know.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'is - Is that is it awesome.',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'blog',
  'deleted' => '0',
  'entity_id' => '8',
  'revision_id' => '8',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "'Tis everywhere.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'blog',
  'deleted' => '0',
  'entity_id' => '9',
  'revision_id' => '9',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "fr - 'Tis everywhere.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'blog',
  'deleted' => '0',
  'entity_id' => '10',
  'revision_id' => '10',
  'language' => 'und',
  'delta' => '0',
  'body_value' => "is - 'Tis everywhere.",
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '15',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '1st',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '1st',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_revision_comment_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'comment_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_comment_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'comment_body_value',
  'comment_body_format',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'This is a comment',
  'comment_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'TNG is better than DS9.',
  'comment_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'This is a comment to an Icelandic translation.',
  'comment_body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'comment_body_value' => 'A comment without language (migrated from Drupal 6)',
  'comment_body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_revision_field_file', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_display' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'field_file_description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_revision_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ),
    'field_image_width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_revision_field_tags', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_tags_tid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_tags')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_tags_tid',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'field_tags_tid' => '9',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '1',
  'field_tags_tid' => '14',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '2',
  'field_tags_tid' => '17',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '0',
  'field_tags_tid' => '9',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '1',
  'field_tags_tid' => '14',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '2',
  'field_tags_tid' => '17',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'field_tags_tid' => '9',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '1',
  'field_tags_tid' => '14',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '2',
  'field_tags_tid' => '17',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '0',
  'field_tags_tid' => '9',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '1',
  'field_tags_tid' => '14',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '12',
  'language' => 'und',
  'delta' => '2',
  'field_tags_tid' => '17',
))
->execute();
$connection->schema()->createTable('field_revision_subject_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'subject_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'subject_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'subject_field_format' => array(
      array(
        'subject_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_subject_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'subject_field_value',
  'subject_field_format',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'Subject field in English',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'subject_field_value' => 'Subject field in French',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'subject_field_value' => 'Subject field in Icelandic',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'TNG for the win!',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'is',
  'delta' => '0',
  'subject_field_value' => 'Comment to IS translation',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'Comment without language',
  'subject_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_revision_taxonomy_forums', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'taxonomy_forums_tid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_taxonomy_forums')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'taxonomy_forums_tid',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'forum',
  'deleted' => '0',
  'entity_id' => '6',
  'revision_id' => '6',
  'language' => 'und',
  'delta' => '0',
  'taxonomy_forums_tid' => '1',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'forum',
  'deleted' => '0',
  'entity_id' => '7',
  'revision_id' => '7',
  'language' => 'und',
  'delta' => '0',
  'taxonomy_forums_tid' => '1',
))
->execute();
$connection->schema()->createTable('field_revision_title_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'title_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'title_field_format' => array(
      array(
        'title_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_title_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'title_field_value',
  'title_field_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'title_field_value' => 'An English Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'title_field_value' => 'A French Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'title_field_value' => 'An Icelandic Node',
  'title_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('file_managed')
->fields(array(
  'fid',
  'uid',
  'filename',
  'uri',
  'filemime',
  'filesize',
  'status',
  'timestamp',
))
->values(array(
  'fid' => '3',
  'uid' => '1',
  'filename' => 'Babylon5.txt',
  'uri' => 'private://Babylon5.txt',
  'filemime' => 'text/plain',
  'filesize' => '4',
  'status' => '1',
  'timestamp' => '1486104045',
))
->values(array(
  'fid' => '4',
  'uid' => '1',
  'filename' => 'TerokNor.txt',
  'uri' => 'temporary://TerokNor.txt',
  'filemime' => 'text/plain',
  'filesize' => '2369',
  'status' => '1',
  'timestamp' => '1421747516',
))
->execute();
$connection->schema()->createTable('file_usage', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
    'module',
    'type',
    'id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('file_usage')
->fields(array(
  'fid',
  'module',
  'type',
  'id',
  'count',
))
->values(array(
  'fid' => '3',
  'module' => 'file',
  'type' => 'node',
  'id' => '1',
  'count' => '1',
))
->execute();
$connection->schema()->createTable('filter', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'settings' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'format',
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter')
->fields(array(
  'format',
  'module',
  'name',
  'weight',
  'status',
  'settings',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:82:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd> <table>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:1;}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:1:{s:17:"filter_url_length";s:2:"72";}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:37:"<div> <span> <ul> <li> <ol> <a> <img>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";s:3:"128";}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'php',
  'name' => 'php_code',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->execute();
$connection->schema()->createTable('filter_format', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_format')
->fields(array(
  'format',
  'name',
  'cache',
  'status',
  'weight',
))
->values(array(
  'format' => 'custom_text_format',
  'name' => 'Custom Text format',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'filtered_html',
  'name' => 'Filtered HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'full_html',
  'name' => 'Full HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '1',
))
->values(array(
  'format' => 'php_code',
  'name' => 'PHP code',
  'cache' => '0',
  'status' => '0',
  'weight' => '11',
))
->values(array(
  'format' => 'plain_text',
  'name' => 'Plain text',
  'cache' => '1',
  'status' => '1',
  'weight' => '10',
))
->execute();
$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'identifier' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expiration' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('forum', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('forum')
->fields(array(
  'nid',
  'vid',
  'tid',
))
->values(array(
  'nid' => '6',
  'vid' => '6',
  'tid' => '1',
))
->values(array(
  'nid' => '7',
  'vid' => '7',
  'tid' => '1',
))
->execute();
$connection->schema()->createTable('forum_index', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('forum_index')
->fields(array(
  'nid',
  'title',
  'tid',
  'sticky',
  'created',
  'last_comment_timestamp',
  'comment_count',
))
->values(array(
  'nid' => '6',
  'title' => 'Comments are closed :-(',
  'tid' => '1',
  'sticky' => '0',
  'created' => '1504715414',
  'last_comment_timestamp' => '1504715414',
  'comment_count' => '0',
))
->values(array(
  'nid' => '7',
  'title' => 'Comments are open :-)',
  'tid' => '1',
  'sticky' => '0',
  'created' => '1504715432',
  'last_comment_timestamp' => '1504715432',
  'comment_count' => '0',
))
->execute();
$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('i18n_string', array(
  'fields' => array(
    'lid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'textgroup' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => 'default',
    ),
    'context' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'objectid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'property' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'objectindex' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'lid',
  ),
  'indexes' => array(
    'group_context' => array(
      'textgroup',
      array(
        'context',
        '50',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('i18n_string')
->fields(array(
  'lid',
  'textgroup',
  'context',
  'objectid',
  'type',
  'property',
  'objectindex',
  'format',
))
->values(array(
  'lid' => '57',
  'textgroup' => 'blocks',
  'context' => 'block:1:title',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'title',
  'objectindex' => '1',
  'format' => '',
))
->values(array(
  'lid' => '60',
  'textgroup' => 'blocks',
  'context' => 'block:1:body',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'body',
  'objectindex' => '1',
  'format' => 'filtered_html',
))
->values(array(
  'lid' => '61',
  'textgroup' => 'node',
  'context' => 'type:article:name',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '62',
  'textgroup' => 'node',
  'context' => 'type:article:title_label',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '63',
  'textgroup' => 'node',
  'context' => 'type:article:description',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '64',
  'textgroup' => 'node',
  'context' => 'type:article:help',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'help',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '65',
  'textgroup' => 'node',
  'context' => 'type:book:name',
  'objectid' => 'book',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '66',
  'textgroup' => 'node',
  'context' => 'type:book:title_label',
  'objectid' => 'book',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '67',
  'textgroup' => 'node',
  'context' => 'type:book:description',
  'objectid' => 'book',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '68',
  'textgroup' => 'node',
  'context' => 'type:page:name',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '69',
  'textgroup' => 'node',
  'context' => 'type:page:title_label',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '70',
  'textgroup' => 'node',
  'context' => 'type:page:description',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '71',
  'textgroup' => 'node',
  'context' => 'type:page:help',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'help',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '72',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:name',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '73',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:title_label',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '74',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:description',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '75',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:help',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'help',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '76',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_page:label',
  'objectid' => 'comment_node_page',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '81',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:name',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '',
))
->values(array(
  'lid' => '82',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:description',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '2',
  'format' => '',
))
->values(array(
  'lid' => '83',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:1:name',
  'objectid' => '1',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '1',
  'format' => '',
))
->values(array(
  'lid' => '84',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:1:description',
  'objectid' => '1',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '1',
  'format' => '',
))
->values(array(
  'lid' => '95',
  'textgroup' => 'field',
  'context' => 'field_boolean:test_content_type:description',
  'objectid' => 'test_content_type',
  'type' => 'field_boolean',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '102',
  'textgroup' => 'field',
  'context' => 'field_file:user:label',
  'objectid' => 'user',
  'type' => 'field_file',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '107',
  'textgroup' => 'field',
  'context' => 'field_integer:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'field_integer',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '116',
  'textgroup' => 'field',
  'context' => 'field_text_list:#allowed_values:Some Text',
  'objectid' => '#allowed_values',
  'type' => 'field_text_list',
  'property' => 'Some Text',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '117',
  'textgroup' => 'field',
  'context' => 'field_text_list:#allowed_values:Some more text',
  'objectid' => '#allowed_values',
  'type' => 'field_text_list',
  'property' => 'Some more text',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '118',
  'textgroup' => 'field',
  'context' => 'field_text_list:#allowed_values:The key',
  'objectid' => '#allowed_values',
  'type' => 'field_text_list',
  'property' => 'The key',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '120',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '121',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:2',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '2',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '122',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:3',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '3',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '123',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:6',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '6',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '124',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:7',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '7',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '158',
  'textgroup' => 'field',
  'context' => 'title_field:test_content_type:label',
  'objectid' => 'test_content_type',
  'type' => 'title_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '159',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_article:label',
  'objectid' => 'comment_node_article',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '160',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '161',
  'textgroup' => 'field',
  'context' => 'name_field:test_vocabulary:label',
  'objectid' => 'test_vocabulary',
  'type' => 'name_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '163',
  'textgroup' => 'blocks',
  'context' => 'user:login:title',
  'objectid' => 'login',
  'type' => 'user',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '674',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_book:label',
  'objectid' => 'comment_node_book',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '675',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_forum:label',
  'objectid' => 'comment_node_forum',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '676',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '677',
  'textgroup' => 'field',
  'context' => 'body:page:label',
  'objectid' => 'page',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '678',
  'textgroup' => 'field',
  'context' => 'body:article:label',
  'objectid' => 'article',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '679',
  'textgroup' => 'field',
  'context' => 'body:blog:label',
  'objectid' => 'blog',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '680',
  'textgroup' => 'field',
  'context' => 'body:book:label',
  'objectid' => 'book',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '681',
  'textgroup' => 'field',
  'context' => 'body:forum:label',
  'objectid' => 'forum',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '682',
  'textgroup' => 'field',
  'context' => 'field_tags:article:label',
  'objectid' => 'article',
  'type' => 'field_tags',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '683',
  'textgroup' => 'field',
  'context' => 'field_tags:article:description',
  'objectid' => 'article',
  'type' => 'field_tags',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '684',
  'textgroup' => 'field',
  'context' => 'field_image:article:label',
  'objectid' => 'article',
  'type' => 'field_image',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '685',
  'textgroup' => 'field',
  'context' => 'field_image:article:description',
  'objectid' => 'article',
  'type' => 'field_image',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '686',
  'textgroup' => 'field',
  'context' => 'taxonomy_forums:forum:label',
  'objectid' => 'forum',
  'type' => 'taxonomy_forums',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '687',
  'textgroup' => 'field',
  'context' => 'field_boolean:#allowed_values:0',
  'objectid' => '#allowed_values',
  'type' => 'field_boolean',
  'property' => '0',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '688',
  'textgroup' => 'field',
  'context' => 'field_boolean:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_boolean',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '689',
  'textgroup' => 'field',
  'context' => 'field_boolean:test_content_type:label',
  'objectid' => 'test_content_type',
  'type' => 'field_boolean',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '754',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_article:label',
  'objectid' => 'comment_node_article',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '755',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '756',
  'textgroup' => 'field',
  'context' => 'name_field:test_vocabulary:label',
  'objectid' => 'test_vocabulary',
  'type' => 'name_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '758',
  'textgroup' => 'field',
  'context' => 'field_vocab_localize:article:label',
  'objectid' => 'article',
  'type' => 'field_vocab_localize',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '759',
  'textgroup' => 'field',
  'context' => 'field_vocab_translate:article:label',
  'objectid' => 'article',
  'type' => 'field_vocab_translate',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '760',
  'textgroup' => 'field',
  'context' => 'field_vocab_fixed:article:label',
  'objectid' => 'article',
  'type' => 'field_vocab_fixed',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '761',
  'textgroup' => 'field',
  'context' => 'field_color:#allowed_values:0',
  'objectid' => '#allowed_values',
  'type' => 'field_color',
  'property' => '0',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '762',
  'textgroup' => 'field',
  'context' => 'field_color:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_color',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '763',
  'textgroup' => 'field',
  'context' => 'field_color:#allowed_values:2',
  'objectid' => '#allowed_values',
  'type' => 'field_color',
  'property' => '2',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '764',
  'textgroup' => 'field',
  'context' => 'field_color:blog:label',
  'objectid' => 'blog',
  'type' => 'field_color',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '765',
  'textgroup' => 'field',
  'context' => 'field_rating:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_rating',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '766',
  'textgroup' => 'field',
  'context' => 'field_rating:#allowed_values:2',
  'objectid' => '#allowed_values',
  'type' => 'field_rating',
  'property' => '2',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '767',
  'textgroup' => 'field',
  'context' => 'field_rating:#allowed_values:3',
  'objectid' => '#allowed_values',
  'type' => 'field_rating',
  'property' => '3',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '768',
  'textgroup' => 'field',
  'context' => 'field_rating:blog:label',
  'objectid' => 'blog',
  'type' => 'field_rating',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '780',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:name',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '',
))
->values(array(
  'lid' => '781',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:description',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '2',
  'format' => '',
))
->values(array(
  'lid' => '794',
  'textgroup' => 'field',
  'context' => 'taxonomy_forums:forum:label',
  'objectid' => 'forum',
  'type' => 'taxonomy_forums',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '795',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_article:label',
  'objectid' => 'comment_node_article',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '796',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_blog:label',
  'objectid' => 'comment_node_blog',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '797',
  'textgroup' => 'taxonomy',
  'context' => 'term:25:name',
  'objectid' => '25',
  'type' => 'term',
  'property' => 'name',
  'objectindex' => '25',
  'format' => '',
))
->values(array(
  'lid' => '798',
  'textgroup' => 'taxonomy',
  'context' => 'term:25:description',
  'objectid' => '25',
  'type' => 'term',
  'property' => 'description',
  'objectindex' => '25',
  'format' => '',
))
->values(array(
  'lid' => '800',
  'textgroup' => 'menu',
  'context' => 'menu:main-menu:title',
  'objectid' => 'main-menu',
  'type' => 'menu',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '801',
  'textgroup' => 'menu',
  'context' => 'menu:main-menu:description',
  'objectid' => 'main-menu',
  'type' => 'menu',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '802',
  'textgroup' => 'menu',
  'context' => 'menu:menu-test-menu:description',
  'objectid' => 'menu-test-menu',
  'type' => 'menu',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '803',
  'textgroup' => 'menu',
  'context' => 'item:467:title',
  'objectid' => '467',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '467',
  'format' => '',
))
->values(array(
  'lid' => '804',
  'textgroup' => 'menu',
  'context' => 'item:467:description',
  'objectid' => '467',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '467',
  'format' => '',
))
->values(array(
  'lid' => '805',
  'textgroup' => 'field',
  'context' => 'field_checkbox:#allowed_values:0',
  'objectid' => '#allowed_values',
  'type' => 'field_checkbox',
  'property' => '0',
  'objectindex' => '0',
  'format' => '',
))
->values(array(
  'lid' => '806',
  'textgroup' => 'field',
  'context' => 'field_checkbox:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_checkbox',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
))
->execute();
$connection->schema()->createTable('i18n_translation_set', array(
  'fields' => array(
    'tsid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'master_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tsid',
  ),
  'indexes' => array(
    'entity_bundle' => array(
      'type',
      'bundle',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('image_effects', array(
  'fields' => array(
    'ieid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'isid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'ieid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('image_effects')
->fields(array(
  'ieid',
  'isid',
  'weight',
  'name',
  'data',
))
->values(array(
  'ieid' => '3',
  'isid' => '1',
  'weight' => '1',
  'name' => 'image_scale_and_crop',
  'data' => 'a:2:{s:5:"width";s:2:"55";s:6:"height";s:2:"55";}',
))
->values(array(
  'ieid' => '4',
  'isid' => '1',
  'weight' => '2',
  'name' => 'image_desaturate',
  'data' => 'a:0:{}',
))
->values(array(
  'ieid' => '5',
  'isid' => '2',
  'weight' => '1',
  'name' => 'image_resize',
  'data' => 'a:2:{s:5:"width";s:2:"55";s:6:"height";s:3:"100";}',
))
->values(array(
  'ieid' => '6',
  'isid' => '2',
  'weight' => '2',
  'name' => 'image_rotate',
  'data' => 'a:3:{s:7:"degrees";s:2:"45";s:7:"bgcolor";s:7:"#FFFFFF";s:6:"random";i:0;}',
))
->values(array(
  'ieid' => '7',
  'isid' => '3',
  'weight' => '1',
  'name' => 'image_scale',
  'data' => 'a:3:{s:5:"width";s:3:"150";s:6:"height";s:0:"";s:7:"upscale";i:0;}',
))
->values(array(
  'ieid' => '8',
  'isid' => '3',
  'weight' => '2',
  'name' => 'image_crop',
  'data' => 'a:3:{s:5:"width";s:2:"50";s:6:"height";s:2:"50";s:6:"anchor";s:8:"left-top";}',
))
->execute();
$connection->schema()->createTable('image_styles', array(
  'fields' => array(
    'isid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'isid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('image_styles')
->fields(array(
  'isid',
  'name',
  'label',
))
->values(array(
  'isid' => '1',
  'name' => 'custom_image_style_1',
  'label' => 'Custom image style 1',
))
->values(array(
  'isid' => '2',
  'name' => 'custom_image_style_2',
  'label' => 'Custom image style 2',
))
->values(array(
  'isid' => '3',
  'name' => 'custom_image_style_3',
  'label' => 'Custom image style 3',
))
->execute();
$connection->schema()->createTable('languages', array(
  'fields' => array(
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'native' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'direction' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'enabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'plurals' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'formula' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'domain' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'prefix' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'javascript' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('languages')
->fields(array(
  'language',
  'name',
  'native',
  'direction',
  'enabled',
  'plurals',
  'formula',
  'domain',
  'prefix',
  'weight',
  'javascript',
))
->values(array(
  'language' => 'en',
  'name' => 'English',
  'native' => 'English',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => '',
  'prefix' => '',
  'weight' => '0',
  'javascript' => '',
))
->values(array(
  'language' => 'fr',
  'name' => 'French',
  'native' => 'Français',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => 'fr.drupal.org',
  'prefix' => 'fr',
  'weight' => '0',
  'javascript' => '',
))
->values(array(
  'language' => 'is',
  'name' => 'Icelandic',
  'native' => 'Íslenska',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => 'is.drupal.org',
  'prefix' => 'is',
  'weight' => '0',
  'javascript' => '',
))
->execute();
$connection->schema()->createTable('locales_source', array(
  'fields' => array(
    'lid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'location' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'textgroup' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'default',
    ),
    'source' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'context' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'version' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '20',
      'default' => 'none',
    ),
  ),
  'primary key' => array(
    'lid',
  ),
  'indexes' => array(
    'textgroup_context' => array(
      array(
        'textgroup',
        '191',
      ),
      array(
        'context',
        '50',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('locales_source')
->fields(array(
  'lid',
  'location',
  'textgroup',
  'source',
  'context',
  'version',
))
->values(array(
  'lid' => '1',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An AJAX HTTP error occurred.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '2',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'HTTP Result Code: !status',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '3',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An AJAX HTTP request terminated abnormally.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '4',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'Debugging information follows.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '5',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'Path: !uri',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '6',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'StatusText: !statusText',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '7',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'ResponseText: !responseText',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '8',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'ReadyState: !readyState',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '9',
  'location' => 'misc/collapse.js',
  'textgroup' => 'default',
  'source' => 'Hide',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '10',
  'location' => 'misc/collapse.js',
  'textgroup' => 'default',
  'source' => 'Show',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '11',
  'location' => 'modules/toolbar/toolbar.js',
  'textgroup' => 'default',
  'source' => 'Show shortcuts',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '12',
  'location' => 'modules/toolbar/toolbar.js',
  'textgroup' => 'default',
  'source' => 'Hide shortcuts',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '13',
  'location' => 'misc/machine-name.js',
  'textgroup' => 'default',
  'source' => 'Edit',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '14',
  'location' => 'modules/comment/comment-node-form.js',
  'textgroup' => 'default',
  'source' => '@number comments per page',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '15',
  'location' => 'misc/vertical-tabs.js',
  'textgroup' => 'default',
  'source' => '(active tab)',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '16',
  'location' => 'modules/node/content_types.js',
  'textgroup' => 'default',
  'source' => 'Requires a title',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '17',
  'location' => 'modules/node/content_types.js; modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'Not published',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '18',
  'location' => 'modules/node/content_types.js',
  'textgroup' => 'default',
  'source' => "Don't display post information",
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '19',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Re-order rows by numerical weight instead of dragging.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '20',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Show row weights',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '21',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Hide row weights',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '22',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Drag to re-order',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '23',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Changes made in this table will not be saved until the form is submitted.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '24',
  'location' => 'sites/all/modules/date/date_api/date_year_range.js',
  'textgroup' => 'default',
  'source' => 'Other',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '25',
  'location' => 'sites/all/modules/date/date_api/date_year_range.js',
  'textgroup' => 'default',
  'source' => '@count year from now',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '26',
  'location' => 'sites/all/modules/date/date_api/date_year_range.js',
  'textgroup' => 'default',
  'source' => '@count years from now',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '27',
  'location' => 'modules/file/file.js',
  'textgroup' => 'default',
  'source' => 'The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '28',
  'location' => 'misc/ajax.js',
  'textgroup' => 'default',
  'source' => 'Please wait...',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '29',
  'location' => 'modules/field/modules/text/text.js',
  'textgroup' => 'default',
  'source' => 'Hide summary',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '30',
  'location' => 'modules/field/modules/text/text.js',
  'textgroup' => 'default',
  'source' => 'Edit summary',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '31',
  'location' => 'misc/autocomplete.js',
  'textgroup' => 'default',
  'source' => 'Autocomplete popup',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '32',
  'location' => 'misc/autocomplete.js',
  'textgroup' => 'default',
  'source' => 'Searching for matches...',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '33',
  'location' => 'modules/contextual/contextual.js',
  'textgroup' => 'default',
  'source' => 'Configure',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '34',
  'location' => 'misc/tableselect.js',
  'textgroup' => 'default',
  'source' => 'Select all rows in this table',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '35',
  'location' => 'misc/tableselect.js',
  'textgroup' => 'default',
  'source' => 'Deselect all rows in this table',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '36',
  'location' => 'modules/user/user.permissions.js',
  'textgroup' => 'default',
  'source' => 'This permission is inherited from the authenticated user role.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '37',
  'location' => 'modules/filter/filter.admin.js',
  'textgroup' => 'default',
  'source' => 'Enabled',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '38',
  'location' => 'modules/filter/filter.admin.js',
  'textgroup' => 'default',
  'source' => 'Disabled',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '39',
  'location' => 'modules/menu/menu.js',
  'textgroup' => 'default',
  'source' => 'Not in menu',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '40',
  'location' => 'modules/book/book.js',
  'textgroup' => 'default',
  'source' => 'Not in book',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '41',
  'location' => 'modules/book/book.js',
  'textgroup' => 'default',
  'source' => 'New book',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '42',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'New revision',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '43',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'No revision',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '44',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'By @name on @date',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '45',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'By @name',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '46',
  'location' => 'modules/path/path.js',
  'textgroup' => 'default',
  'source' => 'Alias: @alias',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '47',
  'location' => 'modules/path/path.js',
  'textgroup' => 'default',
  'source' => 'No alias',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '48',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'CustomMessage: !customMessage',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '49',
  'location' => 'modules/block/block.js; sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Not restricted',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '50',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'Restricted to certain pages',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '51',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'Not customizable',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '52',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'The changes to these blocks will not be saved until the <em>Save blocks</em> button is clicked.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '53',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'The block cannot be placed in this region.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '54',
  'location' => 'sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Translatable',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '55',
  'location' => 'sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Not translatable',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '56',
  'location' => 'sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Restricted to certain languages',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '58',
  'location' => 'misc/ajax.js',
  'textgroup' => 'default',
  'source' => 'The response failed verification so will not be processed.',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '59',
  'location' => 'misc/ajax.js',
  'textgroup' => 'default',
  'source' => 'The callback URL is not local and not trusted: !url',
  'context' => '',
  'version' => 'none',
))
->values(array(
  'lid' => '61',
  'location' => 'node:type:article:name',
  'textgroup' => 'node',
  'source' => 'Article',
  'context' => 'type:article:name',
  'version' => '1',
))
->values(array(
  'lid' => '62',
  'location' => 'node:type:article:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:article:title_label',
  'version' => '1',
))
->values(array(
  'lid' => '63',
  'location' => 'node:type:article:description',
  'textgroup' => 'node',
  'source' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'context' => 'type:article:description',
  'version' => '1',
))
->values(array(
  'lid' => '64',
  'location' => 'node:type:article:help',
  'textgroup' => 'node',
  'source' => 'Help text for articles',
  'context' => 'type:article:help',
  'version' => '1',
))
->values(array(
  'lid' => '65',
  'location' => 'node:type:book:name',
  'textgroup' => 'node',
  'source' => 'Book page',
  'context' => 'type:book:name',
  'version' => '1',
))
->values(array(
  'lid' => '66',
  'location' => 'node:type:book:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:book:title_label',
  'version' => '1',
))
->values(array(
  'lid' => '67',
  'location' => 'node:type:book:description',
  'textgroup' => 'node',
  'source' => '<em>Books</em> have a built-in hierarchical navigation. Use for handbooks or tutorials.',
  'context' => 'type:book:description',
  'version' => '1',
))
->values(array(
  'lid' => '68',
  'location' => 'node:type:page:name',
  'textgroup' => 'node',
  'source' => 'Basic page',
  'context' => 'type:page:name',
  'version' => '1',
))
->values(array(
  'lid' => '69',
  'location' => 'node:type:page:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:page:title_label',
  'version' => '1',
))
->values(array(
  'lid' => '70',
  'location' => 'node:type:page:description',
  'textgroup' => 'node',
  'source' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'context' => 'type:page:description',
  'version' => '1',
))
->values(array(
  'lid' => '71',
  'location' => 'node:type:page:help',
  'textgroup' => 'node',
  'source' => 'Help text for basic pages',
  'context' => 'type:page:help',
  'version' => '1',
))
->values(array(
  'lid' => '72',
  'location' => 'node:type:test_content_type:name',
  'textgroup' => 'node',
  'source' => 'Test content type',
  'context' => 'type:test_content_type:name',
  'version' => '1',
))
->values(array(
  'lid' => '73',
  'location' => 'node:type:test_content_type:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:test_content_type:title_label',
  'version' => '1',
))
->values(array(
  'lid' => '74',
  'location' => 'node:type:test_content_type:description',
  'textgroup' => 'node',
  'source' => 'This is the description of the test content type.',
  'context' => 'type:test_content_type:description',
  'version' => '1',
))
->values(array(
  'lid' => '75',
  'location' => 'node:type:test_content_type:help',
  'textgroup' => 'node',
  'source' => 'Help text for test content type',
  'context' => 'type:test_content_type:help',
  'version' => '1',
))
->values(array(
  'lid' => '81',
  'location' => 'taxonomy:vocabulary:2:name',
  'textgroup' => 'taxonomy',
  'source' => 'Sujet de discussion',
  'context' => 'vocabulary:2:name',
  'version' => '1',
))
->values(array(
  'lid' => '82',
  'location' => 'taxonomy:vocabulary:2:description',
  'textgroup' => 'taxonomy',
  'source' => 'Forum navigation vocabulary',
  'context' => 'vocabulary:2:description',
  'version' => '1',
))
->values(array(
  'lid' => '83',
  'location' => 'taxonomy:vocabulary:1:name',
  'textgroup' => 'taxonomy',
  'source' => 'Tags',
  'context' => 'vocabulary:1:name',
  'version' => '1',
))
->values(array(
  'lid' => '84',
  'location' => 'taxonomy:vocabulary:1:description',
  'textgroup' => 'taxonomy',
  'source' => 'Use tags to group articles on similar topics into categories.',
  'context' => 'vocabulary:1:description',
  'version' => '1',
))
->values(array(
  'lid' => '95',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Public files',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '102',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Name',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '107',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Blog entry',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '116',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Full content',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '117',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Teaser',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '118',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'RSS',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '120',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Search result highlighting input',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '121',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'File',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '122',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy term page',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '123',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy vocabulary',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '124',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '158',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the secondary_links (local tasks) as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '159',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Site name',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '160',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The name of the site, optionally links to the front page.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '161',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Actions',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '163',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Page title',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '164',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the page title as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '165',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Site logo',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '166',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the logo trail as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '167',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Feed icons',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '168',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the site feed_icons statement as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '169',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Site slogan',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '170',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => "Add the site's slogan as content.",
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '171',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Status messages',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '172',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the status messages of the current page as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '173',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Breadcrumb',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '174',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the breadcrumb trail as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '175',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Primary navigation links',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '176',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the primary_links (local tasks) as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '177',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Tabs',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '178',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the tabs (local tasks) as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '179',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User contact form',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '180',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The site contact form that allows users to contact other users.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '181',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Contact form',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '182',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The site contact form that allows users to send a message to site administrators.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '183',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Vocabulary terms',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '184',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'All the terms in a vocabulary.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '185',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Vocabulary',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '186',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Block',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '187',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form url path settings',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '188',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Publishing options on the Node form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '189',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Form',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '190',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form submit buttons',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '191',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Submit buttons for the node form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '192',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form comment settings',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '193',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment settings on the Node form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '197',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Book options for the node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '198',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form title field',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '199',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The node title form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '200',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form menu settings',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '201',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Menu settings on the Node form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '202',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form revision log message',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '203',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Revision log message for the node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '204',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form publishing options',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '205',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form author information',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '206',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Author information on the Node form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '207',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Entity extra field',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '208',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Entity field',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '209',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Custom content',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '210',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'General form',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '211',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Everything in the form that is not displayed by other content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '212',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Book navigation',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '213',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The navigation menu the book the node belongs to.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '214',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node links',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '215',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node links of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '216',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment form',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '217',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'A form to add a new comment.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '218',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node last updated date',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '219',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The date the referenced node was last updated.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '220',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node terms',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '221',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy terms of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '222',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Book children',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '223',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The children menu the book the node belongs to.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '224',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node comments',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '225',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The comments of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '226',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Attached files',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '227',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'A list of files attached to the node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '228',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comments and comment form.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '229',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The comments and comment form for the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '230',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node content',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '231',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The content of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '232',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node type description',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '233',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node type description.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '234',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node title',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '235',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The title of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '236',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node body',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '237',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The body of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '238',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node author',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '239',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The author of the referenced node.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '240',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node created date',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '241',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The date the referenced node was created.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '242',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Existing node',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '243',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add a node from your site as content.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '244',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Custom',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '245',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User signature',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '246',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The signature of a user.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '247',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User links',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '248',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User links of the referenced user.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '249',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User profile',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '250',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The profile of a user.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '251',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User picture',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '252',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The picture of a user.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '253',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment Reply Form',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '254',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'A form to add a new comment reply.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '255',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment links',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '256',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment links of the referenced comment.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '257',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment created date',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '258',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The date the referenced comment was created.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '259',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term name',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '260',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The name of this taxonomy term.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '261',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '262',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'List of related terms',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '263',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Terms related to an existing term; may be child, siblings or top level.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '264',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term description',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '265',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term description.',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '266',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Rendered entity',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '267',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Status message',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '268',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Error message',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '269',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Warning message',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '270',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Skip to main content',
  'context' => '',
  'version' => '7.92',
))
->values(array(
  'lid' => '271',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Home',
  'context' => '',
  'version' => '7.92',
))
->execute();
$connection->schema()->createTable('locales_target', array(
  'fields' => array(
    'lid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'translation' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'plural' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'i18n_status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'lid',
    'language',
    'plural',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('locales_target')
->fields(array(
  'lid',
  'translation',
  'language',
  'plid',
  'plural',
  'i18n_status',
))
->values(array(
  'lid' => '95',
  'translation' => 'is - Some helpful text.',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '163',
  'translation' => 'fr - User login title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '678',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '1',
))
->values(array(
  'lid' => '684',
  'translation' => 'fr - Image',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '1',
))
->values(array(
  'lid' => '687',
  'translation' => 'is - Off',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '688',
  'translation' => 'is - 1',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '758',
  'translation' => 'is field - vocab_localize',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '761',
  'translation' => 'Verte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '761',
  'translation' => 'Grænn',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '762',
  'translation' => 'Noire',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '762',
  'translation' => 'Svartur',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '763',
  'translation' => 'Blanche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '763',
  'translation' => 'Hvítur',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '764',
  'translation' => 'Color',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '764',
  'translation' => 'Color',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '765',
  'translation' => 'Haute',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '765',
  'translation' => 'Hár',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '766',
  'translation' => 'Moyenne',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '766',
  'translation' => 'Miðlungs',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '767',
  'translation' => 'Faible',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '767',
  'translation' => 'Lágt',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '768',
  'translation' => 'Rating',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '768',
  'translation' => 'Rating',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '797',
  'translation' => 'fr - Emissary',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '798',
  'translation' => 'fr - Pilot episode',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '800',
  'translation' => 'fr - Main menu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '800',
  'translation' => 'is - Main menu',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '801',
  'translation' => 'fr - Main menu description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '801',
  'translation' => 'is - Main menu description',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '802',
  'translation' => 'fr - Test menu description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '803',
  'translation' => 'fr - Google',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '804',
  'translation' => 'fr - Google description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '805',
  'translation' => 'fr - Stop',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '805',
  'translation' => 'is - Stop',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '806',
  'translation' => 'Go',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '806',
  'translation' => 'is - Go',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->execute();
$connection->schema()->createTable('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_custom')
->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'main-menu',
  'title' => 'Main menu',
  'description' => 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.',
))
->values(array(
  'menu_name' => 'management',
  'title' => 'Management',
  'description' => 'The <em>Management</em> menu contains links for administrative tasks.',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.',
))
->values(array(
  'menu_name' => 'user-menu',
  'title' => 'User menu',
  'description' => "The <em>User</em> menu contains links related to the user's account, as well as the 'Log out' link.",
))
->execute();
$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:1:{s:5:"alter";b:1;}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'comment/%',
  'router_path' => 'comment/%',
  'link_title' => 'Comment permalink',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '6',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '6',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '7',
  'plid' => '1',
  'link_path' => 'admin/appearance',
  'router_path' => 'admin/appearance',
  'link_title' => 'Appearance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Select and configure your themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-6',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '8',
  'plid' => '1',
  'link_path' => 'admin/config',
  'router_path' => 'admin/config',
  'link_title' => 'Configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '9',
  'plid' => '1',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Administer content and comments.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '10',
  'plid' => '2',
  'link_path' => 'user/register',
  'router_path' => 'user/register',
  'link_title' => 'Create new account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '12',
  'plid' => '1',
  'link_path' => 'admin/index',
  'router_path' => 'admin/index',
  'link_title' => 'Index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-18',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '12',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '13',
  'plid' => '2',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Log in',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '13',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'user/logout',
  'router_path' => 'user/logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '15',
  'plid' => '1',
  'link_path' => 'admin/modules',
  'router_path' => 'admin/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Extend site functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '16',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '16',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '17',
  'plid' => '1',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '18',
  'plid' => '1',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '19',
  'plid' => '2',
  'link_path' => 'user/password',
  'router_path' => 'user/password',
  'link_title' => 'Request new password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '20',
  'plid' => '1',
  'link_path' => 'admin/structure',
  'router_path' => 'admin/structure',
  'link_title' => 'Structure',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '21',
  'plid' => '1',
  'link_path' => 'admin/tasks',
  'router_path' => 'admin/tasks',
  'link_title' => 'Tasks',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '21',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '22',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Add new comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '22',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '3',
  'link_path' => 'comment/%/approve',
  'router_path' => 'comment/%/approve',
  'link_title' => 'Approve',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '23',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '24',
  'plid' => '3',
  'link_path' => 'comment/%/delete',
  'router_path' => 'comment/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '24',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '25',
  'plid' => '3',
  'link_path' => 'comment/%/edit',
  'router_path' => 'comment/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '26',
  'plid' => '3',
  'link_path' => 'comment/%/view',
  'router_path' => 'comment/%/view',
  'link_title' => 'View comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '26',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '27',
  'plid' => '17',
  'link_path' => 'admin/people/create',
  'router_path' => 'admin/people/create',
  'link_title' => 'Add user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '27',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '28',
  'plid' => '20',
  'link_path' => 'admin/structure/block',
  'router_path' => 'admin/structure/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '29',
  'plid' => '16',
  'link_path' => 'user/%/cancel',
  'router_path' => 'user/%/cancel',
  'link_title' => 'Cancel account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '29',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '30',
  'plid' => '9',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"List and edit site comments and the comment approval queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '32',
  'plid' => '9',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '33',
  'plid' => '8',
  'link_path' => 'admin/config/content',
  'router_path' => 'admin/config/content',
  'link_title' => 'Content authoring',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '34',
  'plid' => '20',
  'link_path' => 'admin/structure/types',
  'router_path' => 'admin/structure/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Manage content types, including default status, front page promotion, comment settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '36',
  'plid' => '5',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '36',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '37',
  'plid' => '8',
  'link_path' => 'admin/config/development',
  'router_path' => 'admin/config/development',
  'link_title' => 'Development',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '38',
  'plid' => '16',
  'link_path' => 'user/%/edit',
  'router_path' => 'user/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '5',
  'link_path' => 'node/%/edit',
  'router_path' => 'node/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '40',
  'plid' => '15',
  'link_path' => 'admin/modules/list',
  'router_path' => 'admin/modules/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '41',
  'plid' => '17',
  'link_path' => 'admin/people/people',
  'router_path' => 'admin/people/people',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Find and manage people interacting with your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '42',
  'plid' => '7',
  'link_path' => 'admin/appearance/list',
  'router_path' => 'admin/appearance/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Select and configure your theme";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '43',
  'plid' => '8',
  'link_path' => 'admin/config/media',
  'router_path' => 'admin/config/media',
  'link_title' => 'Media',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '44',
  'plid' => '20',
  'link_path' => 'admin/structure/menu',
  'router_path' => 'admin/structure/menu',
  'link_title' => 'Menus',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:86:"Add new menus to your site, edit existing menus, and rename and reorganize menu links.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '45',
  'plid' => '8',
  'link_path' => 'admin/config/people',
  'router_path' => 'admin/config/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '46',
  'plid' => '17',
  'link_path' => 'admin/people/permissions',
  'router_path' => 'admin/people/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '48',
  'plid' => '8',
  'link_path' => 'admin/config/regional',
  'router_path' => 'admin/config/regional',
  'link_title' => 'Regional and language',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '49',
  'plid' => '5',
  'link_path' => 'node/%/revisions',
  'router_path' => 'node/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '50',
  'plid' => '8',
  'link_path' => 'admin/config/search',
  'router_path' => 'admin/config/search',
  'link_title' => 'Search and metadata',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Local site search, metadata and SEO.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '51',
  'plid' => '7',
  'link_path' => 'admin/appearance/settings',
  'router_path' => 'admin/appearance/settings',
  'link_title' => 'Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Configure default and theme specific settings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '52',
  'plid' => '18',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-60',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '52',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '53',
  'plid' => '8',
  'link_path' => 'admin/config/system',
  'router_path' => 'admin/config/system',
  'link_title' => 'System',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '56',
  'plid' => '15',
  'link_path' => 'admin/modules/uninstall',
  'router_path' => 'admin/modules/uninstall',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '56',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '57',
  'plid' => '8',
  'link_path' => 'admin/config/user-interface',
  'router_path' => 'admin/config/user-interface',
  'link_title' => 'User interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '58',
  'plid' => '5',
  'link_path' => 'node/%/view',
  'router_path' => 'node/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '58',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '59',
  'plid' => '16',
  'link_path' => 'user/%/view',
  'router_path' => 'user/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '59',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '60',
  'plid' => '8',
  'link_path' => 'admin/config/services',
  'router_path' => 'admin/config/services',
  'link_title' => 'Web services',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '61',
  'plid' => '8',
  'link_path' => 'admin/config/workflow',
  'router_path' => 'admin/config/workflow',
  'link_title' => 'Workflow',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Content workflow, editorial workflow tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '61',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '66',
  'plid' => '45',
  'link_path' => 'admin/config/people/accounts',
  'router_path' => 'admin/config/people/accounts',
  'link_title' => 'Account settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:109:"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '67',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions',
  'router_path' => 'admin/config/system/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '68',
  'plid' => '28',
  'link_path' => 'admin/structure/block/add',
  'router_path' => 'admin/structure/block/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '68',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '69',
  'plid' => '34',
  'link_path' => 'admin/structure/types/add',
  'router_path' => 'admin/structure/types/add',
  'link_title' => 'Add content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '70',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/add',
  'router_path' => 'admin/structure/menu/add',
  'link_title' => 'Add menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '71',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/bartik',
  'router_path' => 'admin/appearance/settings/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '71',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '72',
  'plid' => '50',
  'link_path' => 'admin/config/search/clean-urls',
  'router_path' => 'admin/config/search/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '73',
  'plid' => '53',
  'link_path' => 'admin/config/system/cron',
  'router_path' => 'admin/config/system/cron',
  'link_title' => 'Cron',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '73',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '74',
  'plid' => '48',
  'link_path' => 'admin/config/regional/date-time',
  'router_path' => 'admin/config/regional/date-time',
  'link_title' => 'Date and time',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '76',
  'plid' => '43',
  'link_path' => 'admin/config/media/file-system',
  'router_path' => 'admin/config/media/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '78',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/garland',
  'router_path' => 'admin/appearance/settings/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '79',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/global',
  'router_path' => 'admin/appearance/settings/global',
  'link_title' => 'Global settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '80',
  'plid' => '45',
  'link_path' => 'admin/config/people/ip-blocking',
  'router_path' => 'admin/config/people/ip-blocking',
  'link_title' => 'IP address blocking',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Manage blocked IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '80',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '81',
  'plid' => '43',
  'link_path' => 'admin/config/media/image-toolkit',
  'router_path' => 'admin/config/media/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '81',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '82',
  'plid' => '40',
  'link_path' => 'admin/modules/list/confirm',
  'router_path' => 'admin/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '40',
  'p4' => '82',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '83',
  'plid' => '34',
  'link_path' => 'admin/structure/types/list',
  'router_path' => 'admin/structure/types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '83',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '84',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/list',
  'router_path' => 'admin/structure/menu/list',
  'link_title' => 'List menus',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '84',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '85',
  'plid' => '37',
  'link_path' => 'admin/config/development/logging',
  'router_path' => 'admin/config/development/logging',
  'link_title' => 'Logging and errors',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '85',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '86',
  'plid' => '37',
  'link_path' => 'admin/config/development/maintenance',
  'router_path' => 'admin/config/development/maintenance',
  'link_title' => 'Maintenance mode',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '86',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '89',
  'plid' => '37',
  'link_path' => 'admin/config/development/performance',
  'router_path' => 'admin/config/development/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '89',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '90',
  'plid' => '46',
  'link_path' => 'admin/people/permissions/list',
  'router_path' => 'admin/people/permissions/list',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '90',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '93',
  'plid' => '30',
  'link_path' => 'admin/content/comment/new',
  'router_path' => 'admin/content/comment/new',
  'link_title' => 'Published comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '93',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '94',
  'plid' => '60',
  'link_path' => 'admin/config/services/rss-publishing',
  'router_path' => 'admin/config/services/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '94',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '95',
  'plid' => '48',
  'link_path' => 'admin/config/regional/settings',
  'router_path' => 'admin/config/regional/settings',
  'link_title' => 'Regional settings',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site's default time zone and country.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '95',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '96',
  'plid' => '46',
  'link_path' => 'admin/people/permissions/roles',
  'router_path' => 'admin/people/permissions/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '97',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/settings',
  'router_path' => 'admin/structure/menu/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '97',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '98',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/seven',
  'router_path' => 'admin/appearance/settings/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '98',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '99',
  'plid' => '53',
  'link_path' => 'admin/config/system/site-information',
  'router_path' => 'admin/config/system/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:104:"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '99',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '100',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/stark',
  'router_path' => 'admin/appearance/settings/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '100',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '101',
  'plid' => '33',
  'link_path' => 'admin/config/content/formats',
  'router_path' => 'admin/config/content/formats',
  'link_title' => 'Text formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '102',
  'plid' => '30',
  'link_path' => 'admin/content/comment/approval',
  'router_path' => 'admin/content/comment/approval',
  'link_title' => 'Unapproved comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '103',
  'plid' => '56',
  'link_path' => 'admin/modules/uninstall/confirm',
  'router_path' => 'admin/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '56',
  'p4' => '103',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '104',
  'plid' => '38',
  'link_path' => 'user/%/edit/account',
  'router_path' => 'user/%/edit/account',
  'link_title' => 'Account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '104',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '105',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/%',
  'router_path' => 'admin/config/content/formats/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '105',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '110',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/add',
  'router_path' => 'admin/config/content/formats/add',
  'link_title' => 'Add text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '110',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '111',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/bartik',
  'router_path' => 'admin/structure/block/list/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '111',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '112',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/configure',
  'router_path' => 'admin/config/system/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '112',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '113',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/%',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '114',
  'plid' => '34',
  'link_path' => 'admin/structure/types/manage/%',
  'router_path' => 'admin/structure/types/manage/%',
  'link_title' => 'Edit content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '116',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/formats',
  'router_path' => 'admin/config/regional/date-time/formats',
  'link_title' => 'Formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:51:"Configure display format strings for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '117',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/garland',
  'router_path' => 'admin/structure/block/list/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '117',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '118',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/list',
  'router_path' => 'admin/config/content/formats/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '118',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '119',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/manage',
  'router_path' => 'admin/config/system/actions/manage',
  'link_title' => 'Manage actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '119',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '124',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/settings',
  'router_path' => 'admin/config/people/accounts/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '124',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '125',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/seven',
  'router_path' => 'admin/structure/block/list/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '125',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '126',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/stark',
  'router_path' => 'admin/structure/block/list/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '126',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '127',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/types',
  'router_path' => 'admin/config/regional/date-time/types',
  'link_title' => 'Types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '128',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '128',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '129',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '129',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '130',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '130',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '136',
  'plid' => '117',
  'link_path' => 'admin/structure/block/list/garland/add',
  'router_path' => 'admin/structure/block/list/garland/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '117',
  'p5' => '136',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '141',
  'plid' => '125',
  'link_path' => 'admin/structure/block/list/seven/add',
  'router_path' => 'admin/structure/block/list/seven/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '125',
  'p5' => '141',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '142',
  'plid' => '126',
  'link_path' => 'admin/structure/block/list/stark/add',
  'router_path' => 'admin/structure/block/list/stark/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '126',
  'p5' => '142',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '143',
  'plid' => '127',
  'link_path' => 'admin/config/regional/date-time/types/add',
  'router_path' => 'admin/config/regional/date-time/types/add',
  'link_title' => 'Add date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Add new date type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '143',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '144',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/add',
  'router_path' => 'admin/config/regional/date-time/formats/add',
  'link_title' => 'Add format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '144',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '145',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/add',
  'router_path' => 'admin/structure/menu/manage/%/add',
  'link_title' => 'Add link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '145',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '146',
  'plid' => '28',
  'link_path' => 'admin/structure/block/manage/%/%',
  'router_path' => 'admin/structure/block/manage/%/%',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '29',
  'link_path' => 'user/%/cancel/confirm/%/%',
  'router_path' => 'user/%/cancel/confirm/%/%',
  'link_title' => 'Confirm account cancellation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '29',
  'p3' => '147',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '148',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/delete',
  'router_path' => 'admin/structure/types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '148',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '149',
  'plid' => '80',
  'link_path' => 'admin/config/people/ip-blocking/delete/%',
  'router_path' => 'admin/config/people/ip-blocking/delete/%',
  'link_title' => 'Delete IP address',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '80',
  'p5' => '149',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '150',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/delete/%',
  'router_path' => 'admin/config/system/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '150',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '151',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/delete',
  'router_path' => 'admin/structure/menu/manage/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '151',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '152',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/delete',
  'router_path' => 'admin/structure/menu/item/%/delete',
  'link_title' => 'Delete menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '152',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '153',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/delete/%',
  'router_path' => 'admin/people/permissions/roles/delete/%',
  'link_title' => 'Delete role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '153',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '154',
  'plid' => '105',
  'link_path' => 'admin/config/content/formats/%/disable',
  'router_path' => 'admin/config/content/formats/%/disable',
  'link_title' => 'Disable text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '105',
  'p6' => '154',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '155',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/edit',
  'router_path' => 'admin/structure/types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '155',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '156',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/edit',
  'router_path' => 'admin/structure/menu/manage/%/edit',
  'link_title' => 'Edit menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '156',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '157',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/edit',
  'router_path' => 'admin/structure/menu/item/%/edit',
  'link_title' => 'Edit menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '157',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '158',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/edit/%',
  'router_path' => 'admin/people/permissions/roles/edit/%',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '158',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '159',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/list',
  'router_path' => 'admin/structure/menu/manage/%/list',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '159',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '160',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/reset',
  'router_path' => 'admin/structure/menu/item/%/reset',
  'link_title' => 'Reset menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '160',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '161',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/display',
  'router_path' => 'admin/structure/types/manage/%/comment/display',
  'link_title' => 'Comment display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '162',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/fields',
  'router_path' => 'admin/structure/types/manage/%/comment/fields',
  'link_title' => 'Comment fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '163',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/configure',
  'router_path' => 'admin/structure/block/manage/%/%/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '163',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '164',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/delete',
  'router_path' => 'admin/structure/block/manage/%/%/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '164',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '165',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/%/delete',
  'router_path' => 'admin/config/regional/date-time/formats/%/delete',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '165',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '166',
  'plid' => '127',
  'link_path' => 'admin/config/regional/date-time/types/%/delete',
  'router_path' => 'admin/config/regional/date-time/types/%/delete',
  'link_title' => 'Delete date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to delete a configured date type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '166',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '167',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/%/edit',
  'router_path' => 'admin/config/regional/date-time/formats/%/edit',
  'link_title' => 'Edit date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '167',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '168',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/main-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Main menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '168',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '169',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/management',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Management',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '169',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '170',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/navigation',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Navigation',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '170',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '171',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/user-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'User menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '171',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '176',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '178',
  'plid' => '18',
  'link_path' => 'admin/reports/fields',
  'router_path' => 'admin/reports/fields',
  'link_title' => 'Field list',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '178',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '180',
  'plid' => '20',
  'link_path' => 'admin/structure/taxonomy',
  'router_path' => 'admin/structure/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/edit',
  'router_path' => 'taxonomy/term/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/view',
  'router_path' => 'taxonomy/term/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '211',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '212',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/%',
  'router_path' => 'admin/structure/taxonomy/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '213',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/add',
  'router_path' => 'admin/structure/taxonomy/add',
  'link_title' => 'Add vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '213',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '214',
  'plid' => '43',
  'link_path' => 'admin/config/media/image-styles',
  'router_path' => 'admin/config/media/image-styles',
  'link_title' => 'Image styles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '215',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/list',
  'router_path' => 'admin/structure/taxonomy/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '215',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '218',
  'plid' => '50',
  'link_path' => 'admin/config/search/path',
  'router_path' => 'admin/config/search/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '219',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/add',
  'router_path' => 'admin/config/search/path/add',
  'link_title' => 'Add alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '219',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '221',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/add',
  'router_path' => 'admin/config/media/image-styles/add',
  'link_title' => 'Add style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '221',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '222',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/add',
  'router_path' => 'admin/structure/taxonomy/%/add',
  'link_title' => 'Add term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '222',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '224',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '224',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '226',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/list',
  'router_path' => 'admin/structure/taxonomy/%/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '226',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '227',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/list',
  'router_path' => 'admin/config/search/path/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '227',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '228',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/list',
  'router_path' => 'admin/config/media/image-styles/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '228',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '230',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/delete/%',
  'router_path' => 'admin/config/search/path/delete/%',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '230',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '232',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/edit/%',
  'router_path' => 'admin/config/search/path/edit/%',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '232',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '235',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/edit/%',
  'router_path' => 'admin/config/media/image-styles/edit/%',
  'link_title' => 'Edit style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '237',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/delete/%',
  'router_path' => 'admin/config/media/image-styles/delete/%',
  'link_title' => 'Delete style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '237',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '238',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/revert/%',
  'router_path' => 'admin/config/media/image-styles/revert/%',
  'link_title' => 'Revert style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '238',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '240',
  'plid' => '235',
  'link_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'link_title' => 'Add image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '240',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '241',
  'plid' => '235',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'link_title' => 'Edit image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Edit an existing effect within a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '241',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '242',
  'plid' => '241',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'link_title' => 'Delete image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '241',
  'p7' => '242',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'main-menu',
  'mlid' => '245',
  'plid' => '0',
  'link_path' => '<front>',
  'router_path' => '',
  'link_title' => 'Home',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '245',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '6',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '246',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '6',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Basic page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '247',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '335',
  'plid' => '0',
  'link_path' => 'blog',
  'router_path' => 'blog',
  'link_title' => 'Blogs',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '335',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '337',
  'plid' => '0',
  'link_path' => 'contact',
  'router_path' => 'contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '337',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '339',
  'plid' => '0',
  'link_path' => 'forum',
  'router_path' => 'forum',
  'link_title' => 'Forums',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '339',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '343',
  'plid' => '339',
  'link_path' => 'forum/%',
  'router_path' => 'forum/%',
  'link_title' => 'Forums',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '339',
  'p2' => '343',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '344',
  'plid' => '335',
  'link_path' => 'blog/%',
  'router_path' => 'blog/%',
  'link_title' => 'My blog',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '335',
  'p2' => '344',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '349',
  'plid' => '6',
  'link_path' => 'node/add/blog',
  'router_path' => 'node/add/blog',
  'link_title' => 'Blog entry',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:58:"Use for multi-user blogs. Every user gets a personal blog.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '349',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '350',
  'plid' => '6',
  'link_path' => 'node/add/book',
  'router_path' => 'node/add/book',
  'link_title' => 'Book page',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:87:"<em>Books</em> have a built-in hierarchical navigation. Use for handbooks or tutorials.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '350',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '352',
  'plid' => '16',
  'link_path' => 'user/%/contact',
  'router_path' => 'user/%/contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '352',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '353',
  'plid' => '20',
  'link_path' => 'admin/structure/contact',
  'router_path' => 'admin/structure/contact',
  'link_title' => 'Contact form',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Create a system contact form and set up categories for the form to use.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '355',
  'plid' => '6',
  'link_path' => 'node/add/forum',
  'router_path' => 'node/add/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:69:"A <em>forum topic</em> starts a new discussion thread within a forum.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '355',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '356',
  'plid' => '20',
  'link_path' => 'admin/structure/forum',
  'router_path' => 'admin/structure/forum',
  'link_title' => 'Forums',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Control forum hierarchy settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '359',
  'plid' => '18',
  'link_path' => 'admin/reports/hits',
  'router_path' => 'admin/reports/hits',
  'link_title' => 'Recent hits',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View pages that have recently been visited.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '359',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '360',
  'plid' => '18',
  'link_path' => 'admin/reports/pages',
  'router_path' => 'admin/reports/pages',
  'link_title' => 'Top pages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"View pages that have been hit frequently.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '360',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '361',
  'plid' => '18',
  'link_path' => 'admin/reports/referrers',
  'router_path' => 'admin/reports/referrers',
  'link_title' => 'Top referrers',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"View top referrers.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '361',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '362',
  'plid' => '18',
  'link_path' => 'admin/reports/visitors',
  'router_path' => 'admin/reports/visitors',
  'link_title' => 'Top visitors',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View visitors that hit many pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '362',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '363',
  'plid' => '5',
  'link_path' => 'node/%/track',
  'router_path' => 'node/%/track',
  'link_title' => 'Track',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '363',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '365',
  'plid' => '5',
  'link_path' => 'node/%/translate',
  'router_path' => 'node/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '365',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '389',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/add',
  'router_path' => 'admin/structure/contact/add',
  'link_title' => 'Add category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '389',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '391',
  'plid' => '18',
  'link_path' => 'admin/reports/access/%',
  'router_path' => 'admin/reports/access/%',
  'link_title' => 'Details',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:16:"View access log.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '391',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '395',
  'plid' => '48',
  'link_path' => 'admin/config/regional/language',
  'router_path' => 'admin/config/regional/language',
  'link_title' => 'Languages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Configure languages for content and the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '398',
  'plid' => '356',
  'link_path' => 'admin/structure/forum/list',
  'router_path' => 'admin/structure/forum/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '398',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '402',
  'plid' => '53',
  'link_path' => 'admin/config/system/statistics',
  'router_path' => 'admin/config/system/statistics',
  'link_title' => 'Statistics',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Control details about what and how your site logs access statistics.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '402',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '412',
  'plid' => '16',
  'link_path' => 'user/%/track/navigation',
  'router_path' => 'user/%/track/navigation',
  'link_title' => 'Track page visits',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '412',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '413',
  'plid' => '48',
  'link_path' => 'admin/config/regional/translate',
  'router_path' => 'admin/config/regional/translate',
  'link_title' => 'Translate interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"Translate the built in interface and optionally other text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '417',
  'plid' => '356',
  'link_path' => 'admin/structure/forum/settings',
  'router_path' => 'admin/structure/forum/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '417',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '418',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/add',
  'router_path' => 'admin/config/regional/language/add',
  'link_title' => 'Add language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '418',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '421',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/delete/%',
  'router_path' => 'admin/structure/contact/delete/%',
  'link_title' => 'Delete contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '421',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '422',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/configure',
  'router_path' => 'admin/config/regional/language/configure',
  'link_title' => 'Detection and selection',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '422',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '423',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/edit/%',
  'router_path' => 'admin/structure/contact/edit/%',
  'link_title' => 'Edit contact category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '423',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '424',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/export',
  'router_path' => 'admin/config/regional/translate/export',
  'link_title' => 'Export',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '30',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '424',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '425',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/import',
  'router_path' => 'admin/config/regional/translate/import',
  'link_title' => 'Import',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '425',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '427',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/overview',
  'router_path' => 'admin/config/regional/language/overview',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '427',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '429',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/locale',
  'router_path' => 'admin/config/regional/date-time/locale',
  'link_title' => 'Localize',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Configure date formats for each locale";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '429',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '430',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/overview',
  'router_path' => 'admin/config/regional/translate/overview',
  'link_title' => 'Overview',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '430',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '433',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/translate',
  'router_path' => 'admin/config/regional/translate/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '433',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '435',
  'plid' => '356',
  'link_path' => 'admin/structure/forum/add/container',
  'router_path' => 'admin/structure/forum/add/container',
  'link_title' => 'Add container',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '435',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '436',
  'plid' => '356',
  'link_path' => 'admin/structure/forum/add/forum',
  'router_path' => 'admin/structure/forum/add/forum',
  'link_title' => 'Add forum',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '436',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '440',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/delete/%',
  'router_path' => 'admin/config/regional/language/delete/%',
  'link_title' => 'Confirm',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '440',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '441',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/delete/%',
  'router_path' => 'admin/config/regional/translate/delete/%',
  'link_title' => 'Delete string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '441',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '442',
  'plid' => '356',
  'link_path' => 'admin/structure/forum/edit/container/%',
  'router_path' => 'admin/structure/forum/edit/container/%',
  'link_title' => 'Edit container',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '442',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '443',
  'plid' => '356',
  'link_path' => 'admin/structure/forum/edit/forum/%',
  'router_path' => 'admin/structure/forum/edit/forum/%',
  'link_title' => 'Edit forum',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '356',
  'p4' => '443',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '444',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/edit/%',
  'router_path' => 'admin/config/regional/language/edit/%',
  'link_title' => 'Edit language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '444',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '445',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/edit/%',
  'router_path' => 'admin/config/regional/translate/edit/%',
  'link_title' => 'Edit string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '445',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '449',
  'plid' => '422',
  'link_path' => 'admin/config/regional/language/configure/session',
  'router_path' => 'admin/config/regional/language/configure/session',
  'link_title' => 'Session language detection configuration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '422',
  'p6' => '449',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '451',
  'plid' => '422',
  'link_path' => 'admin/config/regional/language/configure/url',
  'router_path' => 'admin/config/regional/language/configure/url',
  'link_title' => 'URL language detection configuration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '422',
  'p6' => '451',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '461',
  'plid' => '429',
  'link_path' => 'admin/config/regional/date-time/locale/%/edit',
  'router_path' => 'admin/config/regional/date-time/locale/%/edit',
  'link_title' => 'Localize date formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Configure date formats for each locale";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '429',
  'p6' => '461',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '463',
  'plid' => '429',
  'link_path' => 'admin/config/regional/date-time/locale/%/reset',
  'router_path' => 'admin/config/regional/date-time/locale/%/reset',
  'link_title' => 'Reset date formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Reset localized date formats to global defaults";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '429',
  'p6' => '463',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '465',
  'plid' => '6',
  'link_path' => 'node/add/test-content-type',
  'router_path' => 'node/add/test-content-type',
  'link_title' => 'Test content type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:49:"This is the description of the test content type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '465',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '474',
  'plid' => '4',
  'link_path' => 'filter/tips/%',
  'router_path' => 'filter/tips/%',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '474',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '491',
  'plid' => '48',
  'link_path' => 'admin/config/regional/entity_translation',
  'router_path' => 'admin/config/regional/entity_translation',
  'link_title' => 'Entity translation',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:83:"Configure which entities can be translated and enable or disable language fallback.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '491',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '702',
  'plid' => '6',
  'link_path' => 'node/add/et',
  'router_path' => 'node/add/et',
  'link_title' => 'Entity translation test',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:23:"Entity translation test";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '702',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '703',
  'plid' => '6',
  'link_path' => 'node/add/a-thirty-two-character-type-name',
  'router_path' => 'node/add/a-thirty-two-character-type-name',
  'link_title' => 'Test long name',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '703',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '704',
  'plid' => '3',
  'link_path' => 'comment/%/translate',
  'router_path' => 'comment/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '704',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '705',
  'plid' => '16',
  'link_path' => 'user/%/translate',
  'router_path' => 'user/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '705',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '714',
  'plid' => '25',
  'link_path' => 'comment/%/edit/%',
  'router_path' => 'comment/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '714',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '715',
  'plid' => '38',
  'link_path' => 'user/%/edit/%',
  'router_path' => 'user/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '715',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '716',
  'plid' => '48',
  'link_path' => 'admin/config/regional/i18n',
  'router_path' => 'admin/config/regional/i18n',
  'link_title' => 'Multilingual settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:69:"Configure extended options for multilingual content and translations.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '716',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '718',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/translate',
  'router_path' => 'taxonomy/term/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '11',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '718',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '720',
  'plid' => '39',
  'link_path' => 'node/%/edit/%',
  'router_path' => 'node/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '720',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '721',
  'plid' => '704',
  'link_path' => 'comment/%/translate/delete/%',
  'router_path' => 'comment/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '3',
  'p2' => '704',
  'p3' => '721',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '722',
  'plid' => '365',
  'link_path' => 'node/%/translate/delete/%',
  'router_path' => 'node/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '365',
  'p3' => '722',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '723',
  'plid' => '705',
  'link_path' => 'user/%/translate/delete/%',
  'router_path' => 'user/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '705',
  'p3' => '723',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '724',
  'plid' => '210',
  'link_path' => 'taxonomy/term/%/edit/%',
  'router_path' => 'taxonomy/term/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '724',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '725',
  'plid' => '716',
  'link_path' => 'admin/config/regional/i18n/configure',
  'router_path' => 'admin/config/regional/i18n/configure',
  'link_title' => 'Multilingual system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:69:"Configure extended options for multilingual content and translations.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '716',
  'p5' => '725',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '732',
  'plid' => '25',
  'link_path' => 'comment/%/edit/add/%/%',
  'router_path' => 'comment/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '732',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '733',
  'plid' => '38',
  'link_path' => 'user/%/edit/add/%/%',
  'router_path' => 'user/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '733',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '735',
  'plid' => '491',
  'link_path' => 'admin/config/regional/entity_translation/translatable/%',
  'router_path' => 'admin/config/regional/entity_translation/translatable/%',
  'link_title' => 'Confirm change in translatability.',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Confirmation page for changing field translatability.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '491',
  'p5' => '735',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '736',
  'plid' => '718',
  'link_path' => 'taxonomy/term/%/translate/delete/%',
  'router_path' => 'taxonomy/term/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '176',
  'p2' => '718',
  'p3' => '736',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '737',
  'plid' => '39',
  'link_path' => 'node/%/edit/add/%/%',
  'router_path' => 'node/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '737',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '742',
  'plid' => '210',
  'link_path' => 'taxonomy/term/%/edit/add/%/%',
  'router_path' => 'taxonomy/term/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '742',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '923',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/display',
  'router_path' => 'admin/structure/taxonomy/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '923',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '924',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/display',
  'router_path' => 'admin/config/people/accounts/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '924',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '925',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/fields',
  'router_path' => 'admin/structure/taxonomy/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '926',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/fields',
  'router_path' => 'admin/config/people/accounts/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '927',
  'plid' => '923',
  'link_path' => 'admin/structure/taxonomy/%/display/default',
  'router_path' => 'admin/structure/taxonomy/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '923',
  'p6' => '927',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '928',
  'plid' => '924',
  'link_path' => 'admin/config/people/accounts/display/default',
  'router_path' => 'admin/config/people/accounts/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '924',
  'p6' => '928',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '929',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/display',
  'router_path' => 'admin/structure/types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '930',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/fields',
  'router_path' => 'admin/structure/types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '931',
  'plid' => '923',
  'link_path' => 'admin/structure/taxonomy/%/display/full',
  'router_path' => 'admin/structure/taxonomy/%/display/full',
  'link_title' => 'Taxonomy term page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '923',
  'p6' => '931',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '932',
  'plid' => '924',
  'link_path' => 'admin/config/people/accounts/display/full',
  'router_path' => 'admin/config/people/accounts/display/full',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '924',
  'p6' => '932',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '933',
  'plid' => '925',
  'link_path' => 'admin/structure/taxonomy/%/fields/%',
  'router_path' => 'admin/structure/taxonomy/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '934',
  'plid' => '926',
  'link_path' => 'admin/config/people/accounts/fields/%',
  'router_path' => 'admin/config/people/accounts/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '935',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/default',
  'router_path' => 'admin/structure/types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '935',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '936',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/full',
  'router_path' => 'admin/structure/types/manage/%/display/full',
  'link_title' => 'Full content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '936',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '938',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/rss',
  'router_path' => 'admin/structure/types/manage/%/display/rss',
  'link_title' => 'RSS',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '938',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '941',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/teaser',
  'router_path' => 'admin/structure/types/manage/%/display/teaser',
  'link_title' => 'Teaser',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '941',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '942',
  'plid' => '930',
  'link_path' => 'admin/structure/types/manage/%/fields/%',
  'router_path' => 'admin/structure/types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '943',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '943',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '944',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '944',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '945',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '945',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '947',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '947',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '948',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/delete',
  'router_path' => 'admin/config/people/accounts/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '948',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '949',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/edit',
  'router_path' => 'admin/config/people/accounts/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '949',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '950',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'router_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '950',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '952',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'router_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '952',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '953',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/comment/display/default',
  'router_path' => 'admin/structure/types/manage/%/comment/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '953',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '954',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/comment/display/full',
  'router_path' => 'admin/structure/types/manage/%/comment/display/full',
  'link_title' => 'Full comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '954',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '955',
  'plid' => '162',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '956',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '956',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '957',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '957',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '958',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '958',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '960',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '960',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '961',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '961',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '962',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '962',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '963',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '963',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '965',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '965',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();
$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'delivery_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'context' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'include_file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'delivery_callback',
  'fit',
  'number_parts',
  'context',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'theme_callback',
  'theme_arguments',
  'type',
  'description',
  'position',
  'weight',
  'include_file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance',
  'title' => 'Appearance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Select and configure your themes.',
  'position' => 'left',
  'weight' => '-6',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/default',
  'title' => 'Set default theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/disable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_disable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/disable',
  'title' => 'Disable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/enable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_enable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/enable',
  'title' => 'Enable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Select and configure your theme',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure default and theme specific settings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_config_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config',
  'title' => 'Configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content',
  'title' => 'Content authoring',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings related to formatting and authoring content.',
  'position' => 'left',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Text formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%/disable',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_filter_disable_format_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%/disable',
  'title' => 'Disable text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Add text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/development',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development',
  'title' => 'Development',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Development tools.',
  'position' => 'right',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"system_logging_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/logging',
  'title' => 'Logging and errors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.",
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"system_site_maintenance_mode";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/maintenance',
  'title' => 'Maintenance mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Take the site offline for maintenance or bring it back online.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media',
  'title' => 'Media',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Media tools.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Image styles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure styles that can be used for resizing or adjusting images on display.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"image_style_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Add style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add a new image style.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/delete/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"1";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/delete/%',
  'title' => 'Delete style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%',
  'load_functions' => 'a:1:{i:5;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%',
  'title' => 'Edit style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/add/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/add/%',
  'title' => 'Add image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add a new effect to a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%',
  'title' => 'Edit image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Edit an existing effect within a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'title' => 'Delete image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an existing effect from a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'List the current image styles on the site.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/revert/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"2";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/revert/%',
  'title' => 'Revert style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Revert an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure user accounts.',
  'position' => 'left',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Account settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/full',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/delete',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/field-settings',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/widget-type',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'system_ip_blocking',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking',
  'title' => 'IP address blocking',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage blocked IP addresses.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking/delete/%',
  'load_functions' => 'a:1:{i:5;s:15:"blocked_ip_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"system_ip_blocking_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking/delete/%',
  'title' => 'Delete IP address',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional',
  'title' => 'Regional and language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Regional settings, localization and translation.',
  'position' => 'left',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_formats',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure display format strings for date and time.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/delete',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/edit',
  'title' => 'Edit date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to edit a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"system_configure_date_formats_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/formats',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/locale',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'locale_date_format_language_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Localize',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure date formats for each locale',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/locale/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"locale_date_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/locale/%/edit',
  'title' => 'Localize date formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure date formats for each locale',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/locale/%/reset',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"locale_date_format_reset_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/locale/%/reset',
  'title' => 'Reset date formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Reset localized date formats to global defaults',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"system_delete_date_format_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/types/%/delete',
  'title' => 'Delete date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_add_date_format_type_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/types',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add new date type.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/entity_translation',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer entity translation";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"entity_translation_admin_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/entity_translation',
  'title' => 'Entity translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure which entities can be translated and enable or disable language fallback.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/entity_translation/translatable/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:28:"toggle field translatability";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:36:"entity_translation_translatable_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/entity_translation/translatable/%',
  'title' => 'Confirm change in translatability.',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Confirmation page for changing field translatability.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/i18n',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"variable_module_form";i:1;s:4:"i18n";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/i18n',
  'title' => 'Multilingual settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure extended options for multilingual content and translations.',
  'position' => '',
  'weight' => '10',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/config/regional/i18n/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"variable_module_form";i:1;s:4:"i18n";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/i18n',
  'tab_root' => 'admin/config/regional/i18n',
  'title' => 'Multilingual system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure extended options for multilingual content and translations.',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/config/regional/language',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_languages_overview_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'Languages',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure languages for content and the user interface.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_languages_add_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/language',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'Add language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:31:"locale_languages_configure_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/language',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'Detection and selection',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/configure/session',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:38:"locale_language_providers_session_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/configure/session',
  'title' => 'Session language detection configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/configure/url',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"locale_language_providers_url_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/configure/url',
  'title' => 'URL language detection configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/delete/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"locale_languages_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/delete/%',
  'title' => 'Confirm',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/edit/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"locale_languages_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/edit/%',
  'title' => 'Edit language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/language/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_languages_overview_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/language',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_regional_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/settings',
  'title' => 'Regional settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for the site's default time zone and country.",
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_overview_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Translate interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Translate the built in interface and optionally other text.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate/delete/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_delete_page',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/translate/delete/%',
  'title' => 'Delete string',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate/edit/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"locale_translate_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/translate/edit/%',
  'title' => 'Edit string',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate/export',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_export_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Export',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '30',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate/import',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"locale_translate_import_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Import',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_overview_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/translate/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_seek_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/locale/locale.admin.inc',
))
->values(array(
  'path' => 'admin/config/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search',
  'title' => 'Search and metadata',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Local site search, metadata and SEO.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json_output',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/delete/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"path_admin_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/delete/%',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/edit/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/edit/%',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/services',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services',
  'title' => 'Web services',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools related to web services.',
  'position' => 'right',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system',
  'title' => 'System',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'General system related configuration.',
  'position' => 'right',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/delete/%',
  'load_functions' => 'a:1:{i:5;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/system/actions',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"system_cron_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/cron',
  'title' => 'Cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage automatic site maintenance tasks.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/statistics',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer statistics";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"statistics_settings_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/statistics',
  'title' => 'Statistics',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Control details about what and how your site logs access statistics.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface',
  'title' => 'User interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools that enhance the user interface.',
  'position' => 'right',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/workflow',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/workflow',
  'title' => 'Workflow',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Content workflow, editorial workflow tools.',
  'position' => 'right',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer content and comments.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '134',
  'description' => 'List and edit site comments and the comment approval queue.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Unapproved comments',
  'title_callback' => 'comment_count_unpublished',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/index',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_index',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-18',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Extend site functionality.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage user accounts, roles, and permissions.',
  'position' => 'left',
  'weight' => '-4',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Find and manage people interacting with your site.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"user_admin_roles";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/delete/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/delete/%',
  'title' => 'Delete role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/edit/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/edit/%',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View reports, updates, and errors.',
  'position' => 'left',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/access/%',
  'load_functions' => 'a:1:{i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_access_log',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/access/%',
  'title' => 'Details',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View access log.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'field_ui_fields_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/fields',
  'title' => 'Field list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Overview of fields on all entity types.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/reports/hits',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_recent_hits',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/hits',
  'title' => 'Recent hits',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View pages that have recently been visited.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/pages',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_pages',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/pages',
  'title' => 'Top pages',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View pages that have been hit frequently.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/referrers',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_referrers',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/referrers',
  'title' => 'Top referrers',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View top referrers.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '-60',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/visitors',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_visitors',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/visitors',
  'title' => 'Top visitors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View visitors that hit many pages.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/structure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure',
  'title' => 'Structure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer blocks, content types, menus, etc.',
  'position' => 'right',
  'weight' => '-8',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/bartik',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/garland',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/seven',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/stark',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/garland',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:15:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/seven',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/stark',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/configure',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '2',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/delete',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"block_custom_block_delete";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'contact_category_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact',
  'title' => 'Contact form',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Create a system contact form and set up categories for the form to use.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"contact_category_edit_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/contact',
  'tab_root' => 'admin/structure/contact',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"contact_category_delete_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact/delete/%',
  'title' => 'Delete contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact/edit/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"contact_category_edit_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact/edit/%',
  'title' => 'Edit contact category',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Control forum hierarchy settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum/add/container',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:9:"container";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/forum',
  'tab_root' => 'admin/structure/forum',
  'title' => 'Add container',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:5:"forum";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/forum',
  'tab_root' => 'admin/structure/forum',
  'title' => 'Add forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum/edit/container/%',
  'load_functions' => 'a:1:{i:5;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:9:"container";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/forum/edit/container/%',
  'title' => 'Edit container',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum/edit/forum/%',
  'load_functions' => 'a:1:{i:5;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:5:"forum";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/forum/edit/forum/%',
  'title' => 'Edit forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/forum',
  'tab_root' => 'admin/structure/forum',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/forum/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"forum_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/forum',
  'tab_root' => 'admin/structure/forum',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add new menus to your site, edit existing menus, and rename and reorganize menu links.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/delete',
  'title' => 'Delete menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/edit',
  'title' => 'Edit menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/reset',
  'title' => 'Reset menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/add',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Add link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/list',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/parents',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_parent_options_js',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/parents',
  'title' => 'Parent menu items',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/structure/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => '',
  'title_callback' => 'entity_label',
  'title_arguments' => 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/add',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;a:0:{}i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/display',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/display/default',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/display',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/display/full',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/display',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Taxonomy term page',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/edit',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"taxonomy_form_vocabulary";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '58',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage content types, including default status, front page promotion, comment settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit content type',
  'title_callback' => 'node_type_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display/default',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display/full',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:7:"comment";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '246',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:7;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/full',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/rss',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/teaser',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Teaser',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/tasks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Tasks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_system_batch_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'blog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'blog_page_last',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'blog',
  'title' => 'Blogs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/blog/blog.pages.inc',
))
->values(array(
  'path' => 'blog/%',
  'load_functions' => 'a:1:{i:1;s:22:"user_uid_optional_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:24:"user_uid_optional_to_arg";}',
  'access_callback' => 'blog_page_user_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'blog_page_user',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'blog/%',
  'title' => 'My blog',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/blog/blog.pages.inc',
))
->values(array(
  'path' => 'blog/%/feed',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'blog_page_user_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'blog_feed_user',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'blog/%/feed',
  'title' => 'Blogs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/blog/blog.pages.inc',
))
->values(array(
  'path' => 'blog/feed',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'blog_feed_last',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'blog/feed',
  'title' => 'Blogs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/blog/blog.pages.inc',
))
->values(array(
  'path' => 'comment/%',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%',
  'title' => 'Comment permalink',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/approve',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_approve',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%/approve',
  'title' => 'Approve',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'comment/%/delete',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_confirm_delete_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'comment/%/edit',
  'load_functions' => 'a:1:{i:1;s:12:"comment_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;s:4:"edit";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:7:"comment";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/edit/%',
  'load_functions' => 'a:2:{i:1;s:12:"comment_load";i:3;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;s:4:"edit";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:7:"comment";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'comment/%/edit',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:1;s:12:"comment_load";i:4;s:32:"entity_translation_language_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:7:{i:0;s:7:"comment";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:5;s:4:"edit";i:6;i:1;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'comment/%/edit',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/translate',
  'load_functions' => 'a:1:{i:1;s:12:"comment_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'comment/%/translate/delete/%',
  'load_functions' => 'a:2:{i:1;s:12:"comment_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:7:"comment";i:2;i:1;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'comment/%/view',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'View comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Add new comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"access site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:17:"contact_site_form";}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'contact',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.pages.inc',
))
->values(array(
  'path' => 'entity_translation/taxonomy_term/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'entity_translation_taxonomy_term_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'entity_translation/taxonomy_term/autocomplete',
  'title' => 'Entity translation autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_upload',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/ajax',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_progress',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'filter/tips/%',
  'load_functions' => 'a:1:{i:2;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'filter_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips/%',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'forum_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.pages.inc',
))
->values(array(
  'path' => 'forum/%',
  'load_functions' => 'a:1:{i:1;s:16:"forum_forum_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'forum_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'forum/%',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/forum/forum.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '2',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:1;i:2;b:0;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;s:6:"update";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:1;i:2;b:0;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit/%',
  'load_functions' => 'a:2:{i:1;s:9:"node_load";i:3;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:1;i:2;i:3;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;s:6:"update";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:1;i:2;i:3;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '3',
  'tab_parent' => 'node/%/edit',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"node_load";i:4;s:32:"entity_translation_language_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:7:{i:0;s:4:"node";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:5;s:6:"update";i:6;i:1;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'node/%/edit',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/track',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_node_tracker',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Track',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/statistics/statistics.pages.inc',
))
->values(array(
  'path' => 'node/%/translate',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_node_tab_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;s:23:"_translation_tab_access";i:2;i:1;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:4:{i:0;s:4:"node";i:1;i:1;i:2;a:3:{s:13:"page callback";s:25:"translation_node_overview";s:4:"file";s:21:"translation.pages.inc";s:6:"module";s:11:"translation";}i:3;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'node/%/translate/delete/%',
  'load_functions' => 'a:2:{i:1;s:9:"node_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_node_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:4:"node";i:2;i:1;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Add content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/a-thirty-two-character-type-name',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:32:"a_thirty_two_character_type_name";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:32:"a_thirty_two_character_type_name";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/a-thirty-two-character-type-name',
  'title' => 'Test long name',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:7:"article";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/blog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"blog";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"blog";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/blog',
  'title' => 'Blog entry',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Use for multi-user blogs. Every user gets a personal blog.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/book',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"book";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"book";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/book',
  'title' => 'Book page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '<em>Books</em> have a built-in hierarchical navigation. Use for handbooks or tutorials.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/et',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:2:"et";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:2:"et";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/et',
  'title' => 'Entity translation test',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Entity translation test',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"forum";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:5:"forum";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/forum',
  'title' => 'Forum topic',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'A <em>forum topic</em> starts a new discussion thread within a forum.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"page";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Basic page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/test-content-type',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:17:"test_content_type";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:17:"test_content_type";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-content-type',
  'title' => 'Test content type',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'This is the description of the test content type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:2:{i:0;b:0;i:1;a:0:{}}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'sites/default/files/styles/%',
  'load_functions' => 'a:1:{i:4;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'sites/default/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'ajax_form_callback',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/ajax',
  'title' => 'AHAH callback',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'includes/form.inc',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:7:"private";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/files/styles/%',
  'load_functions' => 'a:1:{i:3;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/temporary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:9:"temporary";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/temporary',
  'title' => 'Temporary files',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_timezone',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/timezone',
  'title' => 'Time zone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/edit',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;b:0;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;i:2;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:7:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;b:0;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;s:18:"taxonomy_form_term";i:5;i:2;i:6;N;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/edit/%',
  'load_functions' => 'a:2:{i:2;s:18:"taxonomy_term_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:4;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;i:2;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:7:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:4;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;s:18:"taxonomy_form_term";i:5;i:2;i:6;N;}',
  'delivery_callback' => '',
  'fit' => '26',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%/edit',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:2;s:18:"taxonomy_term_load";i:5;s:32:"entity_translation_language_load";i:6;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:5;i:3;i:6;i:4;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:5;i:2;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:8:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:5;i:3;i:6;i:4;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:5;s:18:"taxonomy_form_term";i:6;i:2;i:7;N;}',
  'delivery_callback' => '',
  'fit' => '108',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%/edit',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/feed',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_feed',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/feed',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/translate',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_taxonomy_term_tab_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:2:{i:0;s:13:"taxonomy_term";i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '3',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '11',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/translate/delete/%',
  'load_functions' => 'a:2:{i:2;s:18:"taxonomy_term_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_taxonomy_term_tab_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:13:"taxonomy_term";i:2;i:2;i:3;i:5;}',
  'delivery_callback' => '',
  'fit' => '54',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/view',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 'user_menu_title',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/%/cancel',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel',
  'title' => 'Cancel account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/cancel/confirm/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_cancel_confirm',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel/confirm/%/%',
  'title' => 'Confirm account cancellation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/contact',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_contact_personal_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"contact_personal_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/contact/contact.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;s:17:"user_profile_form";i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/%',
  'load_functions' => 'a:2:{i:1;s:9:"user_load";i:3;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;s:17:"user_profile_form";i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;s:17:"user_profile_form";i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;s:32:"entity_translation_language_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:5;i:1;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:7:{i:0;s:4:"user";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:5;s:17:"user_profile_form";i:6;i:1;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/track/navigation',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_user_tracker',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Track page visits',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/statistics/statistics.pages.inc',
))
->values(array(
  'path' => 'user/%/translate',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'user/%/translate/delete/%',
  'load_functions' => 'a:2:{i:1;s:9:"user_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:4:"user";i:2;i:1;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"user_register_form";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '24',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->execute();
$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tnid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node')
->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'type' => 'test_content_type',
  'language' => 'en',
  'title' => 'An English Node',
  'uid' => '0',
  'status' => '1',
  'created' => '1421727515',
  'changed' => '1676090892',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '11',
  'type' => 'article',
  'language' => 'en',
  'title' => 'The thing about Deep Space 9',
  'uid' => '0',
  'status' => '1',
  'created' => '1441306772',
  'changed' => '1676090892',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '2',
  'translate' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '12',
  'type' => 'article',
  'language' => 'is',
  'title' => 'is - The thing about Deep Space 9',
  'uid' => '1',
  'status' => '1',
  'created' => '1471428152',
  'changed' => '1676090892',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '2',
  'translate' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '13',
  'type' => 'article',
  'language' => 'is',
  'title' => 'is - The thing about Firefly',
  'uid' => '1',
  'status' => '1',
  'created' => '1478755274',
  'changed' => '1564543810',
  'comment' => '1',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '4',
  'translate' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '14',
  'type' => 'article',
  'language' => 'en',
  'title' => 'en - The thing about Firefly',
  'uid' => '1',
  'status' => '1',
  'created' => '1478755314',
  'changed' => '1564543929',
  'comment' => '1',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '4',
  'translate' => '0',
))
->values(array(
  'nid' => '6',
  'vid' => '6',
  'type' => 'forum',
  'language' => 'en',
  'title' => 'Comments are closed :-(',
  'uid' => '1',
  'status' => '1',
  'created' => '1504715414',
  'changed' => '1504715414',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '7',
  'vid' => '7',
  'type' => 'forum',
  'language' => 'en',
  'title' => 'Comments are open :-)',
  'uid' => '1',
  'status' => '1',
  'created' => '1504715432',
  'changed' => '1504715432',
  'comment' => '2',
  'promote' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '8',
  'vid' => '8',
  'type' => 'blog',
  'language' => 'en',
  'title' => 'The number 47',
  'uid' => '1',
  'status' => '1',
  'created' => '1551000341',
  'changed' => '1552126247',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '8',
  'translate' => '0',
))
->values(array(
  'nid' => '9',
  'vid' => '9',
  'type' => 'blog',
  'language' => 'fr',
  'title' => 'fr - The number 47',
  'uid' => '1',
  'status' => '1',
  'created' => '1552126296',
  'changed' => '1552126296',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '8',
  'translate' => '0',
))
->values(array(
  'nid' => '10',
  'vid' => '10',
  'type' => 'blog',
  'language' => 'is',
  'title' => 'is - The number 47',
  'uid' => '1',
  'status' => '1',
  'created' => '1552126363',
  'changed' => '1552126363',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '8',
  'translate' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '18',
  'type' => 'et',
  'language' => 'en',
  'title' => 'Page one',
  'uid' => '1',
  'status' => '1',
  'created' => '1568261523',
  'changed' => '1568261721',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();
$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();
$connection->schema()->createTable('node_comment_statistics', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_comment_statistics')
->fields(array(
  'nid',
  'cid',
  'last_comment_timestamp',
  'last_comment_name',
  'last_comment_uid',
  'comment_count',
))
->values(array(
  'nid' => '1',
  'cid' => '4',
  'last_comment_timestamp' => '1426781880',
  'last_comment_name' => 'Bob',
  'last_comment_uid' => '0',
  'comment_count' => '2',
))
->values(array(
  'nid' => '3',
  'cid' => '3',
  'last_comment_timestamp' => '1533031490',
  'last_comment_name' => '',
  'last_comment_uid' => '1',
  'comment_count' => '1',
))
->values(array(
  'nid' => '4',
  'cid' => '0',
  'last_comment_timestamp' => '1478755274',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '5',
  'cid' => '0',
  'last_comment_timestamp' => '1478755314',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '6',
  'cid' => '0',
  'last_comment_timestamp' => '1504715414',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '7',
  'cid' => '0',
  'last_comment_timestamp' => '1504715432',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '9',
  'cid' => '0',
  'last_comment_timestamp' => '1552126296',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '10',
  'cid' => '0',
  'last_comment_timestamp' => '1552126363',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->execute();
$connection->schema()->createTable('node_counter', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'totalcount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'daycount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_counter')
->fields(array(
  'nid',
  'totalcount',
  'daycount',
  'timestamp',
))
->values(array(
  'nid' => '1',
  'totalcount' => '2',
  'daycount' => '0',
  'timestamp' => '1421727536',
))
->values(array(
  'nid' => '2',
  'totalcount' => '1',
  'daycount' => '0',
  'timestamp' => '1471428059',
))
->values(array(
  'nid' => '3',
  'totalcount' => '1',
  'daycount' => '0',
  'timestamp' => '1471428153',
))
->values(array(
  'nid' => '4',
  'totalcount' => '1',
  'daycount' => '0',
  'timestamp' => '1478755275',
))
->values(array(
  'nid' => '5',
  'totalcount' => '1',
  'daycount' => '0',
  'timestamp' => '1478755314',
))
->values(array(
  'nid' => '6',
  'totalcount' => '2',
  'daycount' => '0',
  'timestamp' => '1504715439',
))
->values(array(
  'nid' => '7',
  'totalcount' => '2',
  'daycount' => '0',
  'timestamp' => '1504715438',
))
->execute();
$connection->schema()->createTable('node_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_revision')
->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'log',
  'timestamp',
  'status',
  'comment',
  'promote',
  'sticky',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'title' => 'An English Node',
  'log' => '',
  'timestamp' => '1676090892',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '2',
  'uid' => '1',
  'title' => 'The thing about Deep Space 9 (1st rev)',
  'log' => 'DS9 1st rev',
  'timestamp' => '1564543588',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '3',
  'uid' => '1',
  'title' => 'is - The thing about Deep Space 9 (1st rev)',
  'log' => 'is - DS9 1st rev',
  'timestamp' => '1564543677',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '4',
  'uid' => '1',
  'title' => 'is - The thing about Firefly (1st rev)',
  'log' => 'is - Firefly 1st rev',
  'timestamp' => '1478755274',
  'status' => '1',
  'comment' => '1',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '5',
  'uid' => '1',
  'title' => 'en - The thing about Firefly (1st rev)',
  'log' => 'Firefly 1st rev',
  'timestamp' => '1564543887',
  'status' => '1',
  'comment' => '1',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '6',
  'vid' => '6',
  'uid' => '1',
  'title' => 'Comments are closed :-(',
  'log' => '',
  'timestamp' => '1504715414',
  'status' => '1',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '7',
  'vid' => '7',
  'uid' => '1',
  'title' => 'Comments are open :-)',
  'log' => '',
  'timestamp' => '1504715432',
  'status' => '1',
  'comment' => '2',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '8',
  'vid' => '8',
  'uid' => '1',
  'title' => 'The number 47',
  'log' => '',
  'timestamp' => '1552126247',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '9',
  'vid' => '9',
  'uid' => '1',
  'title' => 'fr - The number 47',
  'log' => '',
  'timestamp' => '1552126296',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '10',
  'vid' => '10',
  'uid' => '1',
  'title' => 'is - The number 47',
  'log' => '',
  'timestamp' => '1552126363',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '11',
  'uid' => '1',
  'title' => 'The thing about Deep Space 9',
  'log' => 'DS9 2nd rev',
  'timestamp' => '1676090892',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '3',
  'vid' => '12',
  'uid' => '1',
  'title' => 'is - The thing about Deep Space 9',
  'log' => 'is - DS9 2nd rev',
  'timestamp' => '1676090892',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '4',
  'vid' => '13',
  'uid' => '1',
  'title' => 'is - The thing about Firefly',
  'log' => 'is - Firefly 2nd rev',
  'timestamp' => '1564543810',
  'status' => '1',
  'comment' => '1',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '5',
  'vid' => '14',
  'uid' => '1',
  'title' => 'en - The thing about Firefly',
  'log' => 'Firefly 2nd rev',
  'timestamp' => '1564543929',
  'status' => '1',
  'comment' => '1',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '15',
  'uid' => '1',
  'title' => 'Page one',
  'log' => '',
  'timestamp' => '1568261523',
  'status' => '1',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '16',
  'uid' => '1',
  'title' => 'Page one',
  'log' => '',
  'timestamp' => '1568261548',
  'status' => '1',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '17',
  'uid' => '1',
  'title' => 'Page one',
  'log' => '2nd',
  'timestamp' => '1568261687',
  'status' => '1',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
))
->values(array(
  'nid' => '11',
  'vid' => '18',
  'uid' => '1',
  'title' => 'Page one',
  'log' => '',
  'timestamp' => '1568261721',
  'status' => '1',
  'comment' => '1',
  'promote' => '0',
  'sticky' => '0',
))
->execute();
$connection->schema()->createTable('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'base' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'has_title' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'disabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_type')
->fields(array(
  'type',
  'name',
  'base',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'custom',
  'modified',
  'locked',
  'disabled',
  'orig_type',
))
->values(array(
  'type' => 'article',
  'name' => 'Article',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'help' => 'Help text for articles',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'article',
))
->values(array(
  'type' => 'a_thirty_two_character_type_name',
  'name' => 'Test long name',
  'base' => 'node_content',
  'module' => 'node',
  'description' => '',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'blog',
  'name' => 'Blog entry',
  'base' => 'blog',
  'module' => 'blog',
  'description' => 'Use for multi-user blogs. Every user gets a personal blog.',
  'help' => 'Blog away, good sir!',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '0',
  'modified' => '1',
  'locked' => '1',
  'disabled' => '0',
  'orig_type' => 'blog',
))
->values(array(
  'type' => 'book',
  'name' => 'Book page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => '<em>Books</em> have a built-in hierarchical navigation. Use for handbooks or tutorials.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'book',
))
->values(array(
  'type' => 'et',
  'name' => 'Entity translation test',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Entity translation test',
  'help' => 'Help text foret pages',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'et',
))
->values(array(
  'type' => 'forum',
  'name' => 'Forum topic',
  'base' => 'forum',
  'module' => 'forum',
  'description' => 'A <em>forum topic</em> starts a new discussion thread within a forum.',
  'help' => 'No name-calling, no flame wars. Be nice.',
  'has_title' => '1',
  'title_label' => 'Subject',
  'custom' => '0',
  'modified' => '1',
  'locked' => '1',
  'disabled' => '0',
  'orig_type' => 'forum',
))
->values(array(
  'type' => 'page',
  'name' => 'Basic page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'help' => 'Help text for basic pages',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'test_content_type',
  'name' => 'Test content type',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'This is the description of the test content type.',
  'help' => 'Help text for test content type',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'test_content_type',
))
->execute();
$connection->schema()->createTable('queue', array(
  'fields' => array(
    'item_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'item_id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('registry', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '9',
      'default' => '',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'name',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry')
->fields(array(
  'name',
  'type',
  'filename',
  'module',
  'weight',
))
->values(array(
  'name' => 'AccessDeniedTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'AdminMetaTagTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverInterface',
  'type' => 'interface',
  'filename' => 'includes/archiver.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverTar',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverZip',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Archive_Tar',
  'type' => 'class',
  'filename' => 'modules/system/system.tar.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchMemoryQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockAdminThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockCacheTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHashTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHiddenRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHTMLIdTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockInvalidRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTemplateSuggestionsUnitTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockViewModuleDeltaAlterWebTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlogTestCase',
  'type' => 'class',
  'filename' => 'modules/blog/blog.test',
  'module' => 'blog',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentActionsTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentAnonymous',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentApprovalTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentContentRebuild',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentController',
  'type' => 'class',
  'filename' => 'modules/comment/comment.module',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentFieldsTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentHelperCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentInterfaceTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentNodeAccessTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentNodeChangesTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentPagerTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentPreviewTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentRSSUnitTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentThreadingTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentUninstallTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'ConfirmFormTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ContactPersonalTestCase',
  'type' => 'class',
  'filename' => 'modules/contact/contact.test',
  'module' => 'contact',
  'weight' => '0',
))
->values(array(
  'name' => 'ContactSitewideTestCase',
  'type' => 'class',
  'filename' => 'modules/contact/contact.test',
  'module' => 'contact',
  'weight' => '0',
))
->values(array(
  'name' => 'CronQueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CronRunTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Database',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseCondition',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnectionNotDefinedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseDriverNotSpecifiedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseLog',
  'type' => 'class',
  'filename' => 'includes/database/log.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectDoesNotExistException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectExistsException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementBase',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementEmpty',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementInterface',
  'type' => 'interface',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementPrefetch',
  'type' => 'class',
  'filename' => 'includes/database/prefetch.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatement_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTaskException',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransaction',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionCommitFailedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionExplicitCommitNotAllowedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNameNonUniqueException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNoActiveException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionOutOfOrderException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DateTimeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DefaultMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheArray',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheInterface',
  'type' => 'interface',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDatabaseCache',
  'type' => 'class',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDefaultEntityController',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalEntityControllerInterface',
  'type' => 'interface',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalFakeCache',
  'type' => 'class',
  'filename' => 'includes/cache-install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Drupali18nConfigTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/i18n/i18n.test',
  'module' => 'i18n',
  'weight' => '0',
))
->values(array(
  'name' => 'Drupali18nTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/i18n/i18n.test',
  'module' => 'i18n',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalLocalStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPrivateStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPublicStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalReliableQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalRequestSanitizer',
  'type' => 'class',
  'filename' => 'includes/request-sanitizer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalSetMessageTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalStreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalTemporaryStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdateException',
  'type' => 'class',
  'filename' => 'includes/update.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdaterInterface',
  'type' => 'interface',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EnableDisableTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQuery',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQueryException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMalformedException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityPropertiesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationCommentHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.comment.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationCommentTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationContentTranslationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationDefaultHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationHandlerFactory',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler_factory.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationHandlerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationHierarchyTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationHookTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationNodeHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.node.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationTaxonomyAutocompleteTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationTaxonomyTermHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.taxonomy_term.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationToggleFieldsTranslatabilityTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationTranslationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationUserHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.user.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_field_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_field.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_field_label',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_label.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_field_translate_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_translate_link.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_filter_entity_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_entity_type.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_filter_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_language.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_filter_translation_exists',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_translation_exists.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_relationship.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachOtherTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldBulkDeleteTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldDisplayAPITestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldFormTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfo',
  'type' => 'class',
  'filename' => 'modules/field/field.info.class.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfoTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInstanceCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldsOverlapException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldSqlStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'module' => 'field_sql_storage',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTranslationsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageFieldsTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUpdateForbiddenException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldValidationException',
  'type' => 'class',
  'filename' => 'modules/field/field.attach.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldAnonymousSubmission',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldPathTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldRevisionTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldWidgetTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileManagedFileElementTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FilePrivateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileScanDirectory',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileThemeImplementationsTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransfer',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferChmodInterface',
  'type' => 'interface',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferException',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTP',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTPExtension',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferLocal',
  'type' => 'class',
  'filename' => 'includes/filetransfer/local.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferSSH',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ssh.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterCRUDTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDefaultFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDOMSerializeTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterFormatAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterNoFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSecurityTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterUnitTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FloodFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ForumIndexTestCase',
  'type' => 'class',
  'filename' => 'modules/forum/forum.test',
  'module' => 'forum',
  'weight' => '0',
))
->values(array(
  'name' => 'ForumTestCase',
  'type' => 'class',
  'filename' => 'modules/forum/forum.test',
  'module' => 'forum',
  'weight' => '0',
))
->values(array(
  'name' => 'FrontPageTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'HookRequirementsTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'HtaccessTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'i18n_object_wrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/i18n/i18n_object.inc',
  'module' => 'i18n',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminStylesUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminUiTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsScaleTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageEffectsUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDefaultImagesTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStyleFlushTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStylesPathAndUrlTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageThemeFunctionWebTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'InfoFileParserTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InvalidMergeQueryException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InvalidQueryConditionOperatorException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'IPAddressBlockingTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleBrowserDetectionTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleCommentLanguageFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleConfigurationTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleContentFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleCSSAlterTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleDateFormatsFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleExportFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleImportFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleInstallTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleJavascriptTranslationTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleLanguageNegotiationInfoFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleLanguageSwitchingFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleLibraryInfoAlterTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleMultilingualFieldsFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocalePathFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocalePluralFormatTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleStringIsSafeTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleTranslationFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleUILanguageNegotiationTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleUninstallFrenchFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleUninstallFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleUrlRewritingTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleUserCreationTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'LocaleUserLanguageFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/locale/locale.test',
  'module' => 'locale',
  'weight' => '0',
))
->values(array(
  'name' => 'MailSystemInterface',
  'type' => 'interface',
  'filename' => 'includes/mail.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MemoryQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MenuNodeTestCase',
  'type' => 'class',
  'filename' => 'modules/menu/menu.test',
  'module' => 'menu',
  'weight' => '0',
))
->values(array(
  'name' => 'MenuTestCase',
  'type' => 'class',
  'filename' => 'modules/menu/menu.test',
  'module' => 'menu',
  'weight' => '0',
))
->values(array(
  'name' => 'MergeQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MigrateTranslationEntityHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.migrate.inc',
  'module' => 'entity_translation',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleDependencyTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleRequiredTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleVersionTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MultiStepNodeFormBasicOptionsTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NewDefaultThemeBlocks',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessBaseTableTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessPagerTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRecordsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBuildContent',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeController',
  'type' => 'class',
  'filename' => 'modules/node/node.module',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeCreationTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityFieldQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityViewModeAlterTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeFeedTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeMultiByteUtf8Test',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePageCacheTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePostSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRSSContentTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleXSSTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypePersistenceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypeTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeWebTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NoFieldsException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'NonDefaultBlockAdmin',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NumberFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/number/number.test',
  'module' => 'number',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsSelectDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsWidgetsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'PageEditTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PageNotFoundTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PagePreviewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PagerDefault',
  'type' => 'class',
  'filename' => 'includes/pager.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'PageTitleFiltering',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PageViewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PathLanguageTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathLanguageUITestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathMonolingualTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'Query',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryAlterableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryConditionInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryExtendableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryPlaceholderInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'RetrieveFileTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SchemaCache',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryExtender',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ShutdownFunctionsTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SiteMaintenanceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SkipDotsRecursiveDirectoryIterator',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsBlockVisitorsTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsLoggingTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsReportsTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SummaryLengthTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemArchiverTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAuthorizeCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemIndexPhpTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemInfoAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemMainContentFallback',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemThemeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemValidTokenTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TableSort',
  'type' => 'class',
  'filename' => 'includes/tablesort.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyEFQTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyLegacyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyPrivateFileTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyQueryAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyRSSTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermCacheUsageTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermController',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.module',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFieldMultipleVocabularyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFunctionTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermIndexTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyController',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.module',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyWebTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TestingMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TextFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextSummaryTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextTranslationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeRegistry',
  'type' => 'class',
  'filename' => 'includes/theme.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenScanTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TranslationTestCase',
  'type' => 'class',
  'filename' => 'modules/translation/translation.test',
  'module' => 'translation',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Updater',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterFileTransferException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateScriptFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAccountLinksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAuthmapAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAutocompleteTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserBlocksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCancelTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserController',
  'type' => 'class',
  'filename' => 'modules/user/user.module',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCreateTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditedOwnAccountTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserLoginTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPasswordResetTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPictureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRegistrationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRoleAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRolesAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSignatureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTimeZoneFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserUserSearchTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidateCurrentPassCustomForm',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'VariableTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/variable/variable.test',
  'module' => 'variable',
  'weight' => '0',
))
->execute();
$connection->schema()->createTable('registry_file', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'hash' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry_file')
->fields(array(
  'filename',
  'hash',
))
->values(array(
  'filename' => 'includes/actions.inc',
  'hash' => 'f36b066681463c7dfe189e0430cb1a89bf66f7e228cbb53cdfcd93987193f759',
))
->values(array(
  'filename' => 'includes/ajax.inc',
  'hash' => '8d5ebead219c48d5929ee6a5a178a331471ee6ceb38653094514c952457eaebd',
))
->values(array(
  'filename' => 'includes/archiver.inc',
  'hash' => 'bdbb21b712a62f6b913590b609fd17cd9f3c3b77c0d21f68e71a78427ed2e3e9',
))
->values(array(
  'filename' => 'includes/authorize.inc',
  'hash' => '3eb984facfe9e0228e4d01ece6345cf33dfcd2fcc9c291b15f2e4f782a6029a9',
))
->values(array(
  'filename' => 'includes/batch.inc',
  'hash' => '756b66e69a05b74629dee0ff175385813b27eb635aa49380edd4a65532998825',
))
->values(array(
  'filename' => 'includes/batch.queue.inc',
  'hash' => '554b2e92e1dad0f7fd5a19cb8dff7e109f10fbe2441a5692d076338ec908de0f',
))
->values(array(
  'filename' => 'includes/bootstrap.inc',
  'hash' => '7a9ea059e58578df97a205f0b3f0929cfe469e68addb4331a8dd4b54c2c407ec',
))
->values(array(
  'filename' => 'includes/cache-install.inc',
  'hash' => 'e7ed123c5805703c84ad2cce9c1ca46b3ce8caeeea0d8ef39a3024a4ab95fa0e',
))
->values(array(
  'filename' => 'includes/cache.inc',
  'hash' => '033c9bf2555dba29382b077f78cc00c82fd7f42a959ba31b710adddf6fdf24fe',
))
->values(array(
  'filename' => 'includes/common.inc',
  'hash' => '3b30067db24a5ba03a5a2151c6616590ffb8aba4073f15d2398268ac860d8083',
))
->values(array(
  'filename' => 'includes/database/database.inc',
  'hash' => '9f79732882753fda10b4c0a3fc9fe1cb7f4cdacef743a28664d8af6a855ac8b7',
))
->values(array(
  'filename' => 'includes/database/log.inc',
  'hash' => '9feb5a17ae2fabcf26a96d2a634ba73da501f7bcfc3599a693d916a6971d00d1',
))
->values(array(
  'filename' => 'includes/database/mysql/database.inc',
  'hash' => 'fb808762239838f920ffeb74a89db5894fb46131d8bb4c65a0caff82358562c6',
))
->values(array(
  'filename' => 'includes/database/mysql/install.inc',
  'hash' => '6ae316941f771732fbbabed7e1d6b4cbb41b1f429dd097d04b3345aa15e461a0',
))
->values(array(
  'filename' => 'includes/database/mysql/query.inc',
  'hash' => 'cddf695f7dbd483591f93af805e7118a04eac3f21c0105326642c6463587670c',
))
->values(array(
  'filename' => 'includes/database/mysql/schema.inc',
  'hash' => 'c34aa7b7d2cb4662965497ff86f242224116bbd9b72ca6287c12039a65feb72e',
))
->values(array(
  'filename' => 'includes/database/pgsql/database.inc',
  'hash' => 'f53cb5779d702dde7aefacf8ee25d67cac48d3b94cd8d64057d42c61c5713526',
))
->values(array(
  'filename' => 'includes/database/pgsql/install.inc',
  'hash' => '39587f26a9e054afaab2064d996af910f1b201ef1c6b82938ef130e4ff8c6aab',
))
->values(array(
  'filename' => 'includes/database/pgsql/query.inc',
  'hash' => 'bb04ae9239c2179aeb3ef0a55596ee5ae0ddfb5dfd701896c41bf8c42a62280b',
))
->values(array(
  'filename' => 'includes/database/pgsql/schema.inc',
  'hash' => '0eb77d1d8b30988ba89cbacbcbbc3b66d8ab98b8be8dfa4208a50a45ee77b6e2',
))
->values(array(
  'filename' => 'includes/database/pgsql/select.inc',
  'hash' => '1e509bc97c58223750e8ea735145b316827e36f43c07b946003e41f5bca23659',
))
->values(array(
  'filename' => 'includes/database/prefetch.inc',
  'hash' => '026b6b272a91bae5d9325477530167e737b29bf988553a28cdf72fc1d1ea57ed',
))
->values(array(
  'filename' => 'includes/database/query.inc',
  'hash' => 'f4792f623339ba9097e2af5a4785a3d7d836c831af3894506ddacaa124dd892c',
))
->values(array(
  'filename' => 'includes/database/schema.inc',
  'hash' => 'da9d48f26c3a47a91f1eb2fa216e9deab2ec42ba10c76039623ce7b6bc984a06',
))
->values(array(
  'filename' => 'includes/database/select.inc',
  'hash' => '72eeb85a2739c56d25e359c17847d3094e1a67164a2eb85e70b5260cb7d5c79d',
))
->values(array(
  'filename' => 'includes/database/sqlite/database.inc',
  'hash' => '22e80c5a02c143eace3628e196dded78552e6f2889d1989d052e2a37f46e7f0f',
))
->values(array(
  'filename' => 'includes/database/sqlite/install.inc',
  'hash' => '6620f354aa175a116ba3a0562c980d86cc3b8b481042fc3cc5ed6a4d1a7a6d74',
))
->values(array(
  'filename' => 'includes/database/sqlite/query.inc',
  'hash' => '5d4dc3ac34cb2dbc0293471e85e37c890da3da6cd8c0c540c6f33313e4c0cbe9',
))
->values(array(
  'filename' => 'includes/database/sqlite/schema.inc',
  'hash' => '7bf3af0a255f374ba0c5db175548e836d953b903d31e1adb1e4d3df40d6fdb98',
))
->values(array(
  'filename' => 'includes/database/sqlite/select.inc',
  'hash' => '8d1c426dbd337733c206cce9f59a172546c6ed856d8ef3f1c7bef05a16f7bf68',
))
->values(array(
  'filename' => 'includes/date.inc',
  'hash' => '1de2c25e3b67a9919fc6c8061594442b6fb2cdd3a48ddf1591ee3aa98484b737',
))
->values(array(
  'filename' => 'includes/entity.inc',
  'hash' => 'd548abea63b68b5f59bbb59cf9ceeda53a7e96949cbbfe25ba3fce08f0a7c0e9',
))
->values(array(
  'filename' => 'includes/errors.inc',
  'hash' => '577e66843ac3ac0d6cb9d0808ff48d9e83acad0faeffad5dfe1ba09bf2631b97',
))
->values(array(
  'filename' => 'includes/file.inc',
  'hash' => 'd0b26c57edd76096e28e3bb98a24129bf6070de1523106b03b53803ed883382b',
))
->values(array(
  'filename' => 'includes/file.mimetypes.inc',
  'hash' => '33266e837f4ce076378e7e8cef6c5af46446226ca4259f83e13f605856a7f147',
))
->values(array(
  'filename' => 'includes/file.phar.inc',
  'hash' => '544df23f736ce49f458033d6515a301a8ca1c7a7d1bfd3f388caef910534abb3',
))
->values(array(
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'hash' => '48a9cbcd6651a7fbf9fca9707ebc9fc79be36c33cd2f8c272b375123ce3f4dc3',
))
->values(array(
  'filename' => 'includes/filetransfer/ftp.inc',
  'hash' => '51eb119b8e1221d598ffa6cc46c8a322aa77b49a3d8879f7fb38b7221cf7e06d',
))
->values(array(
  'filename' => 'includes/filetransfer/local.inc',
  'hash' => '7cbfdb46abbdf539640db27e66fb30e5265128f31002bd0dfc3af16ae01a9492',
))
->values(array(
  'filename' => 'includes/filetransfer/ssh.inc',
  'hash' => '92f1232158cb32ab04cbc93ae38ad3af04796e18f66910a9bc5ca8e437f06891',
))
->values(array(
  'filename' => 'includes/form.inc',
  'hash' => 'c6f9db191716ae0ea71bd79951e55344825fbc600e8e07057557593d614f6f9c',
))
->values(array(
  'filename' => 'includes/graph.inc',
  'hash' => '8e0e313a8bb33488f371df11fc1b58d7cf80099b886cd1003871e2c896d1b536',
))
->values(array(
  'filename' => 'includes/image.inc',
  'hash' => 'bcdc7e1599c02227502b9d0fe36eeb2b529b130a392bc709eb737647bd361826',
))
->values(array(
  'filename' => 'includes/install.core.inc',
  'hash' => 'b6f3e5d9bd4154f840253e34aed131bb401deb4fcb3421b379851231b8b4c149',
))
->values(array(
  'filename' => 'includes/install.inc',
  'hash' => 'dc7b5c97803df3e8e80e62984fe820de53ebc4141b645f66f6344f51ef4d5b19',
))
->values(array(
  'filename' => 'includes/iso.inc',
  'hash' => '09f14cce40153fa48e24a7daa44185c09ec9f56a638b5e56e9390c67ec5aaec8',
))
->values(array(
  'filename' => 'includes/json-encode.inc',
  'hash' => '02a822a652d00151f79db9aa9e171c310b69b93a12f549bc2ce00533a8efa14e',
))
->values(array(
  'filename' => 'includes/language.inc',
  'hash' => '4e08f30843a7ccaeea5c041083e9f77d33d57ff002f1ab4f66168e2c683ce128',
))
->values(array(
  'filename' => 'includes/locale.inc',
  'hash' => '3161313aaab94a956f855a2635d738806142b33f06734cdc3df81a3f3854fbdb',
))
->values(array(
  'filename' => 'includes/lock.inc',
  'hash' => 'a181c8bd4f88d292a0a73b9f1fbd727e3314f66ec3631f288e6b9a54ba2b70fa',
))
->values(array(
  'filename' => 'includes/mail.inc',
  'hash' => 'a7bef724e057f7410e42c8f33b00c9a0246a2ca2e856a113c9e20eecc49fc069',
))
->values(array(
  'filename' => 'includes/menu.inc',
  'hash' => '9cbc6636d5c5f9c681eea9fd9c09973e2e29b66bca38420883b657f9e1c0800a',
))
->values(array(
  'filename' => 'includes/module.inc',
  'hash' => '75720e119c7fdc82bdefdd43e36661c990da6f69c1008e6f7997a6081590c8db',
))
->values(array(
  'filename' => 'includes/pager.inc',
  'hash' => 'a596da575268e116c140b65e4ec98e4006c04a188f65a1c48b766b6ee276853f',
))
->values(array(
  'filename' => 'includes/password.inc',
  'hash' => 'fd9a1c94fe5a0fa7c7049a2435c7280b1d666b2074595010e3c492dd15712775',
))
->values(array(
  'filename' => 'includes/path.inc',
  'hash' => 'e399fc0af1f25cebda4b6c471ab203db8abe1a0fe15e632f19e614f32d71821e',
))
->values(array(
  'filename' => 'includes/registry.inc',
  'hash' => '2067cc87973e7af23428d3f41b8f8739d80092bc3c9e20b5a8858e481d03f22c',
))
->values(array(
  'filename' => 'includes/request-sanitizer.inc',
  'hash' => '770e8ece7b53d13e2b5ef99da02adb9a3d18071c6cd29eb01af30927cf749a73',
))
->values(array(
  'filename' => 'includes/session.inc',
  'hash' => '9981d139191b6a983f837e867058a376b62ae7cf5df607aee29e3e322a927b50',
))
->values(array(
  'filename' => 'includes/stream_wrappers.inc',
  'hash' => '3244dae1fa57557f8d0d805fc163830ac1263914587f652f009594a0fa51eeaf',
))
->values(array(
  'filename' => 'includes/tablesort.inc',
  'hash' => '2d88768a544829595dd6cda2a5eb008bedb730f36bba6dfe005d9ddd999d5c0f',
))
->values(array(
  'filename' => 'includes/theme.inc',
  'hash' => 'ae46daba6419ca613bc6a08ba4d7f9bbab9b19889937099d2e4c1737e9e7b2df',
))
->values(array(
  'filename' => 'includes/theme.maintenance.inc',
  'hash' => '39f068b3eee4d10a90d6aa3c86db587b6d25844c2919d418d34d133cfe330f5a',
))
->values(array(
  'filename' => 'includes/token.inc',
  'hash' => '5e7898cd78689e2c291ed3cd8f41c032075656896f1db57e49217aac19ae0428',
))
->values(array(
  'filename' => 'includes/unicode.entities.inc',
  'hash' => '2b858138596d961fbaa4c6e3986e409921df7f76b6ee1b109c4af5970f1e0f54',
))
->values(array(
  'filename' => 'includes/unicode.inc',
  'hash' => '89636ce5847340fd19be319839b4203b0d4bbc3487973413d6de9b5f6f839222',
))
->values(array(
  'filename' => 'includes/update.inc',
  'hash' => '25c30f1e61ef9c91a7bdeb37791c2215d9dc2ae07dba124722d783ca31bb01e7',
))
->values(array(
  'filename' => 'includes/updater.inc',
  'hash' => 'd2da0e74ed86e93c209f16069f3d32e1a134ceb6c06a0044f78e841a1b54e380',
))
->values(array(
  'filename' => 'includes/utility.inc',
  'hash' => '3458fd2b55ab004dd0cc529b8e58af12916e8bd36653b072bdd820b26b907ed5',
))
->values(array(
  'filename' => 'includes/xmlrpc.inc',
  'hash' => 'ea24176ec445c440ba0c825fc7b04a31b440288df8ef02081560dc418e34e659',
))
->values(array(
  'filename' => 'includes/xmlrpcs.inc',
  'hash' => '925c4d5bf429ad9650f059a8862a100bd394dce887933f5b3e7e32309a51fd8e',
))
->values(array(
  'filename' => 'modules/block/block.test',
  'hash' => '40d9de00589211770a85c47d38c8ad61c598ec65d9332128a882eb8750e65a16',
))
->values(array(
  'filename' => 'modules/blog/blog.test',
  'hash' => 'f7534b972951c05d34bd832d3e06176b372fff6f4999c428f789fdd7703ed2e2',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'hash' => '6fa14cedb32d94a5c23ead69bc59ebd3dea04ccde583dc429c38097ca5ff39cc',
))
->values(array(
  'filename' => 'modules/comment/comment.test',
  'hash' => '570e35408ad9ca04d881bf2a4f1da6b28668dbb761e7616e8309b2d153d90e03',
))
->values(array(
  'filename' => 'modules/contact/contact.test',
  'hash' => '655e8d5fe7536a972c2233e438a142166b15a118cc644e94b756c2814c375634',
))
->values(array(
  'filename' => 'modules/field/field.attach.inc',
  'hash' => '2df4687b5ec078c4893dc1fea514f67524fd5293de717b9e05caf977e5ae2327',
))
->values(array(
  'filename' => 'modules/field/field.info.class.inc',
  'hash' => '31deca748d873bf78cc6b8c064fdecc5a3451a9d2e9a131bc8c204905029e31f',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'hash' => '48b5b83f214a8d19e446f46c5d7a1cd35faa656ccb7b540f9f02462a440cacdd',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'hash' => '9eb6699cbaf9d8af5879551135ac3acf13b2c356c3792666a38e237db297a97c',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list.test',
  'hash' => '27dbff6becf419aab9652892e4ddcdf53000aa8699c3d5fc72c19af9a0ae52e6',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.test',
  'hash' => '4392f6fadf67c7533725e12bbe15ee2624cd54158e153f42f6cad3c28144395e',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.test',
  'hash' => '9691cd4352c380e8dff0985b539bb3d69c20bc43663427a3d291c59395a87eed',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.test',
  'hash' => 'e93177e4fdf4dda8958822410470cfe3c68eca413f1e0eba12e8c03b42acf634',
))
->values(array(
  'filename' => 'modules/field/tests/field.test',
  'hash' => 'bb3abf8be54272b4e374bbfcd408694022a58a31354a4dfc99166846a68edbb4',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.test',
  'hash' => 'f535e5627c969e9083a63aaf72d4ac645e30709d7b87af15c6c3b870481f283a',
))
->values(array(
  'filename' => 'modules/file/tests/file.test',
  'hash' => '6abb9228cc7caae3d1661f389377d3bbd2f590abed2214a1bc5e0860e857aaf3',
))
->values(array(
  'filename' => 'modules/filter/filter.test',
  'hash' => 'b8aa5e6b832422c6ad5fe963898ec9526c814614f27ecccb67107ce194997d6a',
))
->values(array(
  'filename' => 'modules/forum/forum.test',
  'hash' => 'd282b29d6312d63183e003ba036d7645a946e828c94448592f930d80fceb42d6',
))
->values(array(
  'filename' => 'modules/image/image.test',
  'hash' => '09bc6e4e69eb11a12abc1ab4823227c528d9a72d2d3651626d129d4700fbaac6',
))
->values(array(
  'filename' => 'modules/locale/locale.test',
  'hash' => '0b54695190fe24e5024e4a445a8028dd51211852d63147ca8a907b87260275b1',
))
->values(array(
  'filename' => 'modules/menu/menu.test',
  'hash' => 'db0600ff4e9d2159ecf26c991cbb81931edb32513a0bb7716964ee84006dd912',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'hash' => 'a0431f275b291779ffd1061d7d98b6942106235350b807828e94c6929ad04a41',
))
->values(array(
  'filename' => 'modules/node/node.test',
  'hash' => '5d6e2853efb3f596525508e76f7f44d15621180f9ef51aaf957fc042fb21df1e',
))
->values(array(
  'filename' => 'modules/path/path.test',
  'hash' => 'e7dabb4bbb7afd1b09adf1e64438b74726fc122422b31c7ae6d8e0ed2f7df6b6',
))
->values(array(
  'filename' => 'modules/statistics/statistics.test',
  'hash' => '7abe4cce7ef548637d709e22cf340f9973b6d77615a470949d20a6426f5b08f2',
))
->values(array(
  'filename' => 'modules/system/system.archiver.inc',
  'hash' => '05caceec7b3baecfebd053959c513f134a5ae4070749339495274a81bebb904a',
))
->values(array(
  'filename' => 'modules/system/system.mail.inc',
  'hash' => 'd2f4fca46269981db5edb6316176b7b8161de59d4c24c514b63fe3c536ebb4d6',
))
->values(array(
  'filename' => 'modules/system/system.queue.inc',
  'hash' => 'a77a5913d84368092805ac551ca63737c1d829455504fcccb95baa2932f28009',
))
->values(array(
  'filename' => 'modules/system/system.tar.inc',
  'hash' => '2dd9560bddab659f0379ef9eca095fc65a364128420d9d9e540ef81ca649a7d6',
))
->values(array(
  'filename' => 'modules/system/system.test',
  'hash' => 'f815c9be6f3059a891147aca5dd6f45a857cd608db78d683c529a29ebd5ab7a0',
))
->values(array(
  'filename' => 'modules/system/system.updater.inc',
  'hash' => '9433fa8d39500b8c59ab05f41c0aac83b2586a43be4aa949821380e36c4d3c48',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'hash' => 'b246e538820cbd80b972e8a16b488b8974eb5dcfc16578f5405927c9727441a6',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.test',
  'hash' => '4db45ebdc63089e79cce177221ffc50658554688c9b467226b7afb2da7e35940',
))
->values(array(
  'filename' => 'modules/translation/translation.test',
  'hash' => 'c2ad71934a9a2139cdf8213df35f4c91dcc0e643fabb883c38e3ffbdd313d608',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'hash' => '6762ef76e12db1f48e2856d0f5c420ecdaa29fff26775275c1ff9d7e357e7b4d',
))
->values(array(
  'filename' => 'modules/user/user.test',
  'hash' => '09b1d7ade399e4fc65ce86e39ed33ee62f36e51cda5c25687eb7fa1e51cc06b8',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.comment.inc',
  'hash' => 'c1667be0bdea8805be52b10bad904f60a278213b749d4c9903e3887b6165448c',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.inc',
  'hash' => 'd470382679e75b63f370e7d476a737eb104e7bae0937668d912873bc2c94ce89',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.node.inc',
  'hash' => '255963e0d0a38349e1c5cb3ff072819b9c39cb5760a71b312ddaac1dd2edbb82',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.taxonomy_term.inc',
  'hash' => '587417ed1ba9debd4caef9b32722ca003be28c325d12f3fcb82b70384c095814',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.user.inc',
  'hash' => '4574d55fc756f566bc10f574231ee7900a181fbaa68d647ae973d9e06b4167ac',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler_factory.inc',
  'hash' => '80ed7658c3d685bc18e7d29129893b2fb48dcda029e730241c1d0f53db7ad367',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/includes/translation.migrate.inc',
  'hash' => 'e5c56971c44ad5352089481e48e01fb83bfefbb5359c8033949ce5227a917d42',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation.test',
  'hash' => 'b3aa79b5d0805999336c000aafa63c9384303bd5018ca57d78cb94fa380eb854',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_field.inc',
  'hash' => '4681a5b5e8963b562e6fbb39c3385024034f392162eb4ff7f52a1684db628ea8',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_label.inc',
  'hash' => 'd31ea1af45150832df052fad29af729c6c028a54fa44d62a023a861bbeba744d',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_translate_link.inc',
  'hash' => '78cfa9c4e9b074e5d45d887fe8f69a8966fc0112d95a6abc74b9b13421b58047',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_entity_type.inc',
  'hash' => 'd86bb73731c60f8ebaa3d8c29f837403935e91fe062c5ab6293901aa253da3e7',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_language.inc',
  'hash' => '44c3a6928b8f7cde5fea6ae7cff973982d6c7781a3c8be663838ff770435c939',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_translation_exists.inc',
  'hash' => '25d8ee7f5d45a5e3984572d00816368902121574f04277a67bbabd004b67f39a',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_relationship.inc',
  'hash' => 'aac136a9eab8c4b832edd73b942e124c3fdf1f48b6c8a8d0bf5383ba1d32259c',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n.test',
  'hash' => 'c52b5076bfd40ec8820a1f58dd9ea6f8d0098c771f65d740298143137d52866e',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_object.inc',
  'hash' => '13118a2525f7ef27040f1c4824fcd05258154fcba128bdb5802c0aac471293c8',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/forum.variable.inc',
  'hash' => '84ab5992d648c704b2ae6d680cf8e02d3150cccd8939170f7e8fd82ac054b516',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/locale.variable.inc',
  'hash' => '27173d9c9e526a8ba88c5f48bf516aaac59ad932b64ef654621bc11f1ccd9f7a',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/menu.variable.inc',
  'hash' => 'bc776840ee32060a9fda616ca154d3fd315461fbe07ce822d7969b79fccd8160',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/node.variable.inc',
  'hash' => '596064101f8fbd3affdb61ca1240354ce0b51778601a8b02c021a1150bbf4e06',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/system.variable.inc',
  'hash' => '909bae0f1e3a4d85c32c385a92a58c559576fb60fd13a0e4f71127eee27afd3e',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/taxonomy.variable.inc',
  'hash' => '7792f07f8ea088cd8c3350e16f4cacef262c319c2e605dd911f17999a872f09e',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/translation.variable.inc',
  'hash' => '3e4e82f779986bfb32987d6b27bdab9f907ba5e18841847f138a20c42cf725d4',
))
->values(array(
  'filename' => 'sites/all/modules/variable/includes/user.variable.inc',
  'hash' => 'b80094c1db0037f396f197bdd70c19e87afe76f4378c5c6089c4199af3bcb03a',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable.test',
  'hash' => 'a6614814c24aee5ae1d2f2f8c23c08138466c41a82e57ee670e070d7cdd6e4b2',
))
->execute();
$connection->schema()->createTable('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role')
->fields(array(
  'rid',
  'name',
  'weight',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
  'weight' => '0',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
  'weight' => '1',
))
->values(array(
  'rid' => '3',
  'name' => 'administrator',
  'weight' => '2',
))
->execute();
$connection->schema()->createTable('role_permission', array(
  'fields' => array(
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'permission' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
    'permission',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role_permission')
->fields(array(
  'rid',
  'permission',
  'module',
))
->values(array(
  'rid' => '1',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '1',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '1',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '2',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'post comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'skip comment approval',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format custom_text_format',
  'module' => 'filter',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'access administration pages',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access all views',
  'module' => 'views',
))
->values(array(
  'rid' => '3',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'access content overview',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site in maintenance mode',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site reports',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site-wide contact form',
  'module' => 'contact',
))
->values(array(
  'rid' => '3',
  'permission' => 'access statistics',
  'module' => 'statistics',
))
->values(array(
  'rid' => '3',
  'permission' => 'access user contact forms',
  'module' => 'contact',
))
->values(array(
  'rid' => '3',
  'permission' => 'access user profiles',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer actions',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer blocks',
  'module' => 'block',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer contact forms',
  'module' => 'contact',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer content types',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer fields',
  'module' => 'field',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer filters',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer forums',
  'module' => 'forum',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer image styles',
  'module' => 'image',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer languages',
  'module' => 'locale',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer menu',
  'module' => 'menu',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer modules',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer nodes',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer permissions',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer site configuration',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer software updates',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer statistics',
  'module' => 'statistics',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer taxonomy',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer themes',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer url aliases',
  'module' => 'path',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer users',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer views',
  'module' => 'views',
))
->values(array(
  'rid' => '3',
  'permission' => 'block IP addresses',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'bypass node access',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'cancel account',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'change own username',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'create article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create url aliases',
  'module' => 'path',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete any article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete terms in 1',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit terms in 1',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'post comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'revert revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'select account cancellation method',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'skip comment approval',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'translate admin strings',
  'module' => 'i18n_string',
))
->values(array(
  'rid' => '3',
  'permission' => 'translate content',
  'module' => 'translation',
))
->values(array(
  'rid' => '3',
  'permission' => 'translate interface',
  'module' => 'locale',
))
->values(array(
  'rid' => '3',
  'permission' => 'translate user-defined strings',
  'module' => 'i18n_string',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format custom_text_format',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format full_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'view own unpublished content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'view post access counter',
  'module' => 'statistics',
))
->values(array(
  'rid' => '3',
  'permission' => 'view revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'view the administration theme',
  'module' => 'system',
))
->execute();
$connection->schema()->createTable('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expire' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '10',
      'scale' => '0',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('sequences', array(
  'fields' => array(
    'value' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'value',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('sequences')
->fields(array(
  'value',
))
->values(array(
  'value' => '9',
))
->execute();
$connection->schema()->createTable('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'ssid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'session' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'sid',
    'ssid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'info' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('system')
->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"aggregator.test";}s:9:"configure";s:41:"admin/config/services/aggregator/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:14:"aggregator.css";s:33:"modules/aggregator/aggregator.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/aggregator/tests/aggregator_test.module',
  'name' => 'aggregator_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:23:"Aggregator module tests";s:11:"description";s:46:"Support module for aggregator related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '-5',
  'info' => 'a:11:{s:4:"name";s:5:"Block";s:11:"description";s:140:"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"block.test";}s:9:"configure";s:21:"admin/structure/block";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/tests/block_test.module',
  'name' => 'block_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Block test";s:11:"description";s:21:"Provides test blocks.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Blog";s:11:"description";s:25:"Enables multi-user blogs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"blog.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"book.test";}s:9:"configure";s:27:"admin/content/book/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"book.css";s:21:"modules/book/book.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"color.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"text";}s:5:"files";a:2:{i:0;s:14:"comment.module";i:1;s:12:"comment.test";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:11:"comment.css";s:27:"modules/comment/comment.css";}}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"contact.test";}s:9:"configure";s:23:"admin/structure/contact";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contextual/contextual.module',
  'name' => 'contextual',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Contextual links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"contextual.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dashboard/dashboard.module',
  'name' => 'dashboard',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:9:"Dashboard";s:11:"description";s:136:"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:5:"files";a:1:{i:0;s:14:"dashboard.test";}s:12:"dependencies";a:1:{i:0;s:5:"block";}s:9:"configure";s:25:"admin/dashboard/customize";s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"dblog.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'name' => 'field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:12:"field.module";i:1;s:16:"field.attach.inc";i:2;s:20:"field.info.class.inc";i:3;s:16:"tests/field.test";}s:12:"dependencies";a:1:{i:0;s:17:"field_sql_storage";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"theme/field.css";s:29:"modules/field/theme/field.css";}}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.module',
  'name' => 'field_sql_storage',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:17:"Field SQL storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:22:"field_sql_storage.test";}s:8:"required";b:1;s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/list.module',
  'name' => 'list',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:1:{i:0;s:15:"tests/list.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list_test.module',
  'name' => 'list_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:9:"List test";s:11:"description";s:41:"Support module for the List module tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:11:"number.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.module',
  'name' => 'options',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:12:"options.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:9:"text.test";}s:8:"required";b:1;s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/tests/field_test.module',
  'name' => 'field_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:14:"Field API Test";s:11:"description";s:39:"Support module for the Field API tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:5:"files";a:1:{i:0;s:21:"field_test.entity.inc";}s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.module',
  'name' => 'field_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:13:"field_ui.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/file.module',
  'name' => 'file',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:15:"tests/file.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/file/tests/file_module_test.module',
  'name' => 'file_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:9:"File test";s:11:"description";s:53:"Provides hooks for testing File module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"filter.test";}s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7012',
  'weight' => '1',
  'info' => 'a:12:{s:4:"name";s:5:"Forum";s:11:"description";s:27:"Provides discussion forums.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"forum.test";}s:9:"configure";s:21:"admin/structure/forum";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"forum.css";s:23:"modules/forum/forum.css";}}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"help.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/image.module',
  'name' => 'image',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:5:"Image";s:11:"description";s:34:"Provides image manipulation tools.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:1:{i:0;s:10:"image.test";}s:9:"configure";s:31:"admin/config/media/image-styles";s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/image/tests/image_module_styles_test.module',
  'name' => 'image_module_styles_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:17:"Image Styles test";s:11:"description";s:80:"Provides additional hook implementations for testing Image Styles functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:31:"image_module_styles_test.module";}s:12:"dependencies";a:1:{i:0;s:17:"image_module_test";}s:6:"hidden";b:1;s:5:"mtime";i:1664871879;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/tests/image_module_test.module',
  'name' => 'image_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Image test";s:11:"description";s:69:"Provides hook implementations for testing Image module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:24:"image_module_test.module";}s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"locale.test";}s:9:"configure";s:30:"admin/config/regional/language";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/tests/locale_test.module',
  'name' => 'locale_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Locale Test";s:11:"description";s:42:"Support module for the locale layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"menu.test";}s:9:"configure";s:20:"admin/structure/menu";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7016',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"node.module";i:1;s:9:"node.test";}s:8:"required";b:1;s:9:"configure";s:21:"admin/structure/types";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"node.css";s:21:"modules/node/node.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_access_test.module',
  'name' => 'node_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:24:"Node module access tests";s:11:"description";s:43:"Support module for node permission testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test.module',
  'name' => 'node_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:17:"Node module tests";s:11:"description";s:40:"Support module for node related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test_exception.module',
  'name' => 'node_test_exception',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:27:"Node module exception tests";s:11:"description";s:50:"Support module for node related exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"7.92";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"openid.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/tests/openid_test.module',
  'name' => 'openid_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:21:"OpenID dummy provider";s:11:"description";s:33:"OpenID provider used for testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"openid";}s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/overlay/overlay.module',
  'name' => 'overlay',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Overlay";s:11:"description";s:59:"Displays the Drupal administration interface in an overlay.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"path.test";}s:9:"configure";s:24:"admin/config/search/path";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"php.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"poll.test";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"poll.css";s:21:"modules/poll/poll.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"profile.test";}s:9:"configure";s:27:"admin/config/people/profile";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/rdf.module',
  'name' => 'rdf',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:3:"RDF";s:11:"description";s:148:"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"rdf.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/tests/rdf_test.module',
  'name' => 'rdf_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"RDF module tests";s:11:"description";s:38:"Support module for RDF module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:4:"blog";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:19:"search.extender.inc";i:1;s:11:"search.test";}s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"search.css";s:25:"modules/search/search.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_embedded_form.module',
  'name' => 'search_embedded_form',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:20:"Search embedded form";s:11:"description";s:59:"Support module for search module testing of embedded forms.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_extra_type.module',
  'name' => 'search_extra_type',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"Test search type";s:11:"description";s:41:"Support module for search module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_node_tags.module',
  'name' => 'search_node_tags',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:21:"Test search node tags";s:11:"description";s:44:"Support module for Node search tags testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.module',
  'name' => 'shortcut',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:8:"Shortcut";s:11:"description";s:60:"Allows users to manage customizable lists of shortcut links.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:13:"shortcut.test";}s:9:"configure";s:36:"admin/config/user-interface/shortcut";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/simpletest.module',
  'name' => 'simpletest',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Testing";s:11:"description";s:53:"Provides a framework for unit and functional testing.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:51:{i:0;s:15:"simpletest.test";i:1;s:24:"drupal_web_test_case.php";i:2;s:18:"tests/actions.test";i:3;s:15:"tests/ajax.test";i:4;s:16:"tests/batch.test";i:5;s:15:"tests/boot.test";i:6;s:20:"tests/bootstrap.test";i:7;s:16:"tests/cache.test";i:8;s:17:"tests/common.test";i:9;s:24:"tests/database_test.test";i:10;s:22:"tests/entity_crud.test";i:11;s:32:"tests/entity_crud_hook_test.test";i:12;s:23:"tests/entity_query.test";i:13;s:16:"tests/error.test";i:14;s:15:"tests/file.test";i:15;s:23:"tests/filetransfer.test";i:16;s:15:"tests/form.test";i:17;s:16:"tests/graph.test";i:18;s:16:"tests/image.test";i:19;s:15:"tests/lock.test";i:20;s:15:"tests/mail.test";i:21;s:15:"tests/menu.test";i:22;s:17:"tests/module.test";i:23;s:16:"tests/pager.test";i:24;s:19:"tests/password.test";i:25;s:15:"tests/path.test";i:26;s:19:"tests/registry.test";i:27;s:28:"tests/request_sanitizer.test";i:28;s:17:"tests/schema.test";i:29;s:18:"tests/session.test";i:30;s:20:"tests/tablesort.test";i:31;s:16:"tests/theme.test";i:32;s:18:"tests/unicode.test";i:33;s:17:"tests/update.test";i:34;s:17:"tests/xmlrpc.test";i:35;s:26:"tests/upgrade/upgrade.test";i:36;s:34:"tests/upgrade/upgrade.comment.test";i:37;s:33:"tests/upgrade/upgrade.filter.test";i:38;s:32:"tests/upgrade/upgrade.forum.test";i:39;s:33:"tests/upgrade/upgrade.locale.test";i:40;s:31:"tests/upgrade/upgrade.menu.test";i:41;s:31:"tests/upgrade/upgrade.node.test";i:42;s:35:"tests/upgrade/upgrade.taxonomy.test";i:43;s:34:"tests/upgrade/upgrade.trigger.test";i:44;s:39:"tests/upgrade/upgrade.translatable.test";i:45;s:33:"tests/upgrade/upgrade.upload.test";i:46;s:31:"tests/upgrade/upgrade.user.test";i:47;s:36:"tests/upgrade/update.aggregator.test";i:48;s:33:"tests/upgrade/update.trigger.test";i:49;s:31:"tests/upgrade/update.field.test";i:50;s:30:"tests/upgrade/update.user.test";}s:9:"configure";s:41:"admin/config/development/testing/settings";s:5:"mtime";i:1664871879;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/actions_loop_test.module',
  'name' => 'actions_loop_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:17:"Actions loop test";s:11:"description";s:39:"Support module for action loop testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_forms_test.module',
  'name' => 'ajax_forms_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:26:"AJAX form test mock module";s:11:"description";s:25:"Test for AJAX form calls.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_test.module',
  'name' => 'ajax_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:9:"AJAX Test";s:11:"description";s:40:"Support module for AJAX framework tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/batch_test.module',
  'name' => 'batch_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:14:"Batch API test";s:11:"description";s:35:"Support module for Batch API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_1.module',
  'name' => 'boot_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:39:"A support module for hook_boot testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_2.module',
  'name' => 'boot_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:44:"A support module for hook_boot hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test.module',
  'name' => 'common_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Common Test";s:11:"description";s:32:"Support module for Common tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:15:"common_test.css";s:40:"modules/simpletest/tests/common_test.css";}s:5:"print";a:1:{s:21:"common_test.print.css";s:46:"modules/simpletest/tests/common_test.print.css";}}s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test_cron_helper.module',
  'name' => 'common_test_cron_helper',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:23:"Common Test Cron Helper";s:11:"description";s:56:"Helper module for CronRunTestCase::testCronExceptions().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/database_test.module',
  'name' => 'database_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:13:"Database Test";s:11:"description";s:40:"Support module for Database layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test.module',
  'name' => 'drupal_autoload_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:25:"Drupal code registry test";s:11:"description";s:45:"Support module for testing the code registry.";s:5:"files";a:2:{i:0;s:34:"drupal_autoload_test_interface.inc";i:1;s:30:"drupal_autoload_test_class.inc";}s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module',
  'name' => 'drupal_system_listing_compatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:37:"Drupal system listing compatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module',
  'name' => 'drupal_system_listing_incompatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:39:"Drupal system listing incompatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test.module',
  'name' => 'entity_cache_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:17:"Entity cache test";s:11:"description";s:40:"Support module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:28:"entity_cache_test_dependency";}s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test_dependency.module',
  'name' => 'entity_cache_test_dependency',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:28:"Entity cache test dependency";s:11:"description";s:51:"Support dependency module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_crud_hook_test.module',
  'name' => 'entity_crud_hook_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:22:"Entity CRUD Hooks Test";s:11:"description";s:35:"Support module for CRUD hook tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_query_access_test.module',
  'name' => 'entity_query_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:24:"Entity query access test";s:11:"description";s:49:"Support module for checking entity query results.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/error_test.module',
  'name' => 'error_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Error test";s:11:"description";s:47:"Support module for error and exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/file_test.module',
  'name' => 'file_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:9:"File test";s:11:"description";s:39:"Support module for file handling tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"file_test.module";}s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/filter_test.module',
  'name' => 'filter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:18:"Filter test module";s:11:"description";s:33:"Tests filter hooks and functions.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/form_test.module',
  'name' => 'form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:12:"FormAPI Test";s:11:"description";s:34:"Support module for Form API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/image_test.module',
  'name' => 'image_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Image test";s:11:"description";s:39:"Support module for image toolkit tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/menu_test.module',
  'name' => 'menu_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"Hook menu tests";s:11:"description";s:37:"Support module for menu hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/module_test.module',
  'name' => 'module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Module test";s:11:"description";s:41:"Support module for module system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/path_test.module',
  'name' => 'path_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"Hook path tests";s:11:"description";s:37:"Support module for path hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_0_test/psr_0_test.module',
  'name' => 'psr_0_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"PSR-0 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_4_test/psr_4_test.module',
  'name' => 'psr_4_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"PSR-4 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements1_test.module',
  'name' => 'requirements1_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:11:{s:4:\"name\";s:19:\"Requirements 1 Test\";s:11:\"description\";s:80:\"Tests that a module is not installed when it fails hook_requirements('install').\";s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:5:\"mtime\";i:1664863480;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements2_test.module',
  'name' => 'requirements2_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:11:{s:4:\"name\";s:19:\"Requirements 2 Test\";s:11:\"description\";s:98:\"Tests that a module is not installed when the one it depends on fails hook_requirements('install).\";s:12:\"dependencies\";a:2:{i:0;s:18:\"requirements1_test\";i:1;s:7:\"comment\";}s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:5:\"mtime\";i:1664863480;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/session_test.module',
  'name' => 'session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:12:"Session test";s:11:"description";s:40:"Support module for session data testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_admin_test.module',
  'name' => 'system_admin_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:17:"System Admin Test";s:11:"description";s:44:"Support module for testing system.admin.inc.";s:7:"package";s:16:"Only For Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:0;s:9:"configure";s:13:"config/broken";s:5:"mtime";i:1664871879;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_dependencies_test.module',
  'name' => 'system_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:22:"System dependency test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:19:"_missing_dependency";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module',
  'name' => 'system_incompatible_core_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:50:"System incompatible core version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:37:"system_incompatible_core_version_test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_test.module',
  'name' => 'system_incompatible_core_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:37:"System incompatible core version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"5.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module',
  'name' => 'system_incompatible_module_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:52:"System incompatible module version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:46:"system_incompatible_module_version_test (>2.0)";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_test.module',
  'name' => 'system_incompatible_module_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:39:"System incompatible module version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:3:"1.0";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_null_version_test.module',
  'name' => 'system_null_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:24:"System null version test";s:11:"description";s:47:"Support module for testing with a null version.";s:7:"package";s:16:"Only For Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:0;s:5:"mtime";i:1664871879;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_project_namespace_test.module',
  'name' => 'system_project_namespace_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:29:"System project namespace test";s:11:"description";s:58:"Support module for testing project namespace dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:13:"drupal:filter";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_requires_null_version_test.module',
  'name' => 'system_requires_null_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:33:"System requires null version test";s:11:"description";s:44:"Support module for testing system_modules().";s:7:"package";s:16:"Only For Testing";s:4:"core";s:3:"7.x";s:7:"version";s:4:"7.92";s:6:"hidden";b:0;s:12:"dependencies";a:1:{i:0;s:24:"system_null_version_test";}s:5:"mtime";i:1664871879;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_test.module',
  'name' => 'system_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"System test";s:11:"description";s:34:"Support module for system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:18:"system_test.module";}s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/taxonomy_nodes_test.module',
  'name' => 'taxonomy_nodes_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:31:"Taxonomy module node list tests";s:11:"description";s:54:"Support module for taxonomy node list related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664871879;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/taxonomy_test.module',
  'name' => 'taxonomy_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:20:"Taxonomy test module";s:11:"description";s:45:""Tests functions and hooks not used in core".";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:8:"taxonomy";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/theme_test.module',
  'name' => 'theme_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Theme test";s:11:"description";s:40:"Support module for theme system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_script_test.module',
  'name' => 'update_script_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:18:"Update script test";s:11:"description";s:41:"Support module for update script testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_1.module',
  'name' => 'update_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_2.module',
  'name' => 'update_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_3.module',
  'name' => 'update_test_3',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/url_alter_test.module',
  'name' => 'url_alter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"Url_alter tests";s:11:"description";s:45:"A support modules for url_alter hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/xmlrpc_test.module',
  'name' => 'xmlrpc_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:12:"XML-RPC Test";s:11:"description";s:75:"Support module for XML-RPC tests according to the validator1 specification.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"statistics.test";}s:9:"configure";s:30:"admin/config/system/statistics";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"syslog.test";}s:9:"configure";s:32:"admin/config/development/logging";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7084',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:6:{i:0;s:19:"system.archiver.inc";i:1;s:15:"system.mail.inc";i:2;s:16:"system.queue.inc";i:3;s:14:"system.tar.inc";i:4;s:18:"system.updater.inc";i:5;s:11:"system.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/cron_queue_test.module',
  'name' => 'cron_queue_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"Cron Queue test";s:11:"description";s:41:"Support module for the cron queue runner.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/system_cron_test.module',
  'name' => 'system_cron_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"System Cron Test";s:11:"description";s:45:"Support module for testing the system_cron().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7011',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:7:"options";}s:5:"files";a:2:{i:0;s:15:"taxonomy.module";i:1;s:13:"taxonomy.test";}s:9:"configure";s:24:"admin/structure/taxonomy";s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/toolbar/toolbar.module',
  'name' => 'toolbar',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Toolbar";s:11:"description";s:99:"Provides a toolbar that shows the top-level administration menu items and links from other modules.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Tracker";s:11:"description";s:45:"Enables tracking of recent content for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"tracker.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/tests/translation_test.module',
  'name' => 'translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:24:"Content Translation Test";s:11:"description";s:49:"Support module for the content translation tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"translation.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/tests/trigger_test.module',
  'name' => 'trigger_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:12:"Trigger Test";s:11:"description";s:33:"Support module for Trigger tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"trigger.test";}s:9:"configure";s:23:"admin/structure/trigger";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/aaa_update_test.module',
  'name' => 'aaa_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"AAA Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/bbb_update_test.module',
  'name' => 'bbb_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"BBB Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/ccc_update_test.module',
  'name' => 'ccc_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:15:"CCC Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/update_test.module',
  'name' => 'update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:14:"Update manager";s:11:"description";s:104:"Checks for available updates, and can securely install or update modules and themes via a web interface.";s:7:"version";s:4:"7.92";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"update.test";}s:9:"configure";s:30:"admin/reports/updates/settings";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_flood_test.module',
  'name' => 'user_flood_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:31:"User module flood control tests";s:11:"description";s:46:"Support module for user flood control testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664871879;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_form_test.module',
  'name' => 'user_form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:22:"User module form tests";s:11:"description";s:37:"Support module for user form testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_session_test.module',
  'name' => 'user_session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:25:"User module session tests";s:11:"description";s:40:"Support module for user session testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664871879;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7020',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"user.module";i:1;s:9:"user.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"user.css";s:21:"modules/user/user.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'profiles/standard/standard.profile',
  'name' => 'standard',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '1000',
  'info' => 'a:13:{s:4:"name";s:8:"Standard";s:11:"description";s:51:"Install with commonly used features pre-configured.";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:21:{i:0;s:5:"block";i:1;s:5:"color";i:2;s:7:"comment";i:3;s:10:"contextual";i:4;s:9:"dashboard";i:5;s:4:"help";i:6;s:5:"image";i:7;s:4:"list";i:8;s:4:"menu";i:9;s:6:"number";i:10;s:7:"options";i:11;s:4:"path";i:12;s:8:"taxonomy";i:13;s:5:"dblog";i:14;s:6:"search";i:15;s:8:"shortcut";i:16;s:7:"toolbar";i:17;s:7:"overlay";i:18;s:8:"field_ui";i:19;s:4:"file";i:20;s:3:"rdf";}s:5:"mtime";i:1664863480;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:6:"hidden";b:1;s:8:"required";b:1;s:17:"distribution_name";s:6:"Drupal";}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.module',
  'name' => 'entity',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Entity API";s:11:"description";s:69:"Enables modules to work with any entity type and to provide entities.";s:4:"core";s:3:"7.x";s:5:"files";a:24:{i:0;s:19:"entity.features.inc";i:1;s:15:"entity.i18n.inc";i:2;s:15:"entity.info.inc";i:3;s:16:"entity.rules.inc";i:4;s:11:"entity.test";i:5;s:19:"includes/entity.inc";i:6;s:30:"includes/entity.controller.inc";i:7;s:22:"includes/entity.ui.inc";i:8;s:27:"includes/entity.wrapper.inc";i:9;s:22:"views/entity.views.inc";i:10;s:52:"views/handlers/entity_views_field_handler_helper.inc";i:11;s:51:"views/handlers/entity_views_handler_area_entity.inc";i:12;s:53:"views/handlers/entity_views_handler_field_boolean.inc";i:13;s:50:"views/handlers/entity_views_handler_field_date.inc";i:14;s:54:"views/handlers/entity_views_handler_field_duration.inc";i:15;s:52:"views/handlers/entity_views_handler_field_entity.inc";i:16;s:51:"views/handlers/entity_views_handler_field_field.inc";i:17;s:53:"views/handlers/entity_views_handler_field_numeric.inc";i:18;s:53:"views/handlers/entity_views_handler_field_options.inc";i:19;s:50:"views/handlers/entity_views_handler_field_text.inc";i:20;s:49:"views/handlers/entity_views_handler_field_uri.inc";i:21;s:62:"views/handlers/entity_views_handler_relationship_by_bundle.inc";i:22;s:52:"views/handlers/entity_views_handler_relationship.inc";i:23;s:53:"views/plugins/entity_views_plugin_row_entity_view.inc";}s:5:"mtime";i:1664868240;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity_token.module',
  'name' => 'entity_token',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Entity tokens";s:11:"description";s:99:"Provides token replacements for all properties that have no tokens and are known to the entity API.";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:23:"entity_token.tokens.inc";i:1;s:19:"entity_token.module";}s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:5:"mtime";i:1664868240;s:7:"package";s:5:"Other";s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_feature.module',
  'name' => 'entity_feature',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:21:"Entity feature module";s:11:"description";s:31:"Provides some entities in code.";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:21:"entity_feature.module";}s:12:"dependencies";a:1:{i:0;s:11:"entity_test";}s:6:"hidden";b:1;s:5:"mtime";i:1664868240;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_test.module',
  'name' => 'entity_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:23:"Entity CRUD test module";s:11:"description";s:46:"Provides entity types based upon the CRUD API.";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:18:"entity_test.module";i:1;s:19:"entity_test.install";}s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:6:"hidden";b:1;s:5:"mtime";i:1664868240;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_test_i18n.module',
  'name' => 'entity_test_i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:28:"Entity-test type translation";s:11:"description";s:37:"Allows translating entity-test types.";s:12:"dependencies";a:2:{i:0;s:11:"entity_test";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:5:"mtime";i:1664868240;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/entityreference.module',
  'name' => 'entityreference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"Entity Reference";s:11:"description";s:51:"Provides a field that can reference other entities.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:6:"entity";i:1;s:6:"ctools";}s:17:"test_dependencies";a:2:{i:0;s:5:"feeds";i:1;s:5:"views";}s:5:"files";a:12:{i:0;s:27:"entityreference.migrate.inc";i:1;s:30:"plugins/selection/abstract.inc";i:2;s:27:"plugins/selection/views.inc";i:3;s:29:"plugins/behavior/abstract.inc";i:4;s:40:"views/entityreference_plugin_display.inc";i:5;s:38:"views/entityreference_plugin_style.inc";i:6;s:43:"views/entityreference_plugin_row_fields.inc";i:7;s:35:"tests/entityreference.handlers.test";i:8;s:35:"tests/entityreference.taxonomy.test";i:9;s:32:"tests/entityreference.admin.test";i:10;s:32:"tests/entityreference.feeds.test";i:11;s:45:"tests/entityreference.entity_translation.test";}s:5:"mtime";i:1664944690;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/examples/entityreference_behavior_example/entityreference_behavior_example.module',
  'name' => 'entityreference_behavior_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:33:"Entity Reference Behavior Example";s:11:"description";s:71:"Provides some example code for implementing Entity Reference behaviors.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:12:"dependencies";a:1:{i:0;s:15:"entityreference";}s:5:"mtime";i:1664867650;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/tests/modules/entityreference_feeds_test/entityreference_feeds_test.module',
  'name' => 'entityreference_feeds_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:41:"Entityreference - Feeds integration tests";s:11:"description";s:65:"Support module for the Entityreference - Feeds integration tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:3:{i:0;s:5:"feeds";i:1;s:8:"feeds_ui";i:2;s:15:"entityreference";}s:5:"mtime";i:1664867650;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/entity_translation.module',
  'name' => 'entity_translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '11',
  'info' => 'a:12:{s:4:"name";s:18:"Entity Translation";s:11:"description";s:58:"Allows entities to be translated into different languages.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:9:"configure";s:40:"admin/config/regional/entity_translation";s:12:"dependencies";a:1:{i:0;s:14:"locale (>7.14)";}s:17:"test_dependencies";a:2:{i:0;s:17:"pathauto:pathauto";i:1;s:11:"title:title";}s:5:"files";a:15:{i:0;s:40:"includes/translation.handler_factory.inc";i:1;s:32:"includes/translation.handler.inc";i:2;s:40:"includes/translation.handler.comment.inc";i:3;s:37:"includes/translation.handler.node.inc";i:4;s:46:"includes/translation.handler.taxonomy_term.inc";i:5;s:37:"includes/translation.handler.user.inc";i:6;s:32:"includes/translation.migrate.inc";i:7;s:29:"tests/entity_translation.test";i:8;s:49:"views/entity_translation_handler_relationship.inc";i:9;s:57:"views/entity_translation_handler_field_translate_link.inc";i:10;s:48:"views/entity_translation_handler_field_label.inc";i:11;s:55:"views/entity_translation_handler_filter_entity_type.inc";i:12;s:52:"views/entity_translation_handler_filter_language.inc";i:13;s:62:"views/entity_translation_handler_filter_translation_exists.inc";i:14;s:48:"views/entity_translation_handler_field_field.inc";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/entity_translation_i18n_menu/entity_translation_i18n_menu.module',
  'name' => 'entity_translation_i18n_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:23:"Entity Translation Menu";s:11:"description";s:54:"Allows menu items to be translated on the entity form.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:12:"dependencies";a:3:{i:0;s:18:"entity_translation";i:1;s:4:"i18n";i:2;s:9:"i18n_menu";}s:5:"files";a:1:{i:0;s:33:"entity_translation_i18n_menu.test";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/entity_translation_upgrade/entity_translation_upgrade.module',
  'name' => 'entity_translation_upgrade',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:26:"Entity Translation Upgrade";s:11:"description";s:80:"Provides an upgrade path from node-based translation to field-based translation.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:18:"entity_translation";}s:5:"files";a:1:{i:0;s:31:"entity_translation_upgrade.test";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation_test.module',
  'name' => 'entity_translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:26:"Entity Translation testing";s:11:"description";s:61:"Tests Entity Translation module functionality. Do not enable.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:18:"entity_translation";}s:5:"files";a:1:{i:0;s:30:"entity_translation_test.module";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n.module',
  'name' => 'i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7001',
  'weight' => '10',
  'info' => 'a:11:{s:4:"name";s:20:"Internationalization";s:11:"description";s:49:"Extends Drupal support for multilingual features.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:8:"variable";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:15:"i18n_object.inc";i:1;s:9:"i18n.test";}s:9:"configure";s:26:"admin/config/regional/i18n";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_block/i18n_block.module',
  'name' => 'i18n_block',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '100',
  'info' => 'a:10:{s:4:"name";s:15:"Block languages";s:11:"description";s:68:"Enables language selector for blocks and optional block translation.";s:12:"dependencies";a:2:{i:0;s:5:"block";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:14:"i18n_block.inc";i:1;s:15:"i18n_block.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_contact/i18n_contact.module',
  'name' => 'i18n_contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Contact translation";s:11:"description";s:63:"Makes contact categories and replies available for translation.";s:12:"dependencies";a:2:{i:0;s:7:"contact";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_field/i18n_field.module',
  'name' => 'i18n_field',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Field translation";s:11:"description";s:26:"Translate field properties";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:14:"i18n_field.inc";i:1;s:15:"i18n_field.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_forum/i18n_forum.module',
  'name' => 'i18n_forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:18:"Multilingual forum";s:11:"description";s:60:"Enables multilingual forum, translates names and containers.";s:12:"dependencies";a:3:{i:0;s:5:"forum";i:1;s:13:"i18n_taxonomy";i:2;s:9:"i18n_node";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"i18n_forum.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_menu/i18n_menu.module',
  'name' => 'i18n_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '5',
  'info' => 'a:10:{s:4:"name";s:16:"Menu translation";s:11:"description";s:40:"Supports translatable custom menu items.";s:12:"dependencies";a:4:{i:0;s:4:"i18n";i:1;s:4:"menu";i:2;s:11:"i18n_string";i:3;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:13:"i18n_menu.inc";i:1;s:14:"i18n_menu.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_node/i18n_node.module',
  'name' => 'i18n_node',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:20:"Multilingual content";s:11:"description";s:46:"Extended node options for multilingual content";s:12:"dependencies";a:3:{i:0;s:11:"translation";i:1;s:4:"i18n";i:2;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:31:"admin/config/regional/i18n/node";s:5:"files";a:2:{i:0;s:14:"i18n_node.test";i:1;s:22:"i18n_node.variable.inc";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_path/i18n_path.module',
  'name' => 'i18n_path',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Path translation";s:11:"description";s:37:"Define translations for generic paths";s:12:"dependencies";a:1:{i:0;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:13:"i18n_path.inc";i:1;s:14:"i18n_path.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_redirect/i18n_redirect.module',
  'name' => 'i18n_redirect',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:20:"Translation redirect";s:11:"description";s:71:"Redirect to translated page when available. SEO for multilingual sites.";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_select/i18n_select.module',
  'name' => 'i18n_select',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:19:"Multilingual select";s:11:"description";s:45:"API module for multilingual content selection";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:33:"admin/config/regional/i18n/select";s:5:"files";a:1:{i:0;s:16:"i18n_select.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_string/i18n_string.module',
  'name' => 'i18n_string',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '10',
  'info' => 'a:11:{s:4:"name";s:18:"String translation";s:11:"description";s:57:"Provides support for translation of user defined strings.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:21:"i18n_string.admin.inc";i:1;s:15:"i18n_string.inc";i:2;s:16:"i18n_string.test";}s:9:"configure";s:34:"admin/config/regional/i18n/strings";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_sync/i18n_sync.module',
  'name' => 'i18n_sync',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '100',
  'info' => 'a:10:{s:4:"name";s:24:"Synchronize translations";s:11:"description";s:73:"Synchronizes taxonomy and fields across translations of the same content.";s:12:"dependencies";a:2:{i:0;s:4:"i18n";i:1;s:11:"translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:5:{i:0;s:16:"i18n_sync.module";i:1;s:17:"i18n_sync.install";i:2;s:20:"i18n_sync.module.inc";i:3;s:18:"i18n_sync.node.inc";i:4;s:14:"i18n_sync.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.module',
  'name' => 'i18n_taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '5',
  'info' => 'a:10:{s:4:"name";s:20:"Taxonomy translation";s:11:"description";s:30:"Enables multilingual taxonomy.";s:12:"dependencies";a:3:{i:0;s:8:"taxonomy";i:1;s:11:"i18n_string";i:2;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:17:"i18n_taxonomy.inc";i:1;s:23:"i18n_taxonomy.pages.inc";i:2;s:23:"i18n_taxonomy.admin.inc";i:3;s:18:"i18n_taxonomy.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_translation/i18n_translation.module',
  'name' => 'i18n_translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Translation sets";s:11:"description";s:47:"Simple translation sets API for generic objects";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:20:"i18n_translation.inc";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_user/i18n_user.module',
  'name' => 'i18n_user',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:21:"User mail translation";s:11:"description";s:43:"Translate emails sent from the User module.";s:4:"core";s:3:"7.x";s:7:"package";s:35:"Multilingual - Internationalization";s:12:"dependencies";a:1:{i:0;s:13:"i18n_variable";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_variable/i18n_variable.module',
  'name' => 'i18n_variable',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '-900',
  'info' => 'a:11:{s:4:"name";s:20:"Variable translation";s:11:"description";s:71:"Multilingual variables that switch language depending on page language.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:24:"variable_store (7.x-2.x)";i:2;s:24:"variable_realm (7.x-2.x)";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:35:"admin/config/regional/i18n/variable";s:5:"files";a:2:{i:0;s:23:"i18n_variable.class.inc";i:1;s:18:"i18n_variable.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/tests/i18n_test.module',
  'name' => 'i18n_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:26:"Internationalization tests";s:11:"description";s:55:"Helper module for testing i18n (do not enable manually)";s:12:"dependencies";a:3:{i:0;s:6:"locale";i:1;s:11:"translation";i:2;s:4:"i18n";}s:7:"package";s:7:"Testing";s:4:"core";s:3:"6.x";s:6:"hidden";b:1;s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/title/tests/title_test.module',
  'name' => 'title_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Title Test";s:11:"description";s:61:"Testing module for Title module functionality. Do not enable.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:6:"hidden";b:1;s:12:"dependencies";a:4:{i:0;s:5:"title";i:1;s:8:"taxonomy";i:2;s:6:"entity";i:3;s:18:"entity_translation";}s:5:"mtime";i:1664867487;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/title/title.module',
  'name' => 'title',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Title";s:11:"description";s:50:"Replaces entity legacy fields with regular fields.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:9:"configure";s:26:"admin/config/content/title";s:12:"dependencies";a:1:{i:0;s:14:"system (>7.14)";}s:5:"files";a:4:{i:0;s:35:"views/views_handler_title_field.inc";i:1;s:37:"tests/TitleAdminSettingsTestCase.test";i:2;s:40:"tests/TitleFieldReplacementTestCase.test";i:3;s:35:"tests/TitleTranslationTestCase.test";}s:17:"test_dependencies";a:2:{i:0;s:6:"entity";i:1;s:18:"entity_translation";}s:5:"mtime";i:1664867487;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable.module',
  'name' => 'variable',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Variable";s:11:"description";s:43:"Variable Information and basic variable API";s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"files";a:9:{i:0;s:27:"includes/forum.variable.inc";i:1;s:28:"includes/locale.variable.inc";i:2;s:26:"includes/menu.variable.inc";i:3;s:26:"includes/node.variable.inc";i:4;s:28:"includes/system.variable.inc";i:5;s:30:"includes/taxonomy.variable.inc";i:6;s:33:"includes/translation.variable.inc";i:7;s:26:"includes/user.variable.inc";i:8;s:13:"variable.test";}s:5:"mtime";i:1664867493;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_admin/variable_admin.module',
  'name' => 'variable_admin',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Variable admin";s:11:"description";s:26:"Variable Administration UI";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664867493;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_example/variable_example.module',
  'name' => 'variable_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Variable example";s:11:"description";s:83:"An example module showing how to use the Variable API and providing some variables.";s:12:"dependencies";a:2:{i:0;s:8:"variable";i:1;s:14:"variable_store";}s:7:"package";s:15:"Example modules";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:29:"variable_example.variable.inc";}s:5:"mtime";i:1664867493;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_realm/variable_realm.module',
  'name' => 'variable_realm',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '-1000',
  'info' => 'a:10:{s:4:"name";s:14:"Variable realm";s:11:"description";s:49:"API to use variable realms from different modules";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.x";s:5:"files";a:2:{i:0;s:24:"variable_realm.class.inc";i:1;s:30:"variable_realm_union.class.inc";}s:5:"mtime";i:1664867493;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_store/variable_store.module',
  'name' => 'variable_store',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '-1000',
  'info' => 'a:10:{s:4:"name";s:14:"Variable store";s:11:"description";s:60:"Database storage for variable realms. This is an API module.";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.x";s:5:"files";a:2:{i:0;s:24:"variable_store.class.inc";i:1;s:19:"variable_store.test";}s:5:"mtime";i:1664867493;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_views/variable_views.module',
  'name' => 'variable_views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Variable views";s:11:"description";s:78:"Provides views integration for variable, included a default variable argument.";s:12:"dependencies";a:2:{i:0;s:8:"variable";i:1;s:5:"views";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:51:"includes/views_plugin_argument_default_variable.inc";i:1;s:47:"includes/views_handler_field_variable_title.inc";i:2;s:47:"includes/views_handler_field_variable_value.inc";}s:5:"mtime";i:1664867493;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'themes/bartik/bartik.info',
  'name' => 'bartik',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}}',
))
->values(array(
  'filename' => 'themes/seven/seven.info',
  'name' => 'seven',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;}',
))
->values(array(
  'filename' => 'themes/stark/stark.info',
  'name' => 'stark',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:14:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}",
))
->execute();
$connection->schema()->createTable('taxonomy_index', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'indexes' => array(
    'term_node' => array(
      'tid',
      'sticky',
      'created',
    ),
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('taxonomy_index')
->fields(array(
  'nid',
  'tid',
  'sticky',
  'created',
))
->values(array(
  'nid' => '6',
  'tid' => '1',
  'sticky' => '0',
  'created' => '1504715414',
))
->values(array(
  'nid' => '7',
  'tid' => '1',
  'sticky' => '0',
  'created' => '1504715432',
))
->values(array(
  'nid' => '2',
  'tid' => '9',
  'sticky' => '0',
  'created' => '1441306772',
))
->values(array(
  'nid' => '2',
  'tid' => '14',
  'sticky' => '0',
  'created' => '1441306772',
))
->values(array(
  'nid' => '2',
  'tid' => '17',
  'sticky' => '0',
  'created' => '1441306772',
))
->values(array(
  'nid' => '3',
  'tid' => '9',
  'sticky' => '0',
  'created' => '1471428152',
))
->values(array(
  'nid' => '3',
  'tid' => '14',
  'sticky' => '0',
  'created' => '1471428152',
))
->values(array(
  'nid' => '3',
  'tid' => '17',
  'sticky' => '0',
  'created' => '1471428152',
))
->execute();
$connection->schema()->createTable('taxonomy_term_data', array(
  'fields' => array(
    'tid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => 'und',
    ),
    'i18n_tsid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'tid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('taxonomy_term_data')
->fields(array(
  'tid',
  'vid',
  'name',
  'description',
  'format',
  'weight',
  'language',
  'i18n_tsid',
))
->values(array(
  'tid' => '1',
  'vid' => '2',
  'name' => 'General discussion',
  'description' => '',
  'format' => NULL,
  'weight' => '2',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '5',
  'vid' => '2',
  'name' => 'Custom Forum',
  'description' => 'Where the cool kids are.',
  'format' => NULL,
  'weight' => '3',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '6',
  'vid' => '2',
  'name' => 'Games',
  'description' => '',
  'format' => NULL,
  'weight' => '4',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '7',
  'vid' => '2',
  'name' => 'Minecraft',
  'description' => '',
  'format' => NULL,
  'weight' => '1',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '8',
  'vid' => '2',
  'name' => 'Half Life 3',
  'description' => '',
  'format' => NULL,
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '9',
  'vid' => '1',
  'name' => 'Benjamin Sisko',
  'description' => 'Portrayed by Avery Brooks',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '10',
  'vid' => '1',
  'name' => 'Kira Nerys',
  'description' => 'Portrayed by Nana Visitor',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '11',
  'vid' => '1',
  'name' => 'Dax',
  'description' => 'Portrayed by Terry Farrell',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '12',
  'vid' => '1',
  'name' => 'Jake Sisko',
  'description' => 'Portrayed by Cirroc Lofton',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '13',
  'vid' => '1',
  'name' => 'Gul Dukat',
  'description' => 'Portrayed by Marc Alaimo',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '14',
  'vid' => '1',
  'name' => 'Odo',
  'description' => 'Portrayed by Rene Auberjonois',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '15',
  'vid' => '1',
  'name' => 'Worf',
  'description' => 'Portrayed by Michael Dorn',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '16',
  'vid' => '1',
  'name' => "Miles O'Brien",
  'description' => 'Portrayed by Colm Meaney',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '17',
  'vid' => '1',
  'name' => 'Quark',
  'description' => 'Portrayed by Armin Shimerman',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->values(array(
  'tid' => '18',
  'vid' => '1',
  'name' => 'Elim Garak',
  'description' => 'Portrayed by Andrew Robinson',
  'format' => 'filtered_html',
  'weight' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
))
->execute();
$connection->schema()->createTable('taxonomy_term_hierarchy', array(
  'fields' => array(
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'parent' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'tid',
    'parent',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('taxonomy_term_hierarchy')
->fields(array(
  'tid',
  'parent',
))
->values(array(
  'tid' => '1',
  'parent' => '0',
))
->values(array(
  'tid' => '5',
  'parent' => '0',
))
->values(array(
  'tid' => '6',
  'parent' => '0',
))
->values(array(
  'tid' => '7',
  'parent' => '6',
))
->values(array(
  'tid' => '8',
  'parent' => '6',
))
->values(array(
  'tid' => '9',
  'parent' => '0',
))
->values(array(
  'tid' => '10',
  'parent' => '0',
))
->values(array(
  'tid' => '11',
  'parent' => '0',
))
->values(array(
  'tid' => '12',
  'parent' => '0',
))
->values(array(
  'tid' => '13',
  'parent' => '0',
))
->values(array(
  'tid' => '14',
  'parent' => '0',
))
->values(array(
  'tid' => '15',
  'parent' => '0',
))
->values(array(
  'tid' => '16',
  'parent' => '0',
))
->values(array(
  'tid' => '17',
  'parent' => '0',
))
->values(array(
  'tid' => '18',
  'parent' => '0',
))
->execute();
$connection->schema()->createTable('taxonomy_vocabulary', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'machine_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hierarchy' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => 'und',
    ),
    'i18n_mode' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('taxonomy_vocabulary')
->fields(array(
  'vid',
  'name',
  'machine_name',
  'description',
  'hierarchy',
  'module',
  'weight',
  'language',
  'i18n_mode',
))
->values(array(
  'vid' => '1',
  'name' => 'Tags',
  'machine_name' => 'tags',
  'description' => 'Use tags to group articles on similar topics into categories.',
  'hierarchy' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
  'language' => 'und',
  'i18n_mode' => '0',
))
->values(array(
  'vid' => '2',
  'name' => 'Sujet de discussion',
  'machine_name' => 'sujet_de_discussion',
  'description' => 'Forum navigation vocabulary',
  'hierarchy' => '1',
  'module' => 'forum',
  'weight' => '-10',
  'language' => 'und',
  'i18n_mode' => '0',
))
->execute();
$connection->schema()->createTable('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'source' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'alias' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '32',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'picture' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'init' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'indexes' => array(
    'changed' => array(
      'changed',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users')
->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
  'changed',
))
->values(array(
  'uid' => '1',
  'name' => 'admin',
  'pass' => '$S$D/HVkgCg1Hvi7DN5KVSgNl.2C5g8W6oe/OoIRMUlyjkmPugQRhoB',
  'mail' => 'admin@local.host',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '0',
  'access' => '1687694582',
  'login' => '1687694582',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '0',
  'init' => '',
  'data' => 'a:1:{s:7:"contact";i:1;}',
  'changed' => '0',
))
->execute();
$connection->schema()->createTable('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users_roles')
->fields(array(
  'uid',
  'rid',
))
->values(array(
  'uid' => '1',
  'rid' => '3',
))
->execute();
$connection->schema()->createTable('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable')
->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'actions_max_stack',
  'value' => 'i:28;',
))
->values(array(
  'name' => 'additional_settings__active_tab_article',
  'value' => 's:15:"edit-submission";',
))
->values(array(
  'name' => 'additional_settings__active_tab_blog',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'additional_settings__active_tab_book',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'additional_settings__active_tab_forum',
  'value' => 's:15:"edit-submission";',
))
->values(array(
  'name' => 'additional_settings__active_tab_page',
  'value' => 's:15:"edit-submission";',
))
->values(array(
  'name' => 'additional_settings__active_tab_test_content_type',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'admin_compact_mode',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'admin_theme',
  'value' => 's:5:"seven";',
))
->values(array(
  'name' => 'allow_insecure_derivatives',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'allow_insecure_uploads',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'anonymous',
  'value' => 's:9:"Anonymous";',
))
->values(array(
  'name' => 'authorize_filetransfer_default',
  'value' => 's:3:"ftp";',
))
->values(array(
  'name' => 'block_cache',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_block',
  'value' => 'i:1687694589;',
))
->values(array(
  'name' => 'cache_flush_cache_field',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_filter',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_form',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_image',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_menu',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_page',
  'value' => 'i:1687694589;',
))
->values(array(
  'name' => 'cache_flush_cache_path',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_variable',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_lifetime',
  'value' => 's:3:"300";',
))
->values(array(
  'name' => 'clean_url',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'color_bartik_files',
  'value' => 'a:2:{i:0;s:39:"public://color/bartik-e0e23ad7/logo.png";i:1;s:41:"public://color/bartik-e0e23ad7/colors.css";}',
))
->values(array(
  'name' => 'color_bartik_logo',
  'value' => 's:39:"public://color/bartik-e0e23ad7/logo.png";',
))
->values(array(
  'name' => 'color_bartik_palette',
  'value' => 'a:9:{s:3:"top";s:7:"#d0d0d0";s:6:"bottom";s:7:"#c2c4c5";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#cccccc";s:6:"footer";s:7:"#24272c";s:11:"titleslogan";s:7:"#000000";s:4:"text";s:7:"#4a4a4a";s:4:"link";s:7:"#019dbf";}',
))
->values(array(
  'name' => 'color_bartik_screenshot',
  'value' => 's:72:"/var/www/drupal/sites/default/files/color/bartik-b69cfcec/screenshot.png";',
))
->values(array(
  'name' => 'color_bartik_stylesheets',
  'value' => 'a:1:{i:0;s:41:"public://color/bartik-e0e23ad7/colors.css";}',
))
->values(array(
  'name' => 'color_garland_files',
  'value' => 'a:19:{i:0;s:50:"public://color/garland-b69cfcec/menu-collapsed.gif";i:1;s:54:"public://color/garland-b69cfcec/menu-collapsed-rtl.gif";i:2;s:49:"public://color/garland-b69cfcec/menu-expanded.gif";i:3;s:45:"public://color/garland-b69cfcec/menu-leaf.gif";i:4;s:67:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/body.png";i:5;s:69:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-bar.png";i:6;s:75:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-bar-white.png";i:7;s:69:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-tab.png";i:8;s:76:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation.png";i:9;s:78:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content-left.png";i:10;s:79:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content-right.png";i:11;s:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content.png";i:12;s:81:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation-item.png";i:13;s:87:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation-item-hover.png";i:14;s:77:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/gradient-inner.png";i:15;s:67:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/logo.png";i:16;s:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/screenshot.png";i:17;s:41:"public://color/garland-b69cfcec/style.css";i:18;s:45:"public://color/garland-b69cfcec/style-rtl.css";}',
))
->values(array(
  'name' => 'color_garland_logo',
  'value' => 's:40:"public://color/garland-b69cfcec/logo.png";',
))
->values(array(
  'name' => 'color_garland_palette',
  'value' => 'a:5:{s:4:"base";s:7:"#d0cb9a";s:4:"link";s:7:"#917803";s:3:"top";s:7:"#efde01";s:6:"bottom";s:7:"#e6fb2d";s:4:"text";s:7:"#494949";}',
))
->values(array(
  'name' => 'color_garland_screenshot',
  'value' => 's:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/screenshot.png";',
))
->values(array(
  'name' => 'color_garland_stylesheets',
  'value' => 'a:2:{i:0;s:41:"public://color/garland-b69cfcec/style.css";i:1;s:45:"public://color/garland-b69cfcec/style-rtl.css";}',
))
->values(array(
  'name' => 'comment_anonymous_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_blog',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_book',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_forum',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_test_content_type',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_article',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_blog',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_book',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_default_mode_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_book',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_test_content_type',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_per_page_article',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_blog',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_book',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_forum',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_page',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_test_content_type',
  'value' => 's:2:"30";',
))
->values(array(
  'name' => 'comment_form_location_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_book',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_test_content_type',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_forum',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_page',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_preview_article',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_blog',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_book',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_forum',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_test_content_type',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_subject_field_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_book',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_test_content_type',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_test_content_type',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'configurable_timezones',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'contact_default_status',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'contact_threshold_limit',
  'value' => 'i:33;',
))
->values(array(
  'name' => 'contact_threshold_window',
  'value' => 'i:7200;',
))
->values(array(
  'name' => 'cron_key',
  'value' => 's:43:"_vWFj-dRR2rNoHDwl7N__J9uZNutDcLz3w4tlPJzRAM";',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1687692570;',
))
->values(array(
  'name' => 'cron_threshold_error',
  'value' => 'i:1209600;',
))
->values(array(
  'name' => 'cron_threshold_warning',
  'value' => 'i:172800;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:6:"rwt5h9";',
))
->values(array(
  'name' => 'ctools_last_cron',
  'value' => 'i:1687692570;',
))
->values(array(
  'name' => 'date_api_version',
  'value' => 's:3:"7.2";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:15:"America/Chicago";',
))
->values(array(
  'name' => 'date_first_day',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'default_nodes_main',
  'value' => 's:2:"10";',
))
->values(array(
  'name' => 'drupal_css_cache_files',
  'value' => 'a:4:{s:64:"823ba1006db72809515d2221cd02ec1075d7b49b0c07f49307b3a7930bfdd9e4";s:64:"public://css/css_xE-rWrJf-fncB6ztZfd2huxqgxu4WO-qwma6Xer30m4.css";s:64:"592db66916e1dd3416cbe95bcb34a5a68775eb0b7cf95e4c858671de35290cc9";s:64:"public://css/css_LS9OUalDR9-d_lCAvF3yUWjNU6yF8ZBm84jEPRvoyuQ.css";s:64:"991e7ea36699c58310909f8fba690fc1413e8762d81bc2a31454d665a6272b36";s:64:"public://css/css__CMQGUKYGt07IVdy07c-8_1H1eWyj3nMycMd410D2is.css";s:64:"ebb3f433ad4107b1ac31e9d7de0f9a5d399040e9f82b6364211dcfaadea158c0";s:64:"public://css/css_Nv0ct-zkzztuah_LbaPFF8ZkdSEk-LxBtTWMm9mN_F8.css";}',
))
->values(array(
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"9eRJWxrMwQ5CufYJjXBZbPGz_t8vPIYRQr18PamdKmM";',
))
->values(array(
  'name' => 'drupal_weight_select_max',
  'value' => 'i:40;',
))
->values(array(
  'name' => 'email__active_tab',
  'value' => 's:27:"edit-email-pending-approval";',
))
->values(array(
  'name' => 'empty_timezone_message',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'entityreference:base-tables',
  'value' => 'a:7:{s:4:"node";a:2:{i:0;s:4:"node";i:1;s:3:"nid";}s:13:"taxonomy_term";a:2:{i:0;s:18:"taxonomy_term_data";i:1;s:3:"tid";}s:7:"comment";a:2:{i:0;s:7:"comment";i:1;s:3:"cid";}s:16:"i18n_translation";a:2:{i:0;s:20:"i18n_translation_set";i:1;s:4:"tsid";}s:4:"file";a:2:{i:0;s:12:"file_managed";i:1;s:3:"fid";}s:19:"taxonomy_vocabulary";a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;s:3:"vid";}s:4:"user";a:2:{i:0;s:5:"users";i:1;s:3:"uid";}}',
))
->values(array(
  'name' => 'entity_cache_tables_created',
  'value' => 'N;',
))
->values(array(
  'name' => 'entity_translation_entity_types',
  'value' => 'a:4:{s:7:"comment";s:7:"comment";s:4:"node";s:4:"node";s:13:"taxonomy_term";s:13:"taxonomy_term";s:4:"user";s:4:"user";}',
))
->values(array(
  'name' => 'entity_translation_settings_comment__comment_node_test_content_type',
  'value' => 'a:5:{s:16:"default_language";s:13:"xx-et-current";s:22:"hide_language_selector";i:1;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
))
->values(array(
  'name' => 'entity_translation_settings_node__test_content_type',
  'value' => 'a:5:{s:16:"default_language";s:3:"und";s:22:"hide_language_selector";i:0;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
))
->values(array(
  'name' => 'entity_translation_settings_taxonomy_term__test_vocabulary',
  'value' => 'a:5:{s:16:"default_language";s:13:"xx-et-default";s:22:"hide_language_selector";i:1;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
))
->values(array(
  'name' => 'entity_translation_settings_user__user',
  'value' => 'a:5:{s:16:"default_language";s:13:"xx-et-default";s:22:"hide_language_selector";i:1;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
))
->values(array(
  'name' => 'entity_translation_taxonomy',
  'value' => 'a:6:{s:15:"test_vocabulary";b:1;s:14:"vocablocalized";b:0;s:14:"vocabtranslate";b:0;s:10:"vocabfixed";b:0;s:54:"vocabulary_name_much_longer_than_thirty_two_characters";b:0;s:15:"vocablocalized2";b:0;}',
))
->values(array(
  'name' => 'error_level',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'feed_default_items',
  'value' => 'i:27;',
))
->values(array(
  'name' => 'feed_item_length',
  'value' => 's:8:"fulltext";',
))
->values(array(
  'name' => 'field_bundle_settings_comment__comment_node_test_content_type',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:2:{s:6:"author";a:1:{s:6:"weight";s:2:"-2";}s:7:"subject";a:1:{s:6:"weight";s:2:"-1";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__article',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__blog',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__test_content_type',
  'value' => 'a:2:{s:10:"view_modes";a:6:{s:6:"teaser";a:1:{s:15:"custom_settings";b:1;}s:4:"full";a:1:{s:15:"custom_settings";b:0;}s:3:"rss";a:1:{s:15:"custom_settings";b:0;}s:12:"search_index";a:1:{s:15:"custom_settings";b:0;}s:13:"search_result";a:1:{s:15:"custom_settings";b:0;}s:5:"print";a:1:{s:15:"custom_settings";b:0;}}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:1:"0";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_user__user',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:2:{s:7:"account";a:1:{s:6:"weight";s:3:"-10";}s:8:"timezone";a:1:{s:6:"weight";s:1:"6";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'file_default_scheme',
  'value' => 's:6:"public";',
))
->values(array(
  'name' => 'file_description_length',
  'value' => 'i:256;',
))
->values(array(
  'name' => 'file_description_type',
  'value' => 's:9:"textfield";',
))
->values(array(
  'name' => 'file_directory_path',
  'value' => 's:19:"sites/default/files";',
))
->values(array(
  'name' => 'file_icon_directory',
  'value' => 's:25:"sites/default/files/icons";',
))
->values(array(
  'name' => 'file_private_path',
  'value' => 's:21:"sites/default/private";',
))
->values(array(
  'name' => 'file_public_path',
  'value' => 's:19:"sites/default/files";',
))
->values(array(
  'name' => 'file_temporary_path',
  'value' => 's:4:"/tmp";',
))
->values(array(
  'name' => 'filter_fallback_format',
  'value' => 's:10:"plain_text";',
))
->values(array(
  'name' => 'forum_block_num_active',
  'value' => 'i:9;',
))
->values(array(
  'name' => 'forum_block_num_new',
  'value' => 'i:4;',
))
->values(array(
  'name' => 'forum_containers',
  'value' => 'a:1:{i:0;s:1:"6";}',
))
->values(array(
  'name' => 'forum_hot_topic',
  'value' => 'i:10;',
))
->values(array(
  'name' => 'forum_nav_vocabulary',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'forum_order',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'forum_per_page',
  'value' => 'i:25;',
))
->values(array(
  'name' => 'i18n_node_options_blog',
  'value' => 'a:2:{i:0;s:8:"required";i:1;s:4:"lock";}',
))
->values(array(
  'name' => 'i18n_string_allowed_formats',
  'value' => 'a:5:{s:13:"filtered_html";s:13:"filtered_html";s:10:"plain_text";s:10:"plain_text";s:18:"custom_text_format";i:0;s:9:"full_html";i:0;s:8:"php_code";i:0;}',
))
->values(array(
  'name' => 'i18n_string_source_language',
  'value' => 's:2:"en";',
))
->values(array(
  'name' => 'i18n_string_textgroup_class_blocks',
  'value' => 's:29:"i18n_string_textgroup_default";',
))
->values(array(
  'name' => 'i18n_string_textgroup_class_taxonomy',
  'value' => 's:29:"i18n_string_textgroup_default";',
))
->values(array(
  'name' => 'i18n_sync_node_type_article',
  'value' => 'a:1:{i:0;s:16:"field_text_plain";}',
))
->values(array(
  'name' => 'i18n_sync_source_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'image_jpeg_quality',
  'value' => 'i:80;',
))
->values(array(
  'name' => 'image_style_preview_image',
  'value' => 's:23:"core/misc/druplicon.png";',
))
->values(array(
  'name' => 'image_toolkit',
  'value' => 's:2:"gd";',
))
->values(array(
  'name' => 'install_profile',
  'value' => 's:8:"standard";',
))
->values(array(
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'name' => 'install_time',
  'value' => 'i:1421694923;',
))
->values(array(
  'name' => 'javascript_parsed',
  'value' => 'a:9:{i:0;s:14:"misc/drupal.js";i:1;s:14:"misc/jquery.js";i:2;s:27:"misc/jquery-extend-3.4.0.js";i:3;s:44:"misc/jquery-html-prefilter-3.5.0-backport.js";i:4;s:19:"misc/jquery.once.js";i:5;s:24:"modules/system/system.js";i:6;s:12:"misc/form.js";s:10:"refresh:fr";s:7:"waiting";s:10:"refresh:is";s:7:"waiting";}',
))
->values(array(
  'name' => 'language_content_type_article',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'language_content_type_a_thirty_two_character_type_name',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'language_content_type_blog',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'language_content_type_et',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'language_content_type_forum',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'language_content_type_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'language_content_type_test_content_type',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'language_count',
  'value' => 'i:3;',
))
->values(array(
  'name' => 'language_default',
  'value' => 'O:8:"stdClass":11:{s:8:"language";s:2:"en";s:4:"name";s:7:"English";s:6:"native";s:7:"English";s:9:"direction";s:1:"0";s:7:"enabled";i:1;s:7:"plurals";s:1:"0";s:7:"formula";s:0:"";s:6:"domain";s:0:"";s:6:"prefix";s:0:"";s:6:"weight";s:1:"0";s:10:"javascript";s:0:"";}',
))
->values(array(
  'name' => 'language_negotiation_language',
  'value' => 'a:3:{s:11:"locale-user";a:2:{s:9:"callbacks";a:1:{s:8:"language";s:25:"locale_language_from_user";}s:4:"file";s:19:"includes/locale.inc";}s:10:"locale-url";a:2:{s:9:"callbacks";a:3:{s:8:"language";s:24:"locale_language_from_url";s:8:"switcher";s:28:"locale_language_switcher_url";s:11:"url_rewrite";s:31:"locale_language_url_rewrite_url";}s:4:"file";s:19:"includes/locale.inc";}s:16:"language-default";a:1:{s:9:"callbacks";a:1:{s:8:"language";s:21:"language_from_default";}}}',
))
->values(array(
  'name' => 'language_negotiation_language_content',
  'value' => 'a:1:{s:16:"locale-interface";a:2:{s:9:"callbacks";a:1:{s:8:"language";s:30:"locale_language_from_interface";}s:4:"file";s:19:"includes/locale.inc";}}',
))
->values(array(
  'name' => 'language_negotiation_language_url',
  'value' => 'a:2:{s:10:"locale-url";a:2:{s:9:"callbacks";a:3:{s:8:"language";s:24:"locale_language_from_url";s:8:"switcher";s:28:"locale_language_switcher_url";s:11:"url_rewrite";s:31:"locale_language_url_rewrite_url";}s:4:"file";s:19:"includes/locale.inc";}s:19:"locale-url-fallback";a:2:{s:9:"callbacks";a:1:{s:8:"language";s:28:"locale_language_url_fallback";}s:4:"file";s:19:"includes/locale.inc";}}',
))
->values(array(
  'name' => 'language_types',
  'value' => 'a:3:{s:8:"language";b:1;s:16:"language_content";b:1;s:12:"language_url";b:0;}',
))
->values(array(
  'name' => 'locale_language_negotiation_session_param',
  'value' => 's:8:"language";',
))
->values(array(
  'name' => 'locale_language_negotiation_url_part',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'locale_language_providers_weight_language',
  'value' => 'a:5:{s:10:"locale-url";s:2:"-9";s:14:"locale-session";s:2:"-8";s:11:"locale-user";s:3:"-10";s:14:"locale-browser";s:2:"-7";s:16:"language-default";s:2:"-6";}',
))
->values(array(
  'name' => 'mail_system',
  'value' => 'a:1:{s:14:"default-system";s:17:"DefaultMailSystem";}',
))
->values(array(
  'name' => 'maintenance_mode',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'maintenance_mode_message',
  'value' => 's:42:"This is a custom maintenance mode message.";',
))
->values(array(
  'name' => 'menu_default_active_menus',
  'value' => 'a:4:{i:1;s:9:"main-menu";i:2;s:10:"management";i:3;s:10:"navigation";i:5;s:9:"user-menu";}',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:38:{i:0;i:501;i:1;i:493;i:2;i:250;i:3;i:247;i:4;i:246;i:5;i:245;i:6;i:125;i:7;i:123;i:8;i:122;i:9;i:121;i:10;i:117;i:11;i:108;i:12;i:63;i:13;i:62;i:14;i:61;i:15;i:60;i:16;i:59;i:17;i:58;i:18;i:54;i:19;i:44;i:20;i:31;i:21;i:30;i:22;i:29;i:23;i:26;i:24;i:24;i:25;i:22;i:26;i:21;i:27;i:15;i:28;i:14;i:29;i:13;i:30;i:11;i:31;i:10;i:32;i:7;i:33;i:6;i:34;i:5;i:35;i:3;i:36;i:2;i:37;i:1;}',
))
->values(array(
  'name' => 'menu_options_article',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_blog',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_book',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_forum',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_page',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_test_content_type',
  'value' => 'a:4:{i:0;s:9:"main-menu";i:1;s:10:"management";i:2;s:10:"navigation";i:3;s:9:"user-menu";}',
))
->values(array(
  'name' => 'menu_override_parent_selector',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'menu_parent_article',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_blog',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_book',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_forum',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_page',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_test_content_type',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'node_admin_theme',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_cron_last',
  'value' => 's:10:"1564543706";',
))
->values(array(
  'name' => 'node_options_article',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_blog',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_book',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:8:"revision";}',
))
->values(array(
  'name' => 'node_options_forum',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_page',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_test_content_type',
  'value' => 'a:3:{i:0;s:6:"status";i:1;s:7:"promote";i:2;s:8:"revision";}',
))
->values(array(
  'name' => 'node_preview_article',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_blog',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_book',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_forum',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_test_content_type',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_rank_comments',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_promote',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_relevance',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'node_rank_sticky',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_views',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_submitted_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_book',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'node_submitted_test_content_type',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'page_cache_maximum_age',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'page_compression',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'path_alias_whitelist',
  'value' => 'a:3:{s:8:"taxonomy";b:1;s:4:"node";b:1;s:5:"admin";b:1;}',
))
->values(array(
  'name' => 'preprocess_css',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'preprocess_js',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'save_continue_test_content_type',
  'value' => 's:19:"Save and add fields";',
))
->values(array(
  'name' => 'search_active_modules',
  'value' => 'a:2:{s:4:"node";s:4:"node";s:4:"user";i:0;}',
))
->values(array(
  'name' => 'search_and_or_limit',
  'value' => 'i:7;',
))
->values(array(
  'name' => 'search_default_module',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'search_tag_weights',
  'value' => 'a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:12;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}',
))
->values(array(
  'name' => 'site_403',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_404',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_default_country',
  'value' => 's:2:"US";',
))
->values(array(
  'name' => 'site_frontpage',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:23:"joseph@flattandsons.com";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:13:"The Site Name";',
))
->values(array(
  'name' => 'site_slogan',
  'value' => 's:10:"The Slogan";',
))
->values(array(
  'name' => 'statistics_count_content_views',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'statistics_count_content_views_ajax',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_day_timestamp',
  'value' => 'i:1687692570;',
))
->values(array(
  'name' => 'statistics_enable_access_log',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'statistics_flush_accesslog_timer',
  'value' => 's:4:"3600";',
))
->values(array(
  'name' => 'suppress_itok_output',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'taxonomy_override_selector',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'taxonomy_terms_per_page_admin',
  'value' => 'i:84;',
))
->values(array(
  'name' => 'teaser_length',
  'value' => 'i:1024;',
))
->values(array(
  'name' => 'theme_bartik_settings',
  'value' => 'a:18:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:1;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:1;s:12:"default_logo";i:0;s:9:"logo_path";s:16:"public://gnu.png";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:6:"scheme";s:7:"default";s:7:"palette";a:9:{s:3:"top";s:7:"#0779bf";s:6:"bottom";s:7:"#48a9e4";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f6f6f2";s:14:"sidebarborders";s:7:"#f9f9f9";s:6:"footer";s:7:"#292929";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0071B3";}s:5:"theme";s:6:"bartik";s:4:"info";a:12:{s:6:"fields";a:9:{s:3:"top";s:10:"Header top";s:6:"bottom";s:13:"Header bottom";s:2:"bg";s:15:"Main background";s:7:"sidebar";s:18:"Sidebar background";s:14:"sidebarborders";s:15:"Sidebar borders";s:6:"footer";s:17:"Footer background";s:11:"titleslogan";s:16:"Title and slogan";s:4:"text";s:10:"Text color";s:4:"link";s:10:"Link color";}s:7:"schemes";a:6:{s:7:"default";a:2:{s:5:"title";s:21:"Blue Lagoon (default)";s:6:"colors";a:9:{s:3:"top";s:7:"#0779bf";s:6:"bottom";s:7:"#48a9e4";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f6f6f2";s:14:"sidebarborders";s:7:"#f9f9f9";s:6:"footer";s:7:"#292929";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0071B3";}}s:9:"firehouse";a:2:{s:5:"title";s:9:"Firehouse";s:6:"colors";a:9:{s:3:"top";s:7:"#cd2d2d";s:6:"bottom";s:7:"#cf3535";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f1f4f0";s:14:"sidebarborders";s:7:"#ededed";s:6:"footer";s:7:"#1f1d1c";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#d6121f";}}s:3:"ice";a:2:{s:5:"title";s:3:"Ice";s:6:"colors";a:9:{s:3:"top";s:7:"#d0d0d0";s:6:"bottom";s:7:"#c2c4c5";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#cccccc";s:6:"footer";s:7:"#24272c";s:11:"titleslogan";s:7:"#000000";s:4:"text";s:7:"#4a4a4a";s:4:"link";s:7:"#019dbf";}}s:4:"plum";a:2:{s:5:"title";s:4:"Plum";s:6:"colors";a:9:{s:3:"top";s:7:"#4c1c58";s:6:"bottom";s:7:"#593662";s:2:"bg";s:7:"#fffdf7";s:7:"sidebar";s:7:"#edede7";s:14:"sidebarborders";s:7:"#e7e7e7";s:6:"footer";s:7:"#2c2c28";s:11:"titleslogan";s:7:"#ffffff";s:4:"text";s:7:"#301313";s:4:"link";s:7:"#9d408d";}}s:5:"slate";a:2:{s:5:"title";s:5:"Slate";s:6:"colors";a:9:{s:3:"top";s:7:"#4a4a4a";s:6:"bottom";s:7:"#4e4e4e";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#d0d0d0";s:6:"footer";s:7:"#161617";s:11:"titleslogan";s:7:"#ffffff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0073b6";}}s:0:"";a:2:{s:5:"title";s:6:"Custom";s:6:"colors";a:0:{}}}s:3:"css";a:1:{i:0;s:14:"css/colors.css";}s:4:"copy";a:1:{i:0;s:8:"logo.png";}s:9:"gradients";a:1:{i:0;a:3:{s:9:"dimension";a:4:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;}s:9:"direction";s:8:"vertical";s:6:"colors";a:2:{i:0;s:3:"top";i:1;s:6:"bottom";}}}s:4:"fill";a:0:{}s:6:"slices";a:0:{}s:12:"blend_target";s:7:"#ffffff";s:11:"preview_css";s:17:"color/preview.css";s:10:"preview_js";s:16:"color/preview.js";s:12:"preview_html";s:18:"color/preview.html";s:10:"base_image";s:14:"color/base.png";}}',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:6:"bartik";',
))
->values(array(
  'name' => 'theme_settings',
  'value' => 'a:16:{s:11:"toggle_logo";i:0;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:32:"toggle_comment_user_verification";i:0;s:14:"toggle_favicon";i:0;s:16:"toggle_main_menu";i:0;s:21:"toggle_secondary_menu";i:0;s:12:"default_logo";i:1;s:9:"logo_path";s:23:"public://customlogo.png";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:0;s:12:"favicon_path";s:24:"public://somefavicon.png";s:14:"favicon_upload";s:0:"";s:16:"favicon_mimetype";s:9:"image/png";}',
))
->values(array(
  'name' => 'theme_seven_settings',
  'value' => 'a:15:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:0;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:0;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";}',
))
->values(array(
  'name' => 'user_admin_role',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'user_cancel_method',
  'value' => 's:17:"user_cancel_block";',
))
->values(array(
  'name' => 'user_default_timezone',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'user_email_verification',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_failed_login_identifier_uid_only',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'user_failed_login_ip_limit',
  'value' => 'i:30;',
))
->values(array(
  'name' => 'user_failed_login_ip_window',
  'value' => 'i:7200;',
))
->values(array(
  'name' => 'user_failed_login_user_limit',
  'value' => 'i:22;',
))
->values(array(
  'name' => 'user_failed_login_user_window',
  'value' => 'i:86400;',
))
->values(array(
  'name' => 'user_mail_cancel_confirm_body',
  'value' => 's:55:"A little birdie said you wanted to cancel your account.";',
))
->values(array(
  'name' => 'user_mail_cancel_confirm_subject',
  'value' => 's:13:"Are you sure?";',
))
->values(array(
  'name' => 'user_mail_password_reset_body',
  'value' => "s:32:\"Nope! You're locked out forever.\";",
))
->values(array(
  'name' => 'user_mail_password_reset_subject',
  'value' => 's:17:"Fix your password";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_body',
  'value' => 's:30:"...and it could be taken away.";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 's:24:"Gawd made you an account";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => 's:59:"You can now log in if you can figure out how to use Drupal!";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 's:8:"Welcome!";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_body',
  'value' => 's:61:"...you will join our Circle. Let the Drupal flow through you.";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 's:7:"Soon...";',
))
->values(array(
  'name' => 'user_mail_status_activated_body',
  'value' => 's:57:"Your account was activated, and there was much rejoicing.";',
))
->values(array(
  'name' => 'user_mail_status_activated_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_activated_subject',
  'value' => 's:25:"Your account is approved!";',
))
->values(array(
  'name' => 'user_mail_status_blocked_body',
  'value' => 's:72:"You no longer please the robot overlords. Go to your room and chill out.";',
))
->values(array(
  'name' => 'user_mail_status_blocked_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_blocked_subject',
  'value' => 's:7:"BEGONE!";',
))
->values(array(
  'name' => 'user_mail_status_canceled_body',
  'value' => 's:75:"The gates of Drupal are closed to you. Now you will work in the salt mines.";',
))
->values(array(
  'name' => 'user_mail_status_canceled_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_canceled_subject',
  'value' => 's:12:"So long, bub";',
))
->values(array(
  'name' => 'user_pictures',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_picture_default',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_dimensions',
  'value' => 's:9:"1024x1024";',
))
->values(array(
  'name' => 'user_picture_file_size',
  'value' => 's:3:"800";',
))
->values(array(
  'name' => 'user_picture_guidelines',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_path',
  'value' => 's:8:"pictures";',
))
->values(array(
  'name' => 'user_picture_style',
  'value' => 's:9:"thumbnail";',
))
->values(array(
  'name' => 'user_register',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'user_signatures',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'variable_module_list',
  'value' => 'a:4:{s:6:"locale";a:5:{i:0;s:29:"language_content_type_article";i:1;s:26:"language_content_type_page";i:2;s:26:"language_content_type_book";i:3;s:39:"language_content_type_test_content_type";i:4;s:16:"language_default";}s:4:"i18n";a:1:{i:0;s:18:"i18n_language_list";}s:14:"variable_realm";a:4:{i:0;s:26:"variable_realm_list_global";i:1;s:28:"variable_realm_list_language";i:2;s:28:"variable_realm_weight_global";i:3;s:30:"variable_realm_weight_language";}s:13:"i18n_variable";a:2:{i:0;s:18:"i18n_variable_conf";i:1;s:18:"i18n_variable_list";}}',
))
->values(array(
  'name' => 'variable_realm_list_language',
  'value' => 'a:3:{i:0;s:9:"site_name";i:1;s:11:"site_slogan";i:2;s:24:"maintenance_mode_message";}',
))
->execute();
$connection->schema()->createTable('variable_store', array(
  'fields' => array(
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'realm_key' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'realm',
    'realm_key',
    'name',
  ),
  'indexes' => array(
    'realm_value' => array(
      'realm',
      'realm_key',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable_store')
->fields(array(
  'realm',
  'realm_key',
  'name',
  'value',
  'serialized',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'en',
  'name' => 'user_default_timezone',
  'value' => '2',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_403',
  'value' => 'node',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_404',
  'value' => 'node',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_frontpage',
  'value' => 'node',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_name',
  'value' => 'The Site Name',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_slogan',
  'value' => 'fr - The Slogan',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'user_default_timezone',
  'value' => '0',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'anonymous',
  'value' => 'is - anonymous',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'maintenance_mode_message',
  'value' => 'is - This is a custom maintenance mode message.',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_403',
  'value' => 'node/1',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_404',
  'value' => 'node/6',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_frontpage',
  'value' => 'node/4',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_name',
  'value' => 'is - The Site Name',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_slogan',
  'value' => 'is - The Slogan',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_cancel_confirm_body',
  'value' => 'is - A little birdie said you wanted to cancel your account.',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_cancel_confirm_subject',
  'value' => 'is - Are you sure?',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_password_reset_body',
  'value' => "is - Nope! You're locked out forever.",
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_password_reset_subject',
  'value' => 'is - Fix your password',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_admin_created_body',
  'value' => "is - ...and it could be taken away.\r\n[site:name], [site:url]",
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 'is - Gawd made you an account',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => 'is - You can now log in if you can figure out how to use Drupal!',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 'is - Welcome!',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_pending_approval_body',
  'value' => 'is - ...you will join our Circle. Let the Drupal flow through you.',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 'is - Soon...',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_activated_body',
  'value' => 'is - Your account was activated, and there was much rejoicing.',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_activated_subject',
  'value' => 'is - Your account is approved!',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_blocked_body',
  'value' => 'is - You no longer please the robot overlords. Go to your room and chill out.',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_blocked_subject',
  'value' => 'is - BEGONE!',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_canceled_body',
  'value' => 'is - The gates of Drupal are closed to you. Now you will work in the salt mines.',
  'serialized' => '0',
))
->values(array(
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_canceled_subject',
  'value' => 'is - So long, bub',
  'serialized' => '0',
))
->execute();

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
