<?php

declare(strict_types=1);

namespace Drupal\Tests\image\Kernel\Migrate\d6;

use Drupal\node\Entity\Node;
use Drupal\Tests\file\Kernel\Migrate\d6\FileMigrationTestTrait;
use Drupal\Tests\node\Kernel\Migrate\d6\MigrateNodeTestBase;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Image migration test.
 *
 * This extends the node test, because the D6 fixture has images; they just
 * need to be migrated into D8.
 */
#[Group('migrate_drupal_6')]
#[RunTestsInSeparateProcesses]
class MigrateImageTest extends MigrateNodeTestBase {

  use FileMigrationTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['menu_ui'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->setUpMigratedFiles();
    $this->installSchema('file', ['file_usage']);
    $this->executeMigrations([
      'd6_node',
    ]);
  }

  /**
   * Tests image migration from Drupal 6 to 8.
   */
  public function testNode(): void {
    $node = Node::load(9);
    // Test the image field sub fields.
    $this->assertSame('2', $node->field_test_imagefield->target_id);
    $this->assertSame('Test alt', $node->field_test_imagefield->alt);
    $this->assertSame('Test title', $node->field_test_imagefield->title);
    $this->assertSame('80', $node->field_test_imagefield->width);
    $this->assertSame('60', $node->field_test_imagefield->height);
  }

}
